/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class VersionLockingPolicy
implements OptimisticLockingPolicy,
Serializable {
    protected DatabaseField writeLockField;
    protected boolean isCascaded;
    protected int lockValueStored;
    protected ClassDescriptor descriptor;
    protected transient Expression cachedExpression;
    public static final int IN_CACHE = 1;
    public static final int IN_OBJECT = 2;
    protected AbstractDirectMapping lockMapping;

    public VersionLockingPolicy() {
        this.storeInCache();
    }

    public VersionLockingPolicy(String fieldName) {
        this(new DatabaseField(fieldName));
    }

    public VersionLockingPolicy(DatabaseField field) {
        this();
        this.setWriteLockField(field);
    }

    public void addLockFieldsToUpdateRow(AbstractRecord databaseRow, AbstractSession session) {
        if (this.isStoredInCache()) {
            databaseRow.put(this.getWriteLockField(), (Object)null);
        }
    }

    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery query) {
        Object value = this.isStoredInCache() ? query.getSession().getIdentityMapAccessorInstance().getWriteLockValue(query.getPrimaryKey(), query.getObject().getClass(), this.getDescriptor()) : this.lockValueFromObject(query.getObject());
        if (value == null) {
            if (query.isDeleteObjectQuery()) {
                throw OptimisticLockException.noVersionNumberWhenDeleting(query.getObject(), query);
            }
            throw OptimisticLockException.noVersionNumberWhenUpdating(query.getObject(), query);
        }
        query.getTranslationRow().put(this.writeLockField, value);
    }

    public Expression buildDeleteExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row) {
        return this.buildUpdateExpression(table, mainExpression, row, null);
    }

    protected Expression buildExpression() {
        ExpressionBuilder builder = new ExpressionBuilder();
        return builder.getField(this.getWriteLockField()).equal(builder.getParameter(this.getWriteLockField()));
    }

    public Expression buildUpdateExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row, AbstractRecord row2) {
        if (this.cachedExpression == null) {
            this.cachedExpression = this.buildExpression();
        }
        if (this.getWriteLockField().getTableName().equals(table.getName())) {
            return mainExpression.and(this.cachedExpression);
        }
        return mainExpression;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean supportsWriteLockValuesComparison() {
        return true;
    }

    public int compareWriteLockValues(Object value1, Object value2) {
        BigDecimal bigDecimalValue1 = value1 instanceof BigDecimal ? (BigDecimal)value1 : new BigDecimal(((Number)value1).longValue());
        BigDecimal bigDecimalValue2 = value2 instanceof BigDecimal ? (BigDecimal)value2 : new BigDecimal(((Number)value2).longValue());
        return bigDecimalValue1.compareTo(bigDecimalValue2);
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.BIGDECIMAL;
    }

    public Object getBaseValue() {
        return new BigDecimal(0);
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected Object getInitialWriteValue(AbstractSession session) {
        return new BigDecimal(1);
    }

    protected Object getNewLockValue(ModifyQuery query) {
        Class objectClass = query.getDescriptor().getJavaClass();
        Number newWriteLockValue = null;
        Number value = this.isStoredInCache() ? (Number)((Number)query.getSession().getIdentityMapAccessorInstance().getWriteLockValue(((WriteObjectQuery)query).getPrimaryKey(), objectClass, this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(((ObjectLevelModifyQuery)query).getObject()));
        if (value == null) {
            throw OptimisticLockException.noVersionNumberWhenUpdating(((ObjectLevelModifyQuery)query).getObject(), (ObjectLevelModifyQuery)query);
        }
        newWriteLockValue = this.incrementWriteLockValue(value);
        return newWriteLockValue;
    }

    protected Vector getUnmappedFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        if (this.isStoredInCache()) {
            fields.addElement(this.getWriteLockField());
        }
        return fields;
    }

    public Object getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return row.get(this.getWriteLockField());
        }
        return null;
    }

    public int getVersionDifference(Object currentValue, Object domainObject, Vector primaryKeys, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject));
        if (newWriteLockFieldValue instanceof Long) {
            long writeLockFieldValueLong = 0L;
            if (writeLockFieldValue != null) {
                writeLockFieldValueLong = writeLockFieldValue.longValue();
            }
            return (int)(newWriteLockFieldValue.longValue() - writeLockFieldValueLong);
        }
        if (writeLockFieldValue == null) {
            writeLockFieldValue = new BigDecimal(0);
        }
        if (!(writeLockFieldValue instanceof BigDecimal)) {
            writeLockFieldValue = new BigDecimal(writeLockFieldValue.longValue());
        }
        if (!(newWriteLockFieldValue instanceof BigDecimal)) {
            newWriteLockFieldValue = new BigDecimal(newWriteLockFieldValue.longValue());
        }
        return ((BigDecimal)newWriteLockFieldValue).subtract((BigDecimal)writeLockFieldValue).intValue();
    }

    public DatabaseField getWriteLockField() {
        return this.writeLockField;
    }

    public String getWriteLockFieldName() {
        return this.getWriteLockField().getQualifiedName();
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder) {
        return ExpressionMath.add(builder.getField(this.writeLockField.getName()), 1);
    }

    public Object getWriteLockValue(Object domainObject, Vector primaryKey, AbstractSession session) {
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject));
        return writeLockFieldValue;
    }

    protected Number incrementWriteLockValue(Number numberValue) {
        if (numberValue instanceof Long) {
            return new Long(numberValue.longValue() + 1L);
        }
        BigDecimal writeLockValue = numberValue instanceof BigDecimal ? (BigDecimal)numberValue : new BigDecimal(numberValue.longValue());
        return writeLockValue.add(new BigDecimal(1));
    }

    public void initialize(AbstractSession session) {
        DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForField(this.getWriteLockField());
        if (mapping == null) {
            if (this.isStoredInObject()) {
                if (this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()) != null) {
                    mapping = this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()).get(0);
                    session.getIntegrityChecker().handleError(DescriptorException.mappingCanNotBeReadOnly(mapping));
                } else {
                    session.getIntegrityChecker().handleError(OptimisticLockException.mustHaveMappingWhenStoredInObject(this.descriptor.getJavaClass()));
                }
            } else {
                return;
            }
        }
        if (this.isStoredInCache()) {
            session.getIntegrityChecker().handleError(DescriptorException.mustBeReadOnlyMappingWhenStoredInCache(mapping));
        }
        if (mapping.isDirectToFieldMapping() && this.descriptor.getObjectBuilder().getReadOnlyMappingsForField(this.getWriteLockField()) == null) {
            this.lockMapping = (AbstractDirectMapping)mapping;
        }
    }

    public void initializeProperties() {
        DatabaseField dbField = this.getWriteLockField();
        dbField = this.descriptor.buildField(dbField);
        this.setWriteLockField(dbField);
        if (this.isStoredInCache() && dbField.getType() == null) {
            dbField.setType(this.getDefaultLockingFieldType());
        }
        Enumeration enumtr = this.getUnmappedFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField lockField = (DatabaseField)enumtr.nextElement();
            this.descriptor.getFields().addElement(lockField);
        }
    }

    public boolean isCascaded() {
        return this.isCascaded;
    }

    public boolean isChildWriteLockValueGreater(AbstractSession session, Vector primaryKey, Class original, ObjectChangeSet changeSet) {
        if (this.isStoredInCache()) {
            Number writeLockValue = (Number)changeSet.getWriteLockValue();
            Number parentValue = (Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, original, this.getDescriptor());
            if (parentValue != null && !(parentValue instanceof BigDecimal)) {
                parentValue = new BigDecimal(parentValue.longValue());
            }
            if (writeLockValue != null && !(writeLockValue instanceof BigDecimal)) {
                writeLockValue = new BigDecimal(writeLockValue.longValue());
            }
            if (writeLockValue != null && (parentValue == null || ((BigDecimal)parentValue).compareTo((BigDecimal)writeLockValue) == -1)) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object currentValue, Object domainObject, Vector primaryKey, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)currentValue;
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject));
        if (writeLockFieldValue == null) {
            return false;
        }
        if (newWriteLockFieldValue == null) {
            return true;
        }
        if (!(writeLockFieldValue instanceof BigDecimal)) {
            writeLockFieldValue = new BigDecimal(writeLockFieldValue.longValue());
        }
        if (!(newWriteLockFieldValue instanceof BigDecimal)) {
            newWriteLockFieldValue = new BigDecimal(newWriteLockFieldValue.longValue());
        }
        return ((BigDecimal)newWriteLockFieldValue).compareTo((BigDecimal)writeLockFieldValue) == 1;
    }

    public boolean isNewerVersion(AbstractRecord databaseRow, Object domainObject, Vector primaryKey, AbstractSession session) {
        Number newWriteLockFieldValue = (Number)databaseRow.get(this.getWriteLockField());
        Number writeLockFieldValue = this.isStoredInCache() ? (Number)((Number)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor())) : (Number)((Number)this.lockValueFromObject(domainObject));
        if (writeLockFieldValue == null) {
            return false;
        }
        if (newWriteLockFieldValue == null) {
            return true;
        }
        if (!(writeLockFieldValue instanceof BigDecimal)) {
            writeLockFieldValue = new BigDecimal(writeLockFieldValue.longValue());
        }
        if (!(newWriteLockFieldValue instanceof BigDecimal)) {
            newWriteLockFieldValue = new BigDecimal(newWriteLockFieldValue.longValue());
        }
        return ((BigDecimal)newWriteLockFieldValue).compareTo((BigDecimal)writeLockFieldValue) == 1;
    }

    public boolean isStoredInCache() {
        return this.lockValueStored == 1;
    }

    public boolean isStoredInObject() {
        return this.lockValueStored == 2;
    }

    protected Object lockValueFromObject(Object domainObject) {
        if (this.lockMapping != null) {
            return this.lockMapping.getAttributeValueFromObject(domainObject);
        }
        return this.descriptor.getObjectBuilder().getBaseValueForField(this.writeLockField, domainObject);
    }

    public void mergeIntoParentCache(UnitOfWorkImpl uow, Vector primaryKey, Object object) {
        if (this.isStoredInCache()) {
            Object parentValue = uow.getParent().getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, object.getClass(), this.getDescriptor());
            uow.getIdentityMapAccessor().updateWriteLockValue(primaryKey, object.getClass(), parentValue);
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setIsStoredInCache(boolean isStoredInCache) {
        if (isStoredInCache) {
            this.storeInCache();
        } else {
            this.storeInObject();
        }
    }

    public void setIsCascaded(boolean isCascaded) {
        this.isCascaded = isCascaded;
    }

    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery query) {
        Object lockValue = this.getInitialWriteValue(query.getSession());
        ObjectChangeSet objectChangeSet = query.getObjectChangeSet();
        if (objectChangeSet != null) {
            objectChangeSet.setInitialWriteLockValue(lockValue);
        }
        this.updateWriteLockValueForWrite(query, lockValue);
    }

    protected void updateWriteLockValueForWrite(ObjectLevelModifyQuery query, Object lockValue) {
        query.getModifyRow().put(this.writeLockField, lockValue);
        AbstractSession session = query.getSession();
        Object object = query.getObject();
        ObjectChangeSet objectChangeSet = query.getObjectChangeSet();
        if (objectChangeSet == null && session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null) {
            objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
        }
        if (this.lockMapping != null) {
            this.lockMapping.setAttributeValueInObject(object, this.lockMapping.getAttributeValue(lockValue, session));
            if (objectChangeSet != null) {
                objectChangeSet.setWriteLockValue(lockValue);
                objectChangeSet.updateChangeRecordForAttribute(this.lockMapping, lockValue, session);
            }
        } else {
            ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
            AbstractRecord record = objectBuilder.createRecord(1, session);
            record.put(this.writeLockField, lockValue);
            objectBuilder.assignReturnRow(object, session, record);
            if (objectChangeSet != null) {
                objectChangeSet.setWriteLockValue(lockValue);
                query.getQueryMechanism().updateChangeSet(this.descriptor, objectChangeSet, record, object);
            }
        }
    }

    public void setWriteLockField(DatabaseField writeLockField) {
        this.writeLockField = writeLockField;
    }

    public void setWriteLockFieldName(String writeLockFieldName) {
        this.setWriteLockField(new DatabaseField(writeLockFieldName));
    }

    public void storeInCache() {
        this.lockValueStored = 1;
    }

    public void storeInObject() {
        this.lockValueStored = 2;
    }

    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery query, Object domainObject) {
        Object lockValue = this.getNewLockValue(query);
        if (this.isStoredInCache()) {
            query.getSession().getIdentityMapAccessor().updateWriteLockValue(query.getPrimaryKey(), domainObject.getClass(), lockValue);
        }
        this.updateWriteLockValueForWrite(query, lockValue);
    }

    public void writeLockValueIntoRow(ObjectLevelModifyQuery query, Object domainObject) {
        Object lockValue = this.getWriteLockValue(domainObject, query.getPrimaryKey(), query.getSession());
        query.getModifyRow().put(this.writeLockField, lockValue);
        if (this.isStoredInCache()) {
            query.getSession().getIdentityMapAccessor().updateWriteLockValue(query.getPrimaryKey(), domainObject.getClass(), lockValue);
        }
    }

    public void validateDelete(int rowCount, Object object, DeleteObjectQuery query) {
        if (rowCount <= 0) {
            Object cacheVersion;
            Object queryVersion;
            Vector primaryKey = query.getPrimaryKey();
            AbstractSession session = query.getSession().getParentIdentityMapSession(query, true, true);
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, query.getReferenceClass(), query.getDescriptor());
            if (cacheKey != null && cacheKey.getObject() != null && query.getObjectChangeSet() != null && this.compareWriteLockValues(queryVersion = query.getObjectChangeSet().getInitialWriteLockValue(), cacheVersion = this.getWriteLockValue(cacheKey.getObject(), primaryKey, session)) != 0) {
                cacheKey.setInvalidationState(-1);
            }
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, query);
        }
    }

    public void validateUpdate(int rowCount, Object object, WriteObjectQuery query) {
        if (rowCount <= 0) {
            Object cacheVersion;
            Object queryVersion;
            Vector primaryKey = query.getPrimaryKey();
            AbstractSession session = query.getSession().getParentIdentityMapSession(query, true, true);
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, query.getReferenceClass(), query.getDescriptor());
            if (cacheKey != null && cacheKey.getObject() != null && query.getObjectChangeSet() != null && this.compareWriteLockValues(queryVersion = query.getObjectChangeSet().getInitialWriteLockValue(), cacheVersion = this.getWriteLockValue(cacheKey.getObject(), primaryKey, session)) >= 0) {
                cacheKey.setInvalidationState(-1);
            }
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, query);
        }
    }
}

