/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.cmd;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.glassfish.admin.amx.cmd.AMXCommandBase;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="amx-list", metadata="mode=debug")
@I18n(value="amx_list.command")
@Scoped(value=PerLookup.class)
public class AMXListCommand
extends AMXCommandBase
implements AdminCommand {
    protected final String getCmdName() {
        return this.getLocalString("amx_list.command");
    }

    public void _execute(AdminCommandContext context) {
        ObjectName allPattern = JMXUtil.newObjectName("*:*");
        Set<ObjectName> mbeans = JMXUtil.queryNames(this.getMBeanServer(), allPattern, null);
        List<String> mbeanList = JMXUtil.objectNamesToStrings(mbeans);
        Collections.sort(mbeanList);
        ActionReport report = this.getActionReport();
        report.setMessage("Appserver MBeanServer contents");
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        part.setMessage("MBeanServer domains: " + StringUtil.toString(this.getMBeanServer().getDomains()));
        part = report.getTopMessagePart().addChild();
        part.setMessage("MBeanServer mbeans: " + this.getMBeanServer().getMBeanCount());
        ActionReport.MessagePart listHeader = report.getTopMessagePart().addChild();
        listHeader.setMessage(mbeans.size() + " MBeans matching " + JMXUtil.toString(allPattern) + " registered in the appserver MBeanServer");
        for (String on : mbeanList) {
            part = listHeader.addChild();
            part.setMessage(on);
        }
    }
}

