/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.cmd;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Pathnames;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.amx.cmd.AMXCommandBase;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="pndump", metadata="mode=debug")
@Scoped(value=PerLookup.class)
public class PNDumpCommand
extends AMXCommandBase
implements AdminCommand {
    protected final String getCmdName() {
        return this.getLocalString("pget.command");
    }

    public void _execute(AdminCommandContext context) {
        String[] all;
        Pathnames pathnames = this.getDomainRoot().getPathnames();
        Properties params = context.getCommandParameters();
        ActionReport report = this.getActionReport();
        report.setMessage("plist ");
        ActionReport.MessagePart listHeader = report.getTopMessagePart().addChild();
        listHeader.setMessage("Results:");
        StringBuffer buf = new StringBuffer();
        for (String pn : all = pathnames.getAllPathnames()) {
            buf.append("\n" + pn + "\n");
            ActionReport.MessagePart part = listHeader.addChild();
            part.setMessage(pn);
            try {
                AMX amx = pathnames.getPathnameTarget(pn);
                Map<String, String> allValues = pathnames.getPathnameValues(pn);
                for (String pnAttrName : allValues.keySet()) {
                    ActionReport.MessagePart item = part.addChild();
                    String msg = "\t@" + pnAttrName + " = " + allValues.get(pnAttrName);
                    item.setMessage(msg);
                    buf.append(msg + "\n");
                }
            }
            catch (Exception e) {
                part.setMessage(pn + "FAILURE: " + ExceptionUtil.getRootCause(e));
            }
        }
    }
}

