/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ImplUtil {
    private static void debug(String s) {
        System.out.println(s);
    }

    public static void unregisterAMXMBeans(AMX top) {
        if (top == null) {
            throw new IllegalArgumentException();
        }
        MBeanServer mbeanServer = (MBeanServer)Util.getExtra(top).getConnectionSource().getExistingMBeanServerConnection();
        if (top instanceof Container) {
            Set all = ((Container)top).getContaineeSet();
            for (AMX amx : all) {
                ImplUtil.unregisterAMXMBeans(amx);
            }
        }
        ImplUtil.unregisterOneMBean(mbeanServer, Util.getObjectName(top));
    }

    public static void unregisterAMXMBeans(MBeanServer mbs, ObjectName objectName) {
        ImplUtil.unregisterAMXMBeans(ProxyFactory.getInstance(mbs).getProxy(objectName));
    }

    public static boolean unregisterOneMBean(MBeanServer mbeanServer, ObjectName objectName) {
        boolean success = false;
        try {
            ImplUtil.debug("unregisterOneMBean: " + objectName);
            if (mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (JMException e) {
            ImplUtil.debug("unregisterOneMBean: " + objectName + " FAILED: " + ExceptionUtil.toString(e));
        }
        return success;
    }
}

