/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.cli;

import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service(name="monitor")
@I18n(value="monitor.command")
public class Monitor
implements AdminCommand {
    @Param(optional=true)
    private String type;
    @Param(optional=true)
    private String filter;
    @Inject
    private Habitat habitat;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Monitor.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        MonitorContract mContract = null;
        for (MonitorContract m : this.habitat.getAllByContract(MonitorContract.class)) {
            if (!m.getName().equals(this.type)) continue;
            mContract = m;
            break;
        }
        if (mContract != null) {
            mContract.process(report, this.filter);
            return;
        }
        report.setMessage(this.localStrings.getLocalString("monitor.type.error", "No type exists in habitat for the given monitor type {0}", this.type));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }
}

