/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeClientInvokerFactory;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.impl.client.ProbeClientMethodHandleImpl;
import org.glassfish.flashlight.provider.Probe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeClientMediator
implements ProbeClientMediator,
PostConstruct {
    private static ProbeClientMediator _me = new FlashlightProbeClientMediator();
    private AtomicBoolean agentInitialized = new AtomicBoolean(false);
    private AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Object> clients = new ConcurrentHashMap();
    Instrumentation inst = null;

    @Override
    public void postConstruct() {
        _me = this;
    }

    public static ProbeClientMediator getInstance() {
        return _me;
    }

    public static Object getClient(int id) {
        return clients.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<ProbeClientMethodHandle> registerListener(Object listener) {
        if (!this.agentInitialized.get()) {
            AtomicBoolean atomicBoolean = this.agentInitialized;
            synchronized (atomicBoolean) {
                if (!this.agentInitialized.get()) {
                    // empty if block
                }
            }
        }
        int clientID = this.clientIdGenerator.incrementAndGet();
        clients.put(clientID, listener);
        Class<?> clientClz = listener.getClass();
        ArrayList<ProbeClientMethodHandle> pcms = new ArrayList<ProbeClientMethodHandle>();
        for (Method clientMethod : clientClz.getDeclaredMethods()) {
            ProbeListener probeAnn = clientMethod.getAnnotation(ProbeListener.class);
            if (probeAnn == null) continue;
            String probeStr = probeAnn.value();
            String[] probeDesc = probeStr.split(":");
            Probe probe = ProbeRegistry.getInstance().getProbe(probeStr);
            if (probe == null) {
                throw new RuntimeException("Invalid probe desc: " + probeStr);
            }
            ProbeClientInvoker invoker = ProbeClientInvokerFactory.createInvoker(listener, clientMethod, probe);
            ProbeClientMethodHandleImpl hi = new ProbeClientMethodHandleImpl(invoker.getId(), invoker, probe);
            pcms.add(hi);
            probe.addInvoker(invoker);
        }
        return pcms;
    }
}

