/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.javaee.services.ResourceAdapterProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceAdaptersBinder {
    @Inject
    private GlassfishNamingManager manager;
    @Inject
    private Logger logger;
    @Inject
    private Habitat raProxyHabitat;

    public void deployAllJdbcResourcesAndPools(JdbcResource[] jdbcResources, JdbcConnectionPool[] jdbcPools) {
        for (JdbcResource resource : jdbcResources) {
            try {
                JdbcConnectionPool pool = this.getAssociatedJdbcPool(resource.getPoolName(), jdbcPools);
                if (pool == null) {
                    this.logger.log(Level.SEVERE, "Could not get the pool [ " + resource.getPoolName() + " ] of resource [ " + resource.getJndiName() + " ]");
                    continue;
                }
                this.bindResource(resource, pool, resource.getJndiName(), "jdbc");
            }
            catch (NamingException e) {
                this.logger.log(Level.SEVERE, "Cannot bind " + resource.getPoolName() + " to naming manager", e);
            }
        }
    }

    public void deployAllConnectorResourcesAndPools(ConnectorResource[] connectorResources, ConnectorConnectionPool[] connectorPools) {
        for (ConnectorResource resource : connectorResources) {
            try {
                ConnectorConnectionPool pool = this.getAssociatedConnectorPool(resource.getPoolName(), connectorPools);
                if (pool == null) {
                    this.logger.log(Level.SEVERE, "Could not get the pool [ " + resource.getPoolName() + " ] of resource [ " + resource.getJndiName() + " ]");
                    continue;
                }
                this.bindResource(resource, pool, resource.getJndiName(), "cr");
            }
            catch (NamingException e) {
                this.logger.log(Level.SEVERE, "Cannot bind " + resource.getPoolName() + " to naming manager", e);
            }
        }
    }

    public void bindResource(Object resource, Object pool, String resourceName, String resourceType) throws NamingException {
        ResourceAdapterProxy raProxy = this.constructResourceProxy(resource, pool, resourceType, resourceName);
        this.manager.publishObject(resourceName, (Object)raProxy, true);
    }

    private ResourceAdapterProxy constructResourceProxy(Object resource, Object pool, String resourceType, String resourceName) {
        ResourceAdapterProxy raProxy = this.raProxyHabitat.getComponent(ResourceAdapterProxy.class);
        raProxy.setResource(resource);
        raProxy.setConnectionPool(pool);
        raProxy.setResourceType(resourceType);
        raProxy.setResourceName(resourceName);
        return raProxy;
    }

    private JdbcConnectionPool getAssociatedJdbcPool(String poolName, JdbcConnectionPool[] jdbcPools) {
        JdbcConnectionPool result = null;
        for (JdbcConnectionPool pool : jdbcPools) {
            if (!pool.getName().equalsIgnoreCase(poolName)) continue;
            result = pool;
            break;
        }
        return result;
    }

    private ConnectorConnectionPool getAssociatedConnectorPool(String poolName, ConnectorConnectionPool[] connectorPools) {
        ConnectorConnectionPool result = null;
        for (ConnectorConnectionPool pool : connectorPools) {
            if (!pool.getName().equalsIgnoreCase(poolName)) continue;
            result = pool;
            break;
        }
        return result;
    }

    private List<String> getAllPoolNames(JdbcConnectionPool[] pools) {
        ArrayList<String> poolNames = new ArrayList<String>();
        for (JdbcConnectionPool pool : pools) {
            poolNames.add(pool.getName());
        }
        return poolNames;
    }
}

