/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.glassfish.javaee.services.ResourceAdaptersBinder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceManager
implements NamingObjectsProvider,
PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    private JdbcResource[] jdbcResources;
    @Inject
    private JdbcConnectionPool[] jdbcPools;
    @Inject
    private Logger logger;
    @Inject
    private ResourceAdaptersBinder resourcesBinder;
    @Inject
    private Habitat connectorRuntimeHabitat;
    @Inject
    private Resources allResources;
    private ConnectorRuntime runtime;

    @Override
    public void postConstruct() {
        this.resourcesBinder.deployAllJdbcResourcesAndPools(this.jdbcResources, this.jdbcPools);
    }

    @Override
    public void preDestroy() {
        Collection pools = this.getAllSystemRAPools();
        Collection resources = this.getAllSystemRAResources();
        this.getConnectorRuntime().shutdownAllActiveResourceAdapters(pools, resources);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }

    private Collection getAllSystemRAPools() {
        ArrayList<Resource> pools = new ArrayList<Resource>();
        for (Resource resource : this.allResources.getResources()) {
            String raName;
            if (resource instanceof JdbcConnectionPool) {
                pools.add(resource);
                continue;
            }
            if (!(resource instanceof ConnectorConnectionPool) || !ConnectorsUtil.belongsToSystemRA(raName = ((ConnectorConnectionPool)resource).getResourceAdapterName())) continue;
            pools.add(resource);
        }
        return pools;
    }

    private Collection getAllSystemRAResources() {
        ArrayList<Resource> systemRAResources = new ArrayList<Resource>();
        for (Resource resource : this.allResources.getResources()) {
            String poolName;
            String raName;
            if (resource instanceof JdbcResource) {
                systemRAResources.add(resource);
                continue;
            }
            if (!(resource instanceof ConnectorResource) || !ConnectorsUtil.belongsToSystemRA(raName = this.getResourceAdapterNameOfPool(poolName = ((ConnectorResource)resource).getPoolName()))) continue;
            systemRAResources.add(resource);
        }
        return systemRAResources;
    }

    private String getResourceAdapterNameOfPool(String poolName) {
        String raName = "";
        for (Resource resource : this.allResources.getResources()) {
            ConnectorConnectionPool ccp;
            String name;
            if (!(resource instanceof ConnectorConnectionPool) || !(name = (ccp = (ConnectorConnectionPool)resource).getName()).equalsIgnoreCase(poolName)) continue;
            raName = ccp.getResourceAdapterName();
        }
        return raName;
    }

    public Collection<String> getAllPoolNames() {
        ArrayList<String> poolNames = new ArrayList<String>();
        for (Resource resource : this.allResources.getResources()) {
            if (resource instanceof JdbcConnectionPool) {
                poolNames.add(((JdbcConnectionPool)resource).getName());
                continue;
            }
            if (!(resource instanceof ConnectorConnectionPool)) continue;
            poolNames.add(((ConnectorConnectionPool)resource).getName());
        }
        return poolNames;
    }

    public Collection<String> getAllResourceNames() {
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (Resource resource : this.allResources.getResources()) {
            if (resource instanceof JdbcResource) {
                resourceNames.add(((JdbcResource)resource).getJndiName());
                continue;
            }
            if (!(resource instanceof ConnectorResource)) continue;
            resourceNames.add(((ConnectorResource)resource).getJndiName());
        }
        return resourceNames;
    }

    public void deployResourcesForModule(String moduleName) {
        Collection<ConnectorConnectionPool> connectionPools = this.getAllPoolsOfModule(moduleName);
        Collection<String> poolNames = this.getAllPoolNames(connectionPools);
        Collection<ConnectorResource> connectorResources = this.getAllResources(poolNames);
        ConnectorConnectionPool[] pools = new ConnectorConnectionPool[connectionPools.size()];
        ConnectorResource[] resources = new ConnectorResource[connectorResources.size()];
        this.resourcesBinder.deployAllConnectorResourcesAndPools(connectorResources.toArray(resources), connectionPools.toArray(pools));
    }

    public void undeployResourcesForModule(String moduleName) {
        Collection<ConnectorConnectionPool> connectionPools = this.getAllPoolsOfModule(moduleName);
        Collection<String> poolNames = this.getAllPoolNames(connectionPools);
        Collection<ConnectorResource> connectorResources = this.getAllResources(poolNames);
        this.destroyResourcesAndPools(connectorResources, connectionPools);
    }

    private void destroyResourcesAndPools(Collection resources, Collection pools) {
        this.getConnectorRuntime().destroyResourcesAndPools(resources, pools);
    }

    private Collection<ConnectorResource> getAllResources(Collection<String> poolNames) {
        ArrayList<ConnectorResource> connectorResources = new ArrayList<ConnectorResource>();
        for (Resource resource : this.allResources.getResources()) {
            ConnectorResource connectorResource;
            if (!(resource instanceof ConnectorResource) || !poolNames.contains((connectorResource = (ConnectorResource)resource).getPoolName())) continue;
            connectorResources.add(connectorResource);
        }
        return connectorResources;
    }

    private Collection<String> getAllPoolNames(Collection<ConnectorConnectionPool> connectionPools) {
        HashSet<String> poolNames = new HashSet<String>();
        for (ConnectorConnectionPool pool : connectionPools) {
            poolNames.add(pool.getName());
        }
        return poolNames;
    }

    private Collection<ConnectorConnectionPool> getAllPoolsOfModule(String moduleName) {
        ArrayList<ConnectorConnectionPool> connectorConnectionPools = new ArrayList<ConnectorConnectionPool>();
        for (Resource resource : this.allResources.getResources()) {
            ConnectorConnectionPool connectorConnectionPool;
            if (!(resource instanceof ConnectorConnectionPool) || !(connectorConnectionPool = (ConnectorConnectionPool)resource).getResourceAdapterName().equals(moduleName)) continue;
            connectorConnectionPools.add(connectorConnectionPool);
        }
        return connectorConnectionPools;
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> void changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                switch (type) {
                    case ADD: {
                        ResourceManager.this.logger.fine("A new " + changedType.getName() + " was added : " + changedInstance);
                        this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        ResourceManager.this.logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        break;
                    }
                    case REMOVE: {
                        ResourceManager.this.logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        this.handleRemoveEvent(changedInstance);
                    }
                }
            }

            private <T extends ConfigBeanProxy> void handleAddEvent(T instance) {
                if (instance instanceof JdbcConnectionPool) {
                    ResourceManager.this.resourcesBinder.deployAllJdbcResourcesAndPools(new JdbcResource[0], new JdbcConnectionPool[]{(JdbcConnectionPool)instance});
                } else if (instance instanceof JdbcResource) {
                    JdbcResource resource = (JdbcResource)instance;
                    JdbcConnectionPool pool = ResourceManager.this.getAssociatedJdbcConnectionPool(resource);
                    ResourceManager.this.resourcesBinder.deployAllJdbcResourcesAndPools(new JdbcResource[]{resource}, new JdbcConnectionPool[]{pool});
                } else if (instance instanceof ConnectorConnectionPool) {
                    ResourceManager.this.resourcesBinder.deployAllConnectorResourcesAndPools(new ConnectorResource[0], new ConnectorConnectionPool[]{(ConnectorConnectionPool)instance});
                } else if (instance instanceof ConnectorResource) {
                    ConnectorResource resource = (ConnectorResource)instance;
                    ConnectorConnectionPool pool = ResourceManager.this.getAssociatedConnectorConnectionPool(resource);
                    ResourceManager.this.resourcesBinder.deployAllConnectorResourcesAndPools(new ConnectorResource[]{resource}, new ConnectorConnectionPool[]{pool});
                }
            }

            private <T extends ConfigBeanProxy> void handleRemoveEvent(T instance) {
                ArrayList<T> instancesToDestroy = new ArrayList<T>();
                ArrayList dummy = new ArrayList();
                instancesToDestroy.add(instance);
                if (instance instanceof JdbcConnectionPool) {
                    ResourceManager.this.destroyResourcesAndPools(dummy, instancesToDestroy);
                } else if (instance instanceof JdbcResource) {
                    ResourceManager.this.destroyResourcesAndPools(instancesToDestroy, dummy);
                } else if (instance instanceof ConnectorConnectionPool) {
                    ResourceManager.this.destroyResourcesAndPools(dummy, instancesToDestroy);
                } else if (instance instanceof ConnectorResource) {
                    ResourceManager.this.destroyResourcesAndPools(instancesToDestroy, dummy);
                }
            }
        }, this.logger);
        return null;
    }

    private JdbcConnectionPool getAssociatedJdbcConnectionPool(JdbcResource resource) {
        for (Resource configuredResource : this.allResources.getResources()) {
            if (!(configuredResource instanceof JdbcConnectionPool)) continue;
            JdbcConnectionPool pool = (JdbcConnectionPool)configuredResource;
            if (!resource.getPoolName().equalsIgnoreCase(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    private ConnectorConnectionPool getAssociatedConnectorConnectionPool(ConnectorResource resource) {
        for (Resource configuredResource : this.allResources.getResources()) {
            if (!(configuredResource instanceof ConnectorConnectionPool)) continue;
            ConnectorConnectionPool pool = (ConnectorConnectionPool)configuredResource;
            if (!resource.getPoolName().equalsIgnoreCase(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    public JdbcConnectionPool getJdbcConnectionPoolConfig(String poolName) {
        for (Resource configuredResource : this.allResources.getResources()) {
            JdbcConnectionPool pool;
            if (!(configuredResource instanceof JdbcConnectionPool) || !(pool = (JdbcConnectionPool)configuredResource).getName().equalsIgnoreCase(poolName)) continue;
            return pool;
        }
        return null;
    }
}

