/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.rails;

import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.scripting.rails.RailsApplication;
import org.glassfish.scripting.rails.RailsContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class RailsDeployer
implements Deployer<RailsContainer, RailsApplication> {
    @Inject
    ServerEnvironment env;
    @Inject
    RequestDispatcher dispatcher;

    @Override
    public boolean prepare(DeploymentContext context) {
        return true;
    }

    @Override
    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    @Override
    public MetaData getMetaData() {
        return new MetaData(false, null, null, null);
    }

    @Override
    public RailsApplication load(RailsContainer container, DeploymentContext context) {
        String contextRoot = this.getContextRoot(context);
        String railsRoot = context.getSource().getURI().getSchemeSpecificPart();
        RailsApplication adapter = new RailsApplication(this.env, railsRoot, context.getLogger(), contextRoot);
        context.getLogger().info("Loading application " + context.getCommandParameters().getProperty("name") + " at " + contextRoot);
        try {
            this.dispatcher.registerEndpoint(contextRoot, null, adapter, adapter);
        }
        catch (EndpointRegistrationException e) {
            context.getLogger().log(Level.WARNING, "Error registering RailsAdapter", e);
        }
        return adapter;
    }

    @Override
    public void unload(RailsApplication container, DeploymentContext context) {
        try {
            this.dispatcher.unregisterEndpoint(container.getContextRoot());
        }
        catch (EndpointRegistrationException e) {
            context.getLogger().log(Level.SEVERE, "Exception while unloading ruby application", e);
        }
    }

    @Override
    public void clean(DeploymentContext context) {
    }

    private String getContextRoot(DeploymentContext context) {
        String contextRoot = context.getCommandParameters().getProperty("contextroot");
        if (contextRoot == null) {
            contextRoot = this.env.getStartupContext().getArguments().get("--contextroot");
        }
        if (contextRoot == null || contextRoot.length() == 0) {
            contextRoot = "/" + context.getCommandParameters().getProperty("name");
        }
        return contextRoot;
    }
}

