/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.rails.sniffer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.module.impl.CookedModuleDefinition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="rails")
@Scoped(value=Singleton.class)
public class RailsSniffer
implements Sniffer {
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    private final String containerName = "jruby";
    private final String appStigma = "app/controllers/application.rb";
    private final String[] containers = new String[]{"org.glassfish.scripting.rails.RailsContainer"};

    @Override
    public boolean handles(ReadableArchive location, ClassLoader loader) {
        try {
            if (location.exists("app/controllers/application.rb")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Pattern getURLPattern() {
        return null;
    }

    @Override
    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    @Override
    public String getModuleType() {
        return "jruby";
    }

    @Override
    public Module[] setup(String containerHome, Logger logger) throws IOException {
        File rootLocation = new File(containerHome);
        if (!rootLocation.exists()) {
            throw new RuntimeException("JRuby installation not found at " + rootLocation.getPath());
        }
        Module m = null;
        rootLocation = new File(rootLocation, "lib");
        String moduleSystem = System.getProperty("GlassFish_Platform");
        try {
            if (moduleSystem == null || moduleSystem.equals("HK2")) {
                m = this.setUpHk2(rootLocation);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot setup jruby classpath", e);
            throw e;
        }
        Module grizzlyRails = this.registry.makeModuleFor("org.glassfish.scripting.grizzly-jruby-module", null);
        if (grizzlyRails == null) {
            logger.log(Level.SEVERE, "Cannot find module for" + Which.jarFile(this.getClass()).toURI().toString());
            throw new IOException("Cannot find module for" + Which.jarFile(this.getClass()).toURI().toString());
        }
        if (m != null) {
            grizzlyRails.addImport(m);
        }
        Module[] modules = new Module[]{grizzlyRails};
        return modules;
    }

    @Override
    public void tearDown() {
    }

    private Module setUpHk2(File libDirectory) throws IOException {
        Attributes jrubyAttr = new Attributes();
        StringBuffer classpath = new StringBuffer();
        for (File lib : libDirectory.listFiles()) {
            if (!lib.isFile() || lib.getName().equals("jruby.jar") || !lib.getName().endsWith(".jar")) continue;
            classpath.append(lib.getName());
            classpath.append(" ");
        }
        jrubyAttr.putValue(Attributes.Name.CLASS_PATH.toString(), classpath.toString());
        jrubyAttr.putValue("HK2-Bundle-Name", "org.jruby:jruby-complete");
        CookedModuleDefinition jruby = new CookedModuleDefinition(new File(libDirectory, "jruby.jar"), jrubyAttr);
        return this.registry.add(jruby);
    }

    private Module setUpOSGi(File libDirectory) throws IOException {
        File manifestFile = new File(libDirectory, "META-INF/MANIFEST.MF");
        if (!(manifestFile = manifestFile.getCanonicalFile()).exists()) {
            Manifest m = new Manifest();
            m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            m.getMainAttributes().putValue("Bundle-SymbolicName", "org.jruby.jruby");
            StringBuffer classpath = new StringBuffer();
            for (File lib : libDirectory.listFiles()) {
                if (!lib.isFile()) continue;
                classpath.append(lib.getName());
                classpath.append(",");
            }
            m.getMainAttributes().putValue("Bundle-ClassPath", classpath.toString());
            String value = this.getJarPackages(new JarFile(new File(libDirectory + "/jruby.jar")));
            m.getMainAttributes().putValue("Export-Package", value);
            System.out.println("value = " + value);
            try {
                if (!manifestFile.getParentFile().exists() && !manifestFile.getParentFile().mkdirs()) {
                    throw new IOException("Cannot create manifest file in jruby installation, do you have write access ?");
                }
                if (!manifestFile.createNewFile()) {
                    throw new IOException("Cannot create manifest file in jruby installation, do you have write access ?");
                }
                FileOutputStream out = new FileOutputStream(manifestFile);
                m.write(System.out);
                m.write(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Attributes jrubyAttr = new Attributes();
        jrubyAttr.putValue("HK2-Bundle-Name", "org.jruby:jruby-complete");
        CookedModuleDefinition jruby = new CookedModuleDefinition(libDirectory, jrubyAttr);
        return this.registry.add(jruby);
    }

    private String getJarPackages(JarFile jf) throws IOException {
        Enumeration<JarEntry> entries = jf.entries();
        ArrayList<String> jarList = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            String name = e.getName();
            if (!e.getName().endsWith(".class")) continue;
            int index = name.lastIndexOf(46);
            if (jarList.contains(name = (index = (name = name.substring(0, index)).lastIndexOf("/")) == -1 ? "." : name.substring(0, index).replace('/', '.'))) continue;
            jarList.add(name);
        }
        StringBuffer jars = new StringBuffer();
        int i = 1;
        for (String jar : jarList) {
            jars.append(jar);
            if (i++ == jarList.size()) continue;
            jars.append(",");
        }
        return jars.toString();
    }

    @Override
    public String[] getContainersNames() {
        return this.containers;
    }

    @Override
    public boolean isUserVisible() {
        return true;
    }
}

