/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServerEnvironmentImpl
implements ServerEnvironment,
PostConstruct {
    @Inject
    StartupContext startupContext;
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kApplicationDirName = "j2ee-apps";
    public static final String kModuleDirName = "j2ee-modules";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kLoggingPropertiesFileNAme = "logging.properties";
    public static final String kConfigDirName = "config";
    public static final String kInitFileName = "init.conf";
    public static final String DEFAULT_ADMIN_CONSOLE_CONTEXT_ROOT = "/admin";
    public static final String DEFAULT_ADMIN_CONSOLE_APP_NAME = "__admingui";
    private File root;
    private boolean verbose;
    private boolean debug;
    private static final ASenvPropertyReader asenv = new ASenvPropertyReader();
    private String domainName;
    private String instanceName;
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";

    public ServerEnvironmentImpl() {
    }

    public ServerEnvironmentImpl(File root) {
        this.root = root.getAbsoluteFile();
    }

    @Override
    public void postConstruct() {
        if (this.root == null) {
            this.root = new File(System.getProperty(INSTANCE_ROOT_PROP_NAME));
        }
        asenv.getProps().put(INSTANCE_ROOT_PROP_NAME, this.root.getAbsolutePath());
        Map<String, String> args = this.startupContext.getArguments();
        this.verbose = Boolean.parseBoolean(args.get("-verbose"));
        this.debug = Boolean.parseBoolean(args.get("-debug"));
        String s = this.startupContext.getArguments().get("-domainname");
        if (!this.ok(s)) {
            s = this.root.getName();
        }
        this.domainName = s;
        s = this.startupContext.getArguments().get("-instancename");
        this.instanceName = !this.ok(s) ? "server" : s;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public File getDomainRoot() {
        return this.root;
    }

    @Override
    public StartupContext getStartupContext() {
        return this.startupContext;
    }

    @Override
    public File getConfigDirPath() {
        return new File(this.root, kConfigDirName);
    }

    @Override
    public File getApplicationRepositoryPath() {
        return new File(this.root, kRepositoryDirName);
    }

    @Override
    public File getApplicationStubPath() {
        return new File(this.root, kGeneratedDirName);
    }

    public File getInitFilePath() {
        return new File(this.getConfigDirPath(), kInitFileName);
    }

    @Override
    public File getLibPath() {
        return new File(this.root, "lib");
    }

    @Override
    public String getApplicationGeneratedXMLPath() {
        return null;
    }

    @Override
    public File getApplicationCompileJspPath() {
        return new File(this.getApplicationStubPath(), "jsp");
    }

    @Override
    public File getWebModuleCompileJspPath() {
        return this.getApplicationCompileJspPath();
    }

    public String getModuleRepositoryPath() {
        return null;
    }

    public String getJavaWebStartPath() {
        return null;
    }

    public String getApplicationBackupRepositoryPath() {
        return null;
    }

    public String getInstanceClassPath() {
        return null;
    }

    @Override
    public String getModuleStubPath() {
        return null;
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(asenv.getProps());
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public File getDefaultAdminConsoleFolderOnDisk() {
        File install = new File(asenv.getProps().get("com.sun.aas.installRoot"));
        File agp = new File(new File(new File(install, "lib"), "install"), kRepositoryDirName);
        return agp;
    }
}

