/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import javax.servlet.http.HttpSession;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

public class SessionStatsTelemetry {
    private TreeNode sessionTM;
    private TreeNode[] sessionChildren;
    private Counter activeSessionsCurrent = CounterFactory.createCount(new long[0]);
    private Counter activeSessionsHigh = CounterFactory.createCount(new long[0]);
    private Counter sessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter expiredSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter rejectedSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter persistedSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter passivatedSessionsTotal = CounterFactory.createCount(new long[0]);
    private Counter activatedSessionsTotal = CounterFactory.createCount(new long[0]);

    public SessionStatsTelemetry(TreeNode server) {
        this.sessionTM = TreeNodeFactory.createTreeNode("session", this, "web");
        server.addChild(this.sessionTM);
        this.activeSessionsCurrent.setName("activeSessionsCurrent");
        this.sessionTM.addChild(this.activeSessionsCurrent);
        this.sessionsTotal.setName("sessionsTotal");
        this.sessionTM.addChild(this.sessionsTotal);
        this.activeSessionsHigh.setName("activeSessionsHigh");
        this.sessionTM.addChild(this.activeSessionsHigh);
        this.rejectedSessionsTotal.setName("rejectedSessionsTotal");
        this.sessionTM.addChild(this.rejectedSessionsTotal);
        this.expiredSessionsTotal.setName("expiredSessionsTotal");
        this.sessionTM.addChild(this.expiredSessionsTotal);
        this.persistedSessionsTotal.setName("persistedSessionsTotal");
        this.sessionTM.addChild(this.persistedSessionsTotal);
        this.passivatedSessionsTotal.setName("passivatedSessionsTotal");
        this.sessionTM.addChild(this.passivatedSessionsTotal);
        this.activatedSessionsTotal.setName("activatedSessionsTotal");
        this.sessionTM.addChild(this.activatedSessionsTotal);
    }

    public void enableMonitoring(boolean isEnable) {
    }

    public void enableMonitoringForSubElements(boolean isEnable) {
    }

    @ProbeListener(value="web:session::sessionCreatedEvent")
    public void sessionCreatedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.sessionsTotal.increment();
        this.incrementActiveSessionsCurrent();
        System.out.println("[TM]sessionCreatedEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionDestroyedEvent")
    public void sessionDestroyedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.activeSessionsCurrent.decrement();
        System.out.println("[TM]sessionDestroyedEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionRejectedEvent")
    public void sessionRejectedEvent(@ProbeParam(value="maxThresholdSize") int maxSessions, @ProbeParam(value="appName") String appName) {
        this.activeSessionsCurrent.decrement();
        this.rejectedSessionsTotal.increment();
        System.out.println("[TM]sessionRejectedEvent received - max sessions = " + maxSessions + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionExpiredEvent")
    public void sessionExpiredEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        this.activeSessionsCurrent.decrement();
        this.expiredSessionsTotal.increment();
        System.out.println("[TM]sessionExpiredEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionPersistedStartEvent")
    public void sessionPersistedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        System.out.println("[TM]sessionPersistedStartEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionPersistedEndEvent")
    public void sessionPersistedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        this.activeSessionsCurrent.decrement();
        this.persistedSessionsTotal.increment();
        System.out.println("[TM]sessionPersistedEndEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionActivatedStartEvent")
    public void sessionActivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        System.out.println("[TM]sessionActivatedStartEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionActivatedEndEvent")
    public void sessionActivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        this.incrementActiveSessionsCurrent();
        this.activatedSessionsTotal.increment();
        System.out.println("[TM]sessionActivatedEndEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionPassivatedStartEvent")
    public void sessionPassivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        System.out.println("[TM]sessionPassivatedStartEvent  received - session = " + session.toString() + ": appname = " + appName);
    }

    @ProbeListener(value="web:session::sessionPassivatedEndEvent")
    public void sessionPassivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName) {
        this.activeSessionsCurrent.decrement();
        this.passivatedSessionsTotal.increment();
        System.out.println("[TM]sessionPassivatedEndEvent received - session = " + session.toString() + ": appname = " + appName);
    }

    private void incrementActiveSessionsCurrent() {
        this.activeSessionsCurrent.increment();
        if (this.activeSessionsCurrent.getCount() > this.activeSessionsHigh.getCount()) {
            this.activeSessionsHigh.setCount(this.activeSessionsCurrent.getCount());
        }
    }
}

