/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.WebModule;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.Startup;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderListener;
import org.glassfish.web.admin.monitor.telemetry.JVMMemoryStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.SessionStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.ThreadPoolTelemetry;
import org.glassfish.web.admin.monitor.telemetry.WebModuleTelemetry;
import org.glassfish.web.admin.monitor.telemetry.WebRequestTelemetry;
import org.glassfish.web.admin.monitor.telemetry.WebTelemetry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class WebMonitorStartup
implements Startup,
PostConstruct,
ProbeProviderListener {
    @Inject
    private ProbeProviderEventManager ppem;
    @Inject
    private ProbeClientMediator pcm;
    private WebTelemetry webTM = null;
    private SessionStatsTelemetry sessionsTM = null;
    private WebRequestTelemetry webRequestTM = null;
    private ThreadPoolTelemetry threadPoolTM = null;
    private WebModuleTelemetry moduleTM = null;
    private JVMMemoryStatsTelemetry jvmMemoryTM;
    private Collection<ProbeClientMethodHandle> handles;
    @Inject
    private Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    private TreeNode server;
    private TreeNode httpService;

    public void postConstruct() {
        System.out.println("In the Web Monitor startup ************");
        this.ppem.registerProbeProviderListener(this);
        this.buildWebMonitoringConfigTree();
        this.jvmMemoryTM = new JVMMemoryStatsTelemetry(this.server);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void providerRegistered(String moduleName, String providerName, String appName) {
        try {
            System.out.println("Provider registered event received - providerName = " + providerName + " : module name = " + moduleName + " : appName = " + appName);
            if (providerName.equals("session")) {
                System.out.println("and it is Web session");
                if (this.webTM == null) {
                    this.webTM = new WebTelemetry(this.server);
                    this.handles = this.pcm.registerListener(this.webTM);
                }
                if (this.sessionsTM == null) {
                    this.sessionsTM = new SessionStatsTelemetry(this.webTM.getTreeNode());
                    this.handles = this.pcm.registerListener(this.sessionsTM);
                }
            }
            if (providerName.equals("servlet")) {
                System.out.println("and it is Web servlet");
                if (this.webTM == null) {
                    this.webTM = new WebTelemetry(this.server);
                    this.handles = this.pcm.registerListener(this.webTM);
                }
            }
            if (providerName.equals("webmodule")) {
                System.out.println("and it is Web Module");
                if (this.moduleTM == null) {
                    this.moduleTM = new WebModuleTelemetry(this.server);
                    this.handles = this.pcm.registerListener(this.moduleTM);
                }
            }
            if (providerName.equals("request")) {
                System.out.println("and it is Web request");
                if (this.webRequestTM == null) {
                    this.webRequestTM = new WebRequestTelemetry(this.server);
                    this.handles = this.pcm.registerListener(this.webTM);
                }
            }
            if (!providerName.equals("threadpool")) return;
            System.out.println("and it is threadpool");
            if (this.threadPoolTM != null) return;
        }
        catch (Exception e) {
            System.out.println("WARNING: Exception in WebMonitorStartup : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void providerUnregistered(String moduleName, String providerName, String appName) {
    }

    private void buildWebMonitoringConfigTree() {
        Server srvr = null;
        List<Server> ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        this.server = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", this.server);
        TreeNode applications = TreeNodeFactory.createTreeNode("applications", this.domain.getApplications(), "web");
        this.server.addChild(applications);
        List<WebModule> lm = this.domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            System.out.println("next wm - " + wm.getName());
            TreeNode app = TreeNodeFactory.createTreeNode(wm.getName(), wm, "web");
            applications.addChild(app);
        }
        Config sConfig = null;
        List<Config> lcfg = this.domain.getConfigs().getConfig();
        for (Config cfg : lcfg) {
            if (!"server-config".equals(cfg.getName())) continue;
            sConfig = cfg;
            break;
        }
        HttpService httpS = sConfig.getHttpService();
        this.httpService = TreeNodeFactory.createTreeNode("http-service", httpS, "web");
        this.server.addChild(this.httpService);
        for (HttpListener htl : httpS.getHttpListener()) {
            TreeNode httpListener = TreeNodeFactory.createTreeNode(htl.getId(), htl, "web");
            this.httpService.addChild(httpListener);
        }
        ConnectionPool cp = httpS.getConnectionPool();
        TreeNode connectionPool = TreeNodeFactory.createTreeNode("connection-pool", cp, "web");
        this.httpService.addChild(connectionPool);
        ThreadPools tps = sConfig.getThreadPools();
        TreeNode threadPools = TreeNodeFactory.createTreeNode("thread-pools", tps, "web");
        this.server.addChild(threadPools);
    }
}

