/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

public class WebRequestTelemetry {
    private TreeNode webRequestNode;
    private Counter maxTime = CounterFactory.createCount(new long[0]);
    private Counter processingTime = CounterFactory.createCount(new long[0]);
    private Counter requestCount = CounterFactory.createCount(new long[0]);
    private Counter errorCount = CounterFactory.createCount(new long[0]);
    private Counter requestsTotal = CounterFactory.createCount(new long[0]);
    ThreadLocal<Long> entry = new ThreadLocal();

    public WebRequestTelemetry(TreeNode parent) {
        this.webRequestNode = TreeNodeFactory.createTreeNode("request", this, "web");
        parent.addChild(this.webRequestNode);
    }

    public void enableMonitoring(boolean isEnable) {
    }

    public void enableMonitoringForSubElements(boolean isEnable) {
    }

    @ProbeListener(value="web:request::requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response) {
        System.out.println("[TM]requestStartEvent received - request = " + request + ": response = " + response);
        this.entry.set(System.currentTimeMillis());
    }

    @ProbeListener(value="web:request::requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="statusCode") int statusCode) {
        this.requestsTotal.increment();
        System.out.println("[TM]requestEndEvent received - request = " + request + ": response = " + response + " :Response code = " + statusCode);
        long timeTaken = System.currentTimeMillis() - this.entry.get();
        this.entry.set(null);
    }
}

