/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.base;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final Set<String> PATTERN_PROPS = GSetUtil.newUnmodifiableStringSet("j2eeType", "name");

    private Util() {
    }

    public static ObjectName newObjectName(String name) {
        return JMXUtil.newObjectName(name);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return Util.newObjectName(domain + ":" + props);
    }

    public static ObjectName newObjectNamePattern(String domain, String props) {
        return JMXUtil.newObjectNamePattern(domain, props);
    }

    public static ObjectName newObjectNamePattern(ObjectName objectName) {
        String props = objectName.getKeyPropertyListString();
        return Util.newObjectNamePattern(objectName.getDomain(), props);
    }

    public static String makeProp(String name, String value) {
        return JMXUtil.makeProp(name, value);
    }

    public static String makeJ2EETypeProp(String value) {
        return Util.makeProp("j2eeType", value);
    }

    public static String makeNameProp(String value) {
        return Util.makeProp("name", value);
    }

    public static String makeRequiredProps(String j2eeType, String name) {
        String j2eeTypeProp = Util.makeJ2EETypeProp(j2eeType);
        String nameProp = Util.makeNameProp(name);
        String props = Util.concatenateProps(j2eeTypeProp, nameProp);
        return props;
    }

    public static String getSelfProp(ObjectName objectName) {
        String j2eeType = objectName.getKeyProperty("j2eeType");
        String name = objectName.getKeyProperty("name");
        return Util.makeProp(j2eeType, name);
    }

    public static String getAdditionalProps(ObjectName objectName) {
        Hashtable<String, String> allProps = objectName.getKeyPropertyList();
        allProps.remove("j2eeType");
        allProps.remove("name");
        String props = "";
        for (String key : allProps.keySet()) {
            String prop = Util.makeProp(key, allProps.get(key));
            props = Util.concatenateProps(props, prop);
        }
        return props;
    }

    public static String getFullTypeProps(ObjectName objectName, String fullType) {
        String selfProp = Util.getSelfProp(objectName);
        String ancestorProps = "";
        String[] types = Util.getTypeArray(fullType);
        for (int i = 0; i < types.length - 1; ++i) {
            String key = types[i];
            String value = objectName.getKeyProperty(key);
            String prop = Util.makeProp(key, value);
            ancestorProps = Util.concatenateProps(ancestorProps, prop);
        }
        String props = Util.concatenateProps(selfProp, ancestorProps);
        return props;
    }

    public static String getName(ObjectName objectName) {
        String name = objectName.getKeyProperty("name");
        if (name == null) {
            name = "na";
        }
        return name;
    }

    public static String getJ2EEType(ObjectName objectName) {
        return objectName.getKeyProperty("j2eeType");
    }

    public static String getJ2EEType(Class<? extends AMX> amxInterface) {
        String fieldName = "J2EE_TYPE";
        try {
            Field field = amxInterface.getField("J2EE_TYPE");
            return (String)String.class.cast(field.get(null));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Missing J2EE_TYPE field in interface " + amxInterface.getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't access J2EE_TYPE field in " + amxInterface.getName());
        }
    }

    public static String[] getTypeArray(String fullType) {
        if (fullType == null) {
            throw new IllegalArgumentException();
        }
        assert (".".equals("."));
        return fullType.split("\\.");
    }

    public static Set<String> getPatternKeys(String fullType) {
        HashSet<String> requiredKeys = GSetUtil.copySet(PATTERN_PROPS);
        String[] types = Util.getTypeArray(fullType);
        for (int i = 0; i < types.length - 1; ++i) {
            requiredKeys.add(types[i]);
        }
        return TypeCast.checkedStringSet(requiredKeys);
    }

    public static String concatenateProps(String props1, String props2) {
        return JMXUtil.concatenateProps(props1, props2);
    }

    public static String concatenateProps(String props1, String props2, String props3) {
        return Util.concatenateProps(Util.concatenateProps(props1, props2), props3);
    }

    public static Set<ObjectName> toObjectNames(Set<? extends AMX> amxs) {
        HashSet<ObjectName> objectNames = new HashSet<ObjectName>();
        for (AMX aMX : amxs) {
            objectNames.add(Util.getObjectName(aMX));
        }
        return Collections.checkedSet(objectNames, ObjectName.class);
    }

    public static Map<String, ObjectName> toObjectNames(Map<String, ? extends AMX> amxMap) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (String key : amxMap.keySet()) {
            AMX value = amxMap.get(key);
            m.put(key, Util.getExtra(value).getObjectName());
        }
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static ObjectName[] toObjectNames(AMX[] amx) {
        ObjectName[] objectNames = new ObjectName[amx.length];
        for (int i = 0; i < objectNames.length; ++i) {
            objectNames[i] = amx[i] == null ? null : Util.getExtra(amx[i]).getObjectName();
        }
        return objectNames;
    }

    public static Set<String> getNames(Set<? extends AMX> amxs) {
        return Util.getNamesSet(Util.toObjectNames(amxs));
    }

    public static Set<String> getNamesSet(Set<ObjectName> objectNames) {
        return TypeCast.checkedStringSet(JMXUtil.getKeyPropertySet("name", objectNames));
    }

    public static String[] getNamesArray(Set<ObjectName> objectNames) {
        return JMXUtil.getKeyProperty("name", objectNames);
    }

    public static final Map<String, ObjectName> createObjectNameMap(Set<ObjectName> objectNames) {
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        for (ObjectName objectName : objectNames) {
            String name = Util.getName(objectName);
            assert (!m.containsKey(name)) : "createObjectNameMap: key already present: " + name + " in " + objectName;
            m.put(name, objectName);
        }
        assert (m.keySet().size() == objectNames.size());
        return Collections.checkedMap(m, String.class, ObjectName.class);
    }

    public static <T extends AMX> Map<String, T> createNameMap(Set<T> amxs) {
        HashMap<String, AMX> m = new HashMap<String, AMX>();
        for (AMX amx : amxs) {
            String name = amx.getName();
            m.put(name, amx);
        }
        return m;
    }

    public static Extra getExtra(AMX proxy) {
        return (Extra)((Object)Proxy.getInvocationHandler(proxy));
    }

    public static <T extends AMX> ObjectName getObjectName(T proxy) {
        return Util.getExtra(proxy).getObjectName();
    }

    public static ObjectName getObjectName(Map<String, ObjectName> candidates, String name) {
        ObjectName item = candidates.get(name);
        if (item == null) {
            throw new IllegalArgumentException("Not found: " + name);
        }
        return item;
    }

    public static Map<String, Serializable> getAMXNotificationData(Notification notif) {
        return Collections.unmodifiableMap(JMXUtil.getUserDataMapString_Serializable(notif));
    }

    public static Serializable getAMXNotificationValue(Notification notif, String key) {
        Map<String, Serializable> data = Util.getAMXNotificationData(notif);
        if (data == null) {
            throw new IllegalArgumentException(notif.toString());
        }
        if (!data.containsKey(key)) {
            throw new IllegalArgumentException("Value not found for " + key + " in " + notif);
        }
        return data.get(key);
    }

    public static <T extends Serializable> T getAMXNotificationValue(Notification notif, String key, Class<T> theClass) {
        Serializable value = Util.getAMXNotificationValue(notif, key);
        return (T)((Serializable)theClass.cast(value));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static AMX asAMX(Object o) {
        return (AMX)AMX.class.cast(o);
    }
}

