/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.AppClientModuleConfig;
import com.sun.appserv.management.config.ApplicationConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.RARModuleConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.util.misc.Formatter;
import com.sun.appserv.management.util.misc.StringSourceBase;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LBConfigHelper {
    private final DomainConfig mDomainConfig;
    private final DomainRoot mDomainRoot;
    private static final String LB_CONFIG_SUFFIX = "_LB_CONFIG";
    private static final String LB_SUFFIX = "-lb-temp";
    private final Logger mLogger;
    private final ResourceBundle resBundle;
    private Formatter formatter;
    public static final String RESPONSE_TIMEOUT = "responsetimeout";
    public static final String HTTPS_ROUTING = "httpsrouting";
    public static final String RELOAD_INTERVAL = "reloadinterval";
    public static final String MONITOR = "monitor";
    public static final String ROUTE_COOKIE = "routecookie";
    public static final String HEALTH_CHECKER_URL = "healthcheckerurl";
    public static final String HEALTH_CHECKER_TIMEOUT = "healthcheckertimeout";
    public static final String HEALTH_CHECKER_INTERVAL = "healthcheckerinterval";
    public static final String TARGET = "target";
    public static final String CONFIG = "config";
    public static final String LB_POLICY = "lbpolicy";
    public static final String LB_POLICY_MODULE = "lbpolicymodule";
    public static final String AUTO_APPLY_ENABLED = "autoapplyenabled";
    public static final String LB_ENABLE_ALL_INSTANCES = "lbenableallinstances";
    public static final String LB_ENABLE_ALL_APPLICATIONS = "lbenableallapplications";
    public static final String LB_WEIGHT = "lbweight";

    public LBConfigHelper(DomainRoot domainRoot) {
        this.mDomainConfig = domainRoot.getDomainConfig();
        this.mDomainRoot = domainRoot;
        this.mLogger = Logger.getLogger(domainRoot.getMBeanLoggerName());
        this.resBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".LocalStrings");
        this.formatter = new Formatter(new StringSourceBase());
    }

    public List<LBConfig> getLBConfigsForServer(String serverName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        ArrayList<LBConfig> list = new ArrayList<LBConfig>();
        for (LBConfig config : lbconfigs.values()) {
            Map<String, ServerRefConfig> map = config.getServerRefConfigMap();
            for (String name : map.keySet()) {
                if (!name.equals(serverName)) continue;
                list.add(config);
            }
        }
        return list;
    }

    public List<LBConfig> getLBConfigsForCluster(String clusterName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        ArrayList<LBConfig> list = new ArrayList<LBConfig>();
        for (LBConfig config : lbconfigs.values()) {
            Map<String, ClusterRefConfig> map = config.getClusterRefConfigMap();
            for (String name : map.keySet()) {
                if (!name.equals(clusterName)) continue;
                list.add(config);
            }
        }
        return list;
    }

    public Map<String, ServerRefConfig> getServersInLBConfig(String lbConfigName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        LBConfig lbconfig = lbconfigs.get(lbConfigName);
        return lbconfig.getServerRefConfigMap();
    }

    public Map<String, ClusterRefConfig> getClustersInLBConfig(String lbConfigName) {
        Map<String, LBConfig> lbconfigs = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        LBConfig lbconfig = lbconfigs.get(lbConfigName);
        return lbconfig.getClusterRefConfigMap();
    }

    public String[] listTargets() {
        Map<String, StandaloneServerConfig> ssConfigMap;
        HashSet<String> targetSet = new HashSet<String>();
        Map<String, ClusterConfig> cConfigMap = this.mDomainConfig.getClustersConfig().getClusterConfigMap();
        if (cConfigMap != null) {
            targetSet.addAll(cConfigMap.keySet());
        }
        if ((ssConfigMap = this.mDomainConfig.getServersConfig().getStandaloneServerConfigMap()) != null) {
            targetSet.addAll(ssConfigMap.keySet());
        }
        String[] targetArr = new String[targetSet.size()];
        return targetSet.toArray(targetArr);
    }

    public String[] listTargets(String lbName) {
        Map<String, ServerRefConfig> sRefMap;
        HashSet<String> targetSet = new HashSet<String>();
        Map<String, LoadBalancerConfig> lbMap = this.mDomainConfig.getLoadBalancersConfig().getLoadBalancerConfigMap();
        if (lbMap == null) {
            return null;
        }
        LoadBalancerConfig lb = lbMap.get(lbName);
        if (lb == null) {
            return null;
        }
        String lbConfigName = lb.getLbConfigName();
        Map<String, LBConfig> lbConfigMap = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        if (lbConfigMap == null || lbConfigName == null) {
            return null;
        }
        LBConfig lbConfig = lbConfigMap.get(lbConfigName);
        if (lbConfig == null) {
            return null;
        }
        Map<String, ClusterRefConfig> cRefMap = lbConfig.getClusterRefConfigMap();
        if (cRefMap != null) {
            targetSet.addAll(cRefMap.keySet());
        }
        if ((sRefMap = lbConfig.getServerRefConfigMap()) != null) {
            targetSet.addAll(sRefMap.keySet());
        }
        String[] targetArr = new String[targetSet.size()];
        return targetSet.toArray(targetArr);
    }

    public LoadBalancerConfig createLoadbalancer(String loadbalancerName, boolean autoApplyEnabled, String[] targets, Map<String, String> params) {
        if (loadbalancerName == null) {
            throw new IllegalArgumentException("loadbalancerName can not be null");
        }
        String lbConfigName = loadbalancerName + LB_CONFIG_SUFFIX;
        Map<String, LBConfig> lbconfigMap = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        if (lbconfigMap != null) {
            int i = 1;
            while (lbconfigMap.get(lbConfigName) != null) {
                lbConfigName = loadbalancerName + LB_CONFIG_SUFFIX + "_" + i;
                ++i;
            }
        }
        LBConfig lbConfig = this.mDomainConfig.getLBConfigsConfig().createLBConfig(lbConfigName, params);
        Map<String, String> healthCheckerAttrsMap = this.mDomainRoot.getDomainConfig().getDefaultValues("X-HealthCheckerConfig");
        String healthCheckerUrl = healthCheckerAttrsMap.get("url");
        String healthCheckerInterval = healthCheckerAttrsMap.get("interval-in-seconds");
        String healthCheckerTimeout = healthCheckerAttrsMap.get("timeout-in-seconds");
        if (targets != null) {
            for (int idx = 0; idx < targets.length; ++idx) {
                String targetName = targets[idx];
                if (this.isCluster(targetName)) {
                    ClusterRefConfig clusterRefConfig = lbConfig.createClusterRefConfig(targetName, null);
                    clusterRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
                    continue;
                }
                if (!this.isStandaloneServer(targetName)) continue;
                ServerRefConfig serverRefConfig = lbConfig.createServerRefConfig(targetName, null);
                serverRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
            }
        }
        return this.mDomainConfig.getLoadBalancersConfig().createLoadBalancerConfig(loadbalancerName, lbConfigName, autoApplyEnabled, null);
    }

    public final LoadBalancerConfig createLoadBalancer(String loadbalancerName, String target, Map<String, String> options, Map<String, String> properties) throws MBeanException {
        if (loadbalancerName == null) {
            throw new IllegalArgumentException("loadbalancerName can not be null");
        }
        if (this.mDomainConfig.getLoadBalancersConfig().getLoadBalancerConfigMap().get(loadbalancerName) != null) {
            String msg = this.formatter.format(this.resBundle.getString("LoadBalancerConfigExists"), loadbalancerName);
            throw new MBeanException(new RuntimeException(msg));
        }
        String healthCheckerUrl = options.get(HEALTH_CHECKER_URL);
        String healthCheckerInterval = options.get(HEALTH_CHECKER_INTERVAL);
        String healthCheckerTimeout = options.get(HEALTH_CHECKER_TIMEOUT);
        String lbPolicy = options.get(LB_POLICY);
        String lbPolicyModule = options.get(LB_POLICY_MODULE);
        boolean autoApplyEnabled = Boolean.valueOf(options.get(AUTO_APPLY_ENABLED));
        boolean enableAllInstances = Boolean.valueOf(options.get(LB_ENABLE_ALL_INSTANCES));
        boolean enableAllApps = Boolean.valueOf(options.get(LB_ENABLE_ALL_APPLICATIONS));
        boolean isCluster = this.isCluster(target);
        Map<String, String> params = this.getParams(options);
        String lbConfigName = loadbalancerName + LB_CONFIG_SUFFIX;
        Map<String, LBConfig> lbconfigMap = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        if (lbconfigMap != null) {
            int i = 1;
            while (lbconfigMap.get(lbConfigName) != null) {
                lbConfigName = loadbalancerName + LB_CONFIG_SUFFIX + "_" + i;
                ++i;
            }
        }
        if (!(isCluster || lbPolicy == null && lbPolicyModule == null)) {
            String msg = this.formatter.format(this.resBundle.getString("NotCluster"), target);
            throw new MBeanException(new RuntimeException(msg));
        }
        LBConfig lbConfig = this.mDomainConfig.getLBConfigsConfig().createLBConfig(lbConfigName, params);
        if (isCluster) {
            ClusterRefConfig clusterRefConfig = lbConfig.createClusterRefConfig(target, lbPolicy, lbPolicyModule);
            clusterRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
        } else {
            ServerRefConfig serverRefConfig = lbConfig.createServerRefConfig(target, "30", "true", "true");
            serverRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
        }
        if (enableAllInstances) {
            this.setServerStatus(target, 0, true, true);
        } else {
            this.setServerStatus(target, 0, false, true);
        }
        if (enableAllApps) {
            this.enableAllApplications(target);
        }
        return this.mDomainConfig.getLoadBalancersConfig().createLoadBalancerConfig(loadbalancerName, lbConfigName, autoApplyEnabled, properties);
    }

    public void removeLoadbalancer(String loadbalancerName) {
        LoadBalancerConfig loadbalancerConfig = this.mDomainConfig.getLoadBalancersConfig().getLoadBalancerConfigMap().get(loadbalancerName);
        if (loadbalancerConfig == null) {
            String msg = this.formatter.format(this.resBundle.getString("LoadBalancerConfigNotDefined"), loadbalancerName);
            throw new RuntimeException(msg);
        }
        String lbConfigName = loadbalancerConfig.getLbConfigName();
        Map<String, LoadBalancerConfig> lbMap = this.mDomainConfig.getLoadBalancersConfig().getLoadBalancerConfigMap();
        if (lbMap != null) {
            for (LoadBalancerConfig lbConfig : lbMap.values()) {
                if (lbConfig.getName().equals(loadbalancerConfig.getName()) || !lbConfig.getLbConfigName().equals(lbConfigName)) continue;
                String msg = this.formatter.format(this.resBundle.getString("LbConfigIsInUse"), lbConfigName);
                throw new RuntimeException(msg);
            }
        }
        this.mDomainConfig.getLoadBalancersConfig().removeLoadBalancerConfig(loadbalancerName);
        this.mDomainConfig.getLBConfigsConfig().removeLBConfig(lbConfigName);
    }

    public String removeLBRef(String lbName, String configName, String target, boolean force) throws MBeanException {
        boolean isCluster = this.isCluster(target);
        if (configName != null && this.mDomainConfig.getLBConfigsConfig().getLBConfigMap().get(configName) == null) {
            String msg = this.formatter.format(this.resBundle.getString("LbConfigNotDefined"), configName);
            throw new MBeanException(new RuntimeException(msg));
        }
        if (lbName != null) {
            LoadBalancerConfig loadBalancerConfig = this.mDomainConfig.getLoadBalancersConfig().getLoadBalancerConfigMap().get(lbName);
            if (loadBalancerConfig == null) {
                String msg = this.formatter.format(this.resBundle.getString("LoadBalancerConfigNotDefined"), lbName);
                throw new MBeanException(new RuntimeException(msg));
            }
            configName = loadBalancerConfig.getLbConfigName();
        }
        LBConfig lbConfig = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap().get(configName);
        if (isCluster) {
            if (!force) {
                Map<String, ServerRefConfig> serverRefConfigMap = this.mDomainConfig.getClustersConfig().getClusterConfigMap().get(target).getServerRefConfigMap();
                for (ServerRefConfig serverRefConfig : serverRefConfigMap.values()) {
                    if (!serverRefConfig.resolveBoolean("LBEnabled").booleanValue()) continue;
                    String msg = this.formatter.format(this.resBundle.getString("DisableServer"), target);
                    throw new MBeanException(new RuntimeException(msg));
                }
            }
            lbConfig.removeClusterRefConfig(target);
        } else {
            if (!force && lbConfig.getServerRefConfigMap().get(target).resolveBoolean("LBEnabled").booleanValue()) {
                String msg = this.formatter.format(this.resBundle.getString("DisableServer"), target);
                throw new MBeanException(new RuntimeException(msg));
            }
            lbConfig.removeServerRefConfig(target);
        }
        return null;
    }

    public void disableServer(String target, int timeout) {
        this.setServerStatus(target, timeout, false, false);
    }

    public void enableServer(String target) {
        this.setServerStatus(target, 0, true, false);
    }

    public void disableApplication(String target, String appName, int timeout) {
        this.setApplicationStatus(target, appName, timeout, false);
    }

    public void enableApplication(String target, String appName) {
        this.setApplicationStatus(target, appName, 0, true);
    }

    public String createLBRef(String lbName, String configName, String target, Map<String, String> options) throws MBeanException {
        String healthCheckerUrl = options.get(HEALTH_CHECKER_URL);
        String healthCheckerInterval = options.get(HEALTH_CHECKER_INTERVAL);
        String healthCheckerTimeout = options.get(HEALTH_CHECKER_TIMEOUT);
        String lbPolicy = options.get(LB_POLICY);
        String lbPolicyModule = options.get(LB_POLICY_MODULE);
        boolean isCluster = this.isCluster(target);
        boolean enableAllInstances = Boolean.getBoolean(options.get(LB_ENABLE_ALL_INSTANCES));
        boolean enableAllApps = Boolean.getBoolean(options.get(LB_ENABLE_ALL_APPLICATIONS));
        if (configName != null && this.mDomainConfig.getLBConfigsConfig().getLBConfigMap().get(configName) == null) {
            String msg = this.formatter.format(this.resBundle.getString("LbConfigNotDefined"), configName);
            throw new MBeanException(new RuntimeException(msg));
        }
        if (lbName != null) {
            LoadBalancerConfig loadBalancerConfig = this.mDomainConfig.getLoadBalancersConfig().getLoadBalancerConfigMap().get(lbName);
            if (loadBalancerConfig == null) {
                String msg = this.formatter.format(this.resBundle.getString("LoadBalancerConfigNotDefined"), lbName);
                throw new MBeanException(new RuntimeException(msg));
            }
            configName = loadBalancerConfig.getLbConfigName();
        }
        LBConfig lbConfig = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap().get(configName);
        if (!(isCluster || lbPolicy == null && lbPolicyModule == null)) {
            String msg = this.formatter.format(this.resBundle.getString("NotCluster"), target);
            throw new MBeanException(new RuntimeException(msg));
        }
        if (isCluster) {
            ClusterRefConfig clusterRefConfig = lbConfig.createClusterRefConfig(target, lbPolicy, lbPolicyModule);
            clusterRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
        } else {
            ServerRefConfig serverRefConfig = lbConfig.createServerRefConfig(target, "30", "true", "true");
            serverRefConfig.createHealthCheckerConfig(healthCheckerUrl, healthCheckerInterval, healthCheckerTimeout);
        }
        if (enableAllInstances) {
            this.enableServer(target);
        }
        if (enableAllApps) {
            this.enableAllApplications(target);
        }
        return null;
    }

    public void configureLBWeight(String clusterName, Map instanceVsWeights) {
        Map<String, ClusterConfig> clusterConfigMap = this.mDomainConfig.getClustersConfig().getClusterConfigMap();
        ClusterConfig clusterConfig = clusterConfigMap.get(clusterName);
        if (clusterConfig == null) {
            throw new IllegalArgumentException(this.formatter.format(this.resBundle.getString("InvalidCluster"), clusterName));
        }
        Map<String, ClusteredServerConfig> clusteredServerConfigMap = clusterConfig.getClusteredServerConfigMap();
        for (Object instance : instanceVsWeights.keySet()) {
            ClusteredServerConfig clusteredServerConfig = clusteredServerConfigMap.get(instance);
            if (clusteredServerConfig == null) {
                throw new IllegalArgumentException(this.formatter.format(this.resBundle.getString("InvalidInstance"), instance, clusterName));
            }
            clusteredServerConfig.setLBWeight(instanceVsWeights.get(instance).toString());
        }
    }

    public void enableAllApplications(String target) {
        if (this.isCluster(target)) {
            ClusterConfig cRef = this.mDomainConfig.getClustersConfig().getClusterConfigMap().get(target);
            this.enableAllApplications(cRef.getDeployedItemRefConfigMap());
        } else {
            StandaloneServerConfig serverConfig = this.mDomainConfig.getServersConfig().getStandaloneServerConfigMap().get(target);
            if (serverConfig != null) {
                this.enableAllApplications(serverConfig.getDeployedItemRefConfigMap());
            }
        }
    }

    private void enableAllApplications(Map<String, DeployedItemRefConfig> deployedItemRefConfigMap) {
        for (DeployedItemRefConfig deployedItemRefConfig : deployedItemRefConfigMap.values()) {
            ApplicationConfig app = this.mDomainConfig.getApplicationsConfig().getApplicationConfigMap().get(deployedItemRefConfig.getName());
            if (app != null) {
                if (!app.getObjectType().equals("user")) continue;
                deployedItemRefConfig.setLBEnabled("true");
                continue;
            }
            WebModuleConfig web = this.mDomainConfig.getApplicationsConfig().getWebModuleConfigMap().get(deployedItemRefConfig.getName());
            if (web != null) {
                if (!web.getObjectType().equals("user")) continue;
                deployedItemRefConfig.setLBEnabled("true");
                continue;
            }
            EJBModuleConfig ejb = this.mDomainConfig.getApplicationsConfig().getEJBModuleConfigMap().get(deployedItemRefConfig.getName());
            if (ejb != null) {
                if (!ejb.getObjectType().equals("user")) continue;
                deployedItemRefConfig.setLBEnabled("true");
                continue;
            }
            RARModuleConfig rar = this.mDomainConfig.getApplicationsConfig().getRARModuleConfigMap().get(deployedItemRefConfig.getName());
            if (rar != null) {
                if (!rar.getObjectType().equals("user")) continue;
                deployedItemRefConfig.setLBEnabled("true");
                continue;
            }
            AppClientModuleConfig appClient = this.mDomainConfig.getApplicationsConfig().getAppClientModuleConfigMap().get(deployedItemRefConfig.getName());
            if (appClient == null) continue;
            deployedItemRefConfig.setLBEnabled("true");
        }
    }

    boolean isCluster(String name) {
        Map<String, ClusterConfig> cConfigMap = this.mDomainConfig.getClustersConfig().getClusterConfigMap();
        if (cConfigMap == null) {
            return false;
        }
        ClusterConfig cConfig = cConfigMap.get(name);
        return cConfig != null;
    }

    boolean isStandaloneServer(String name) {
        Map<String, StandaloneServerConfig> ssConfigMap = this.mDomainConfig.getServersConfig().getStandaloneServerConfigMap();
        if (ssConfigMap == null) {
            return false;
        }
        StandaloneServerConfig ssConfig = ssConfigMap.get(name);
        return ssConfig != null;
    }

    private void setServerStatus(String target, int timeout, boolean status, boolean ignore) {
        if (timeout < 0 && !status) {
            String msg = this.resBundle.getString("InvalidNumber");
            throw new IllegalArgumentException(msg);
        }
        try {
            if (this.isCluster(target)) {
                ClusterConfig cRef = this.mDomainConfig.getClustersConfig().getClusterConfigMap().get(target);
                if (cRef == null) {
                    this.mLogger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                    String msg = this.formatter.format(this.resBundle.getString("ServerNotDefined"), target);
                    throw new MBeanException(new RuntimeException(msg));
                }
                for (ServerRefConfig sRef : cRef.getServerRefConfigMap().values()) {
                    this.setLBEnabled(sRef, status, timeout, target, ignore);
                }
            } else {
                ServerRefConfig sRef = null;
                boolean foundTarget = false;
                Map<String, LBConfig> lbConfigs = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
                for (LBConfig lbConfig : lbConfigs.values()) {
                    Map<String, ServerRefConfig> serverRefs = lbConfig.getServerRefConfigMap();
                    sRef = serverRefs.get(target);
                    if (sRef == null) {
                        this.mLogger.log(Level.FINEST, " server " + target + " does not exist in " + serverRefs);
                        continue;
                    }
                    foundTarget = true;
                    break;
                }
                if (!foundTarget && (sRef = this.getServerRefConfigFromCluster(target)) == null) {
                    this.mLogger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                    String msg = this.formatter.format(this.resBundle.getString("ServerNotDefined"), target);
                    throw new MBeanException(new RuntimeException(msg));
                }
                this.setLBEnabled(sRef, status, timeout, target, ignore);
            }
        }
        catch (Exception ce) {
            ce.printStackTrace();
            throw new RuntimeException(ce);
        }
    }

    private void setLBEnabled(ServerRefConfig sRef, boolean status, int timeout, String target, boolean ignore) throws MBeanException {
        int curTout = sRef.resolveInteger("DisableTimeoutInMinutes");
        boolean enabled = sRef.resolveBoolean("LBEnabled");
        if (!status) {
            if (!ignore && !enabled && curTout == timeout) {
                String msg = this.formatter.format(this.resBundle.getString("ServerDisabled"), sRef.getRef());
                throw new MBeanException(new Exception(msg));
            }
            sRef.setDisableTimeoutInMinutes("" + timeout);
            sRef.setLBEnabled("false");
        } else {
            if (!ignore && enabled) {
                String msg = this.formatter.format(this.resBundle.getString("ServerEnabled"), sRef.getRef());
                throw new MBeanException(new Exception("ServerEnabled"));
            }
            sRef.setLBEnabled("true");
        }
    }

    private void setApplicationStatus(String target, String appName, int timeout, boolean status) {
        if (timeout < 0 && !status) {
            String msg = this.resBundle.getString("InvalidNumber");
            throw new IllegalArgumentException(msg);
        }
        try {
            String msg;
            DeployedItemRefConfig dRef = null;
            if (this.isCluster(target)) {
                Map<String, ClusterConfig> clusterConfigs = this.mDomainConfig.getClustersConfig().getClusterConfigMap();
                ClusterConfig clusterConfig = clusterConfigs.get(target);
                dRef = clusterConfig.getDeployedItemRefConfigMap().get(appName);
            } else {
                Map<String, StandaloneServerConfig> ssConfigMap = this.mDomainConfig.getServersConfig().getStandaloneServerConfigMap();
                StandaloneServerConfig ssc = ssConfigMap.get(target);
                if (ssc == null) {
                    ClusteredServerConfig s = this.mDomainConfig.getServersConfig().getClusteredServerConfigMap().get(target);
                    dRef = s.getDeployedItemRefConfigMap().get(appName);
                } else {
                    dRef = ssc.getDeployedItemRefConfigMap().get(appName);
                }
            }
            if (dRef == null) {
                this.mLogger.log(Level.FINEST, " server " + target + " does not exist in any cluster in the domain");
                String msg2 = this.formatter.format(this.resBundle.getString("AppRefNotDefined"), target);
                throw new MBeanException(new RuntimeException(msg2));
            }
            int curTout = Integer.parseInt(dRef.getDisableTimeoutInMinutes());
            boolean enabled = dRef.resolveBoolean("LBEnabled");
            if (!status) {
                if (!enabled && curTout == timeout) {
                    msg = this.resBundle.getString("AppDisabledOnServer");
                    throw new MBeanException(new Exception(msg));
                }
                dRef.setDisableTimeoutInMinutes("" + timeout);
                dRef.setLBEnabled("false");
                this.mLogger.log(Level.INFO, this.resBundle.getString("http_lb_admin.ApplicationDisabled"));
            } else {
                if (enabled) {
                    msg = this.resBundle.getString("AppEnabledOnServer");
                    throw new MBeanException(new Exception(msg));
                }
                dRef.setLBEnabled("true");
                this.mLogger.log(Level.INFO, this.resBundle.getString("http_lb_admin.ApplicationEnabled"));
            }
        }
        catch (Exception ce) {
            throw new RuntimeException(ce);
        }
    }

    private ServerRefConfig getServerRefConfigFromCluster(String target) throws MBeanException {
        Map<String, LBConfig> lbConfigs = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        for (LBConfig lbConfig : lbConfigs.values()) {
            Map<String, ClusterRefConfig> clusterRefs = lbConfig.getClusterRefConfigMap();
            for (ClusterRefConfig clusterRef : clusterRefs.values()) {
                String clusterName = clusterRef.getReferencedClusterName();
                Map<String, ClusterConfig> clusterConfigs = this.mDomainConfig.getClustersConfig().getClusterConfigMap();
                ClusterConfig config = clusterConfigs.get(clusterName);
                Map<String, ServerRefConfig> serverRefConfigs = config.getServerRefConfigMap();
                for (ServerRefConfig serverRefConfig : serverRefConfigs.values()) {
                    if (!serverRefConfig.getName().equals(target)) continue;
                    return serverRefConfig;
                }
            }
        }
        return null;
    }

    public Map<String, LoadBalancerConfig> getLoadBalancers(String targetName, boolean isCluster) {
        Map<String, LBConfig> lbConfigMap = this.fetchLBConfigs(targetName, isCluster);
        return this.fetchLoadBalancerConfigs(lbConfigMap);
    }

    private Map<String, LBConfig> fetchLBConfigs(String targetName, boolean isCluster) {
        HashMap<String, LBConfig> result = new HashMap<String, LBConfig>();
        Map<String, LBConfig> lbConfigMap = this.mDomainConfig.getLBConfigsConfig().getLBConfigMap();
        if (isCluster) {
            block0: for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> lbClusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                for (String clusterRef : lbClusterRefConfigMap.keySet()) {
                    if (!clusterRef.equals(targetName)) continue;
                    result.put(lbConfigName, lbConfig);
                    continue block0;
                }
            }
        } else if (this.isStandaloneServer(targetName)) {
            block2: for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ServerRefConfig> lbServerRefConfigMap = lbConfig.getServerRefConfigMap();
                for (String serverRef : lbServerRefConfigMap.keySet()) {
                    if (!serverRef.equals(targetName)) continue;
                    result.put(lbConfigName, lbConfig);
                    continue block2;
                }
            }
        } else {
            for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> lbClusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                Map<String, ClusterConfig> clusterConfigMap = this.mDomainConfig.getClustersConfig().getClusterConfigMap();
                HashMap<String, ClusterConfig> relevantClusterConfigMap = new HashMap<String, ClusterConfig>();
                for (String clusterRef : lbClusterRefConfigMap.keySet()) {
                    relevantClusterConfigMap.put(clusterRef, clusterConfigMap.get(clusterRef));
                }
                block6: for (String clusterName : relevantClusterConfigMap.keySet()) {
                    ClusterConfig clusterConfig = (ClusterConfig)relevantClusterConfigMap.get(clusterName);
                    Map<String, ServerRefConfig> clusteredServerRefConfigMap = clusterConfig.getServerRefConfigMap();
                    for (String serverRef : clusteredServerRefConfigMap.keySet()) {
                        if (!serverRef.equals(targetName)) continue;
                        result.put(lbConfigName, lbConfig);
                        continue block6;
                    }
                }
            }
        }
        return result;
    }

    private Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(Map<String, LBConfig> lbConfigMap) {
        HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap<String, LoadBalancerConfig>();
        for (String lbConfigName : lbConfigMap.keySet()) {
            Map<String, LoadBalancerConfig> allLoadBalancerConfigMap = this.mDomainRoot.getDomainConfig().getLoadBalancersConfig().getLoadBalancerConfigMap();
            for (String loadBalancerName : allLoadBalancerConfigMap.keySet()) {
                LoadBalancerConfig loadBalancerConfig = allLoadBalancerConfigMap.get(loadBalancerName);
                if (!loadBalancerConfig.getLbConfigName().equals(lbConfigName)) continue;
                relevantLoadBalancerConfigMap.put(loadBalancerName, loadBalancerConfig);
            }
        }
        return relevantLoadBalancerConfigMap;
    }

    private LoadBalancer createLoadBalancer(String configName) {
        this.mDomainConfig.getLoadBalancersConfig().createLoadBalancerConfig(configName + LB_SUFFIX, configName, false, null);
        Map<String, LoadBalancer> lbs = this.mDomainRoot.getLoadBalancerMap();
        LoadBalancer lb = lbs.get(configName + LB_SUFFIX);
        return lb;
    }

    private Map<String, String> getParams(Map<String, String> options) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("https-routing", options.get(HTTPS_ROUTING));
        params.put("monitoring-enabled", options.get(MONITOR));
        params.put("reload-poll-interval-in-seconds", options.get(RELOAD_INTERVAL));
        params.put("response-timeout-in-seconds", options.get(RESPONSE_TIMEOUT));
        params.put("route-cookie-enabled", options.get(ROUTE_COOKIE));
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToFile(String lbxml, String filePath) {
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(filePath);
            fo.write(lbxml.getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                fo.close();
            }
            catch (IOException e) {}
        }
        return filePath;
    }
}

