/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.MonitorTask;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class MonitorCommand
extends AbstractCommand {
    String port;
    String host;
    String user;
    String passwordFile;
    int interval;
    String type;
    String filter;
    boolean verbose;
    File fileName;
    public static final String INTERVAL = "interval";
    public static final String TYPE = "type";
    private static final LocalStringsImpl strings = new LocalStringsImpl(MonitorCommand.class);
    private static final CLILogger logger = CLILogger.getInstance();

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        Timer timer = new Timer();
        try {
            MonitorTask monitorTask = new MonitorTask(timer, this.type, this.getRemoteArgs(), this.verbose, this.fileName);
            timer.scheduleAtFixedRate((TimerTask)monitorTask, 0L, (long)this.interval);
            boolean done = false;
            while (!done) {
                String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (str.equals("q") || str.equals("Q")) {
                    timer.cancel();
                    done = true;
                    continue;
                }
                if (!str.equals("h") && !str.equals("H")) continue;
                monitorTask.displayDetails();
            }
        }
        catch (Exception e) {
            timer.cancel();
            throw new CommandException(strings.get("monitorCommand.errorRemote", e.getMessage()));
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        this.port = this.getOption("port");
        this.host = this.getOption("host");
        this.user = this.getOption("user");
        this.passwordFile = this.getOption("passwordfile");
        this.interval = Integer.parseInt(this.getOption(INTERVAL));
        this.type = this.getOption(TYPE);
        return true;
    }

    private String[] getRemoteArgs() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("monitor");
        if (MonitorCommand.ok(this.port)) {
            list.add("--port");
            list.add(this.port);
        }
        if (MonitorCommand.ok(this.host)) {
            list.add("--host");
            list.add(this.host);
        }
        if (MonitorCommand.ok(this.user)) {
            list.add("--user");
            list.add(this.user);
        }
        if (MonitorCommand.ok(this.passwordFile)) {
            list.add("--passwordfile");
            list.add(this.passwordFile);
        }
        if (MonitorCommand.ok(this.type)) {
            list.add("--type");
            list.add(this.type);
        }
        return list.toArray(new String[list.size()]);
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }
}

