/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.MonitorCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class MonitorTask
extends TimerTask {
    private static final LocalStringsImpl strings = new LocalStringsImpl(MonitorCommand.class);
    String type = null;
    Timer timer = null;
    File fileName = null;
    boolean verbose = false;
    String[] remoteArgs;

    public MonitorTask() {
    }

    public MonitorTask(Timer timer, String type, String[] remoteArgs, boolean verbose, File fileName) {
        this.timer = timer;
        if (type != null) {
            this.type = type;
        }
        this.verbose = verbose;
        this.fileName = fileName;
        this.remoteArgs = remoteArgs;
        String title = "";
        if ("servlet".equals(type)) {
            title = String.format("%1$-10s %2$-10s %3$-10s", "ActSess", "SessTtl", "SrvltLdC");
        } else if ("httplistener".equals(type)) {
            title = String.format("%1$-4s %2$-4s %3$-4s %4$-4s", "ec", "mt", "pt", "rc");
        } else if ("jvm".equals(type)) {
            title = String.format("%1$-10s %2$-10s %3$-10s %4$-10s", "init", "used", "committed", "max");
        } else if ("webmodule".equals(type)) {
            title = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s", "asc", "ast", "rst", "st", "ajlc", "mjlc", "tjlc", "aslc", "mslc", "tslc");
        }
        CLILogger.getInstance().printMessage(title);
    }

    void cancelMonitorTask() {
        this.timer.cancel();
        String msg = strings.get("monitorCommand.press_to_quit");
        CLILogger.getInstance().printMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            CLIRemoteCommand rc = new CLIRemoteCommand(this.remoteArgs);
            rc.runCommand();
        }
        catch (Exception e) {
            CLILogger.getInstance().printError(strings.get("monitorCommand.errorRemote", e.getMessage()));
        }
    }

    public void displayDetails() {
        CLILogger.getInstance().printMessage("These are the details");
    }
}

