/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.Log;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartDomainCommand
extends AbstractCommand {
    private static final long WAIT_FOR_DAS_TIME_MS = 90000L;
    private GFLauncherInfo info;

    @Override
    public void runCommand() throws CommandException, CommandValidationException {
        try {
            String parent;
            this.validateOptions();
            GFLauncher launcher = GFLauncherFactory.getInstance(GFLauncherFactory.ServerType.domain);
            this.info = launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.firstElement());
            }
            if ((parent = this.getOption("domaindir")) != null) {
                this.info.setDomainParentDir(parent);
            }
            boolean verbose = this.getBooleanOption("verbose");
            this.info.setVerbose(verbose);
            this.info.setDebug(this.getBooleanOption("debug"));
            launcher.launch();
            if (!verbose) {
                this.waitForDAS(this.info.getAdminPorts());
            }
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDAS(Set<Integer> ports) throws CommandException {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            if (ports == null || ports.size() <= 0) {
                String msg = this.getLocalizedString("noPorts");
                throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithArg", new Object[]{this.name, msg}));
            }
            long startWait = System.currentTimeMillis();
            Log.info("WaitDAS", new Object[0]);
            boolean alive = false;
            block5: while (!this.timedOut(startWait)) {
                for (int port : ports) {
                    if (!CLIRemoteCommand.pingDAS(port)) continue;
                    alive = true;
                    break block5;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
            if (!alive) {
                Object[] objs = new Object[]{this.info.getDomainName(), 90L};
                String msg = this.getLocalizedString("dasNoStart", objs);
                throw new CommandException(msg);
            }
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 90000L;
    }
}

