/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.cli.remote.GeneratedManPageManager;
import com.sun.enterprise.admin.cli.remote.Log;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteFailureException;
import com.sun.enterprise.admin.cli.remote.RemoteSuccessException;
import com.sun.enterprise.admin.cli.remote.ResponseManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.universal.NameValue;
import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.glassfish.AdminCommandResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManifestManager
implements ResponseManager {
    private AdminCommandResponse response;
    private static final String EOL = StringUtils.EOL;
    private static final String TAB = "    ";

    ManifestManager(InputStream inStream) throws RemoteException, IOException {
        this.response = new AdminCommandResponse(inStream);
    }

    public Map<String, String> getMainAtts() {
        return this.response.getMainAtts();
    }

    @Override
    public void process() throws RemoteException {
        Log.finer("PROCESSING MANIFEST...", new Object[0]);
        this.processGeneratedManPage();
        this.processManPage();
        this.processGeneric();
        throw new RemoteFailureException("Could not process");
    }

    private void processManPage() throws RemoteSuccessException {
        String manPage = this.response.getValue("MANPAGE");
        if (!this.ok(manPage)) {
            return;
        }
        throw new RemoteSuccessException(manPage);
    }

    private void processGeneratedManPage() throws RemoteException {
        if (!this.response.isGeneratedHelp()) {
            return;
        }
        GeneratedManPageManager mgr = new GeneratedManPageManager(this.response);
        mgr.process();
    }

    private void processGeneric() throws RemoteSuccessException, RemoteFailureException {
        StringBuilder sb = new StringBuilder();
        String msg = this.response.getMainMessage();
        if (this.ok(msg)) {
            sb.append(msg).append(EOL);
        }
        this.processOneLevel("", null, this.response.getMainAtts(), sb);
        if (!this.response.wasSuccess()) {
            String cause = this.response.getCause();
            if (CLILogger.isDebug() && this.ok(cause)) {
                sb.append(EOL).append(cause);
            }
            throw new RemoteFailureException(sb.toString());
        }
        throw new RemoteSuccessException(sb.toString());
    }

    private void processOneLevel(String prefix, String key, Map<String, String> atts, StringBuilder sb) {
        if (atts == null) {
            return;
        }
        this.processProps(prefix, atts, sb);
        this.processChildren(prefix, key, atts, sb);
    }

    private void processProps(String prefix, Map<String, String> atts, StringBuilder sb) {
        List<NameValue<String, String>> props = this.response.getKeys(atts);
        Iterator<NameValue<String, String>> it = props.iterator();
        while (it.hasNext()) {
            NameValue<String, String> nv = it.next();
            if (!nv.getName().startsWith("nb-")) continue;
            it.remove();
        }
        if (props == null || props.isEmpty()) {
            return;
        }
        sb.append(prefix).append("properties=(");
        boolean first = true;
        for (NameValue<String, String> nv : props) {
            String name = nv.getName();
            String value = nv.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(name + "=" + value);
        }
        sb.append(")").append(EOL);
    }

    private void processChildren(String prefix, String parent, Map<String, String> atts, StringBuilder sb) {
        Map<String, Map<String, String>> kids = this.response.getChildren(atts);
        if (kids == null || kids.isEmpty()) {
            return;
        }
        String childrenType = atts.get("children-type");
        int index = parent == null ? 0 : parent.length() + 1;
        for (Map.Entry<String, Map<String, String>> entry : kids.entrySet()) {
            String container = entry.getKey();
            if (this.ok(childrenType)) {
                sb.append(prefix).append(childrenType).append(" : ");
            }
            sb.append(container.substring(index)).append(EOL);
            this.processOneLevel(prefix + TAB, container, entry.getValue(), sb);
        }
    }

    private void dump() {
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }
}

