/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.module.ConnectorContainer;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ResourceAdaptersBinder;
import org.glassfish.javaee.services.ResourceManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConnectorDeployer
extends JavaEEDeployer<ConnectorContainer, ConnectorApplication>
implements PostConstruct {
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    private ConnectorResource[] connectorResources;
    @Inject
    private ConnectorConnectionPool[] connectorConnectionPools;
    @Inject
    private ResourceAdaptersBinder binder;
    @Inject
    private ResourceManager resourceManager;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    @Override
    public ConnectorApplication load(ConnectorContainer container, DeploymentContext context) {
        File sourceDir = context.getSourceDir();
        String sourcePath = sourceDir.getAbsolutePath();
        String moduleName = sourceDir.getName();
        if (!ConnectorsUtil.belongsToSystemRA(moduleName)) {
            try {
                this.runtime.createActiveResourceAdapter(sourcePath, moduleName);
            }
            catch (ConnectorRuntimeException cre) {
                _logger.log(Level.WARNING, " unable to load the resource-adapter [ " + moduleName + " ]", cre);
            }
        }
        HashMap<ConnectorResource, ConnectorConnectionPool> raResourcePoolMap = new HashMap<ConnectorResource, ConnectorConnectionPool>();
        Map<String, ConnectorConnectionPool> raPools = this.getConnectorPoolsForRA(this.connectorConnectionPools, moduleName);
        for (ConnectorResource resource : this.connectorResources) {
            if (!raPools.containsKey(resource.getPoolName())) continue;
            raResourcePoolMap.put(resource, raPools.get(resource.getPoolName()));
        }
        return new ConnectorApplication(moduleName, this.resourceManager, this.runtime);
    }

    private Map<String, ConnectorConnectionPool> getConnectorPoolsForRA(ConnectorConnectionPool[] ccp, String raName) {
        HashMap<String, ConnectorConnectionPool> raPools = new HashMap<String, ConnectorConnectionPool>();
        for (ConnectorConnectionPool pool : ccp) {
            if (!pool.getResourceAdapterName().equalsIgnoreCase(raName)) continue;
            raPools.put(pool.getName(), pool);
        }
        return raPools;
    }

    @Override
    public void unload(ConnectorApplication appContainer, DeploymentContext context) {
        File sourceDir = context.getSourceDir();
        String moduleName = sourceDir.getName();
        try {
            this.runtime.destroyActiveResourceAdapter(moduleName, true);
        }
        catch (ConnectorRuntimeException e) {
            _logger.log(Level.WARNING, " unable to unload the resource-adapter [ " + moduleName + " ]", e);
        }
    }

    @Override
    public void clean(DeploymentContext context) {
    }

    @Override
    protected RootDeploymentDescriptor getDefaultBundleDescriptor() {
        return null;
    }

    @Override
    protected String getModuleType() {
        return "connectors";
    }

    @Override
    public void postConstruct() {
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }
}

