/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.orbutil.threadpool.WorkQueue;
import com.sun.enterprise.connectors.work.OneWork;
import com.sun.enterprise.connectors.work.WorkStats;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;

public final class WorkCoordinator {
    static final int WAIT_UNTIL_START = 1;
    static final int WAIT_UNTIL_FINISH = 2;
    static final int NO_WAIT = 3;
    static final int CREATED = 1;
    static final int STARTED = 2;
    static final int COMPLETED = 3;
    static final int TIMEDOUT = 4;
    private volatile int waitMode;
    private volatile int state = 1;
    private final boolean workIsBad = false;
    private final javax.resource.spi.work.Work work;
    private final long timeout;
    private long startTime;
    private final ExecutionContext ec;
    private final WorkQueue queue;
    private final WorkListener listener;
    private volatile WorkException exception;
    private final Object lock;
    private static int seed;
    private final int id;
    private static final Logger logger;
    private WorkStats workStats = null;
    private ConnectorRuntime runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkCoordinator(javax.resource.spi.work.Work work, long timeout, ExecutionContext ec, WorkQueue queue, WorkListener listener, WorkStats workStats, ConnectorRuntime runtime) {
        this.work = work;
        this.timeout = timeout;
        this.ec = ec;
        this.queue = queue;
        this.listener = listener;
        Class<WorkCoordinator> clazz = WorkCoordinator.class;
        synchronized (WorkCoordinator.class) {
            this.id = ++seed;
            // ** MonitorExit[var9_8] (shouldn't be in output)
            this.runtime = runtime;
            this.lock = new Object();
            this.workStats = workStats;
            return;
        }
    }

    public void submitWork(int waitMode) {
        this.waitMode = waitMode;
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.workAccepted(new WorkEvent(this, 1, this.work, null));
        }
        if (this.workStats != null) {
            ++this.workStats.submittedWorkCount;
            this.workStats.incrementWaitQueueLength();
        }
        this.queue.addWork((Work)new OneWork(this.work, this));
    }

    public void preInvoke() {
        if (this.waitMode == 3 && this.timeout > -1L) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.workStats != null) {
                this.workStats.setWorkWaitTime(elapsedTime);
            }
            if (elapsedTime > this.timeout) {
                this.workTimedOut();
            }
        }
        this.setState(2);
        if (this.waitMode == 1) {
            this.unLock();
        }
        if (!this.proceed()) {
            if (this.workStats != null) {
                this.workStats.decrementWaitQueueLength();
            }
            return;
        }
        if (this.listener != null) {
            this.listener.workStarted(new WorkEvent(this, 3, this.work, null));
        }
        try {
            JavaEETransactionManager tm = this.getTransactionManager();
            if (this.ec != null && this.ec.getXid() != null) {
                tm.recreate(this.ec.getXid(), this.ec.getTransactionTimeout());
            }
        }
        catch (WorkException we) {
            this.exception = we;
        }
        catch (Exception e) {
            this.setException(e);
        }
        if (this.workStats != null) {
            this.workStats.setActiveWorkCount(++this.workStats.currentActiveWorkCount);
            this.workStats.decrementWaitQueueLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void postInvoke() {
        block19: {
            boolean txImported;
            block18: {
                txImported = this.ec != null && this.ec.getXid() != null;
                JavaEETransactionManager tm = this.getTransactionManager();
                if (!txImported) break block18;
                tm.release(this.ec.getXid());
            }
            Object var4_4 = null;
            try {
                if (this.workStats != null) {
                    this.workStats.setActiveWorkCount(--this.workStats.currentActiveWorkCount);
                    ++this.workStats.completedWorkCount;
                }
                if (this.listener != null && !this.isTimedOut() && this.exception == null) {
                    this.listener.workCompleted(new WorkEvent(this, 4, this.work, this.getException()));
                }
                if (txImported) {
                    JavaEETransactionManager tm = this.getTransactionManager();
                    tm.clearThreadTx();
                }
                break block19;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage());
            }
            break block19;
            {
                catch (WorkException ex) {
                    this.setException(ex);
                    Object var4_5 = null;
                    try {
                        if (this.workStats != null) {
                            this.workStats.setActiveWorkCount(--this.workStats.currentActiveWorkCount);
                            ++this.workStats.completedWorkCount;
                        }
                        if (this.listener != null && !this.isTimedOut() && this.exception == null) {
                            this.listener.workCompleted(new WorkEvent(this, 4, this.work, this.getException()));
                        }
                        if (txImported) {
                            JavaEETransactionManager tm = this.getTransactionManager();
                            tm.clearThreadTx();
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (this.workStats != null) {
                        this.workStats.setActiveWorkCount(--this.workStats.currentActiveWorkCount);
                        ++this.workStats.completedWorkCount;
                    }
                    if (this.listener != null && !this.isTimedOut() && this.exception == null) {
                        this.listener.workCompleted(new WorkEvent(this, 4, this.work, this.getException()));
                    }
                    if (txImported) {
                        JavaEETransactionManager tm = this.getTransactionManager();
                        tm.clearThreadTx();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage());
                }
                throw throwable;
            }
        }
        this.setState(3);
        if (this.waitMode == 2) {
            this.unLock();
        }
    }

    private void workTimedOut() {
        this.setState(4);
        this.exception = new WorkRejectedException();
        this.exception.setErrorCode("1");
        if (this.listener != null) {
            this.listener.workRejected(new WorkEvent(this, 2, this.work, this.exception));
        }
        if (this.workStats != null) {
            ++this.workStats.rejectedWorkCount;
            this.workStats.setActiveWorkCount(--this.workStats.currentActiveWorkCount);
        }
    }

    public boolean proceed() {
        return !this.isTimedOut() && this.exception == null;
    }

    private boolean isTimedOut() {
        return this.getState() == 4;
    }

    public WorkException getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        if (this.getState() < 2) {
            if (e instanceof WorkRejectedException) {
                this.exception = (WorkException)e;
            } else if (e instanceof WorkException) {
                WorkException we = (WorkException)e;
                this.exception = new WorkRejectedException(we);
                this.exception.setErrorCode(we.getErrorCode());
            } else {
                this.exception = new WorkRejectedException(e);
                this.exception.setErrorCode("0");
            }
        } else if (e instanceof WorkCompletedException) {
            this.exception = (WorkException)e;
        } else if (e instanceof WorkException) {
            WorkException we = (WorkException)e;
            this.exception = new WorkCompletedException(we);
            this.exception.setErrorCode(we.getErrorCode());
        } else {
            this.exception = new WorkCompletedException(e);
            this.exception.setErrorCode("0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        block14: {
            if (!this.lockRequired()) {
                return;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        if (this.timeout != -1L) {
                            this.lock.wait(this.timeout);
                        } else {
                            this.lock.wait();
                        }
                    }
                }
                if (this.getState() < 2) {
                    this.workTimedOut();
                }
                if (!this.lockRequired()) break block14;
                object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        this.lock.wait();
                    }
                }
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public String toString() {
        return this.id + ":" + this.work;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public synchronized int getState() {
        return this.state;
    }

    private boolean lockRequired() {
        if (!this.proceed()) {
            return false;
        }
        if (this.waitMode == 3) {
            return false;
        }
        if (this.waitMode == 2) {
            return this.getState() < 3;
        }
        if (this.waitMode == 1) {
            return this.getState() < 2;
        }
        return false;
    }

    private boolean checkStateBeforeLocking() {
        if (this.waitMode == 2) {
            return this.state < 3;
        }
        if (this.waitMode == 1) {
            return this.state < 2;
        }
        return false;
    }

    private JavaEETransactionManager getTransactionManager() {
        return this.runtime.getTransactionManager();
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

