/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.context;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.context.AnnotationContext;

public class EjbBundleContext
extends ResourceContainerContextImpl {
    public EjbBundleContext(EjbBundleDescriptor descriptor) {
        super(descriptor);
    }

    public EjbBundleDescriptor getDescriptor() {
        return (EjbBundleDescriptor)this.descriptor;
    }

    public AnnotatedElementHandler createContextForEjb() {
        Class ejbClass = (Class)this.getProcessingContext().getProcessor().getLastAnnotatedElement(ElementType.TYPE);
        EjbDescriptor[] ejbDescs = null;
        String ejbClassName = null;
        if (ejbClass != null) {
            ejbClassName = ejbClass.getName();
            ejbDescs = this.getDescriptor().getEjbByClassName(ejbClassName);
        }
        AnnotationContext aeHandler = null;
        if (ejbDescs != null && ejbDescs.length > 1) {
            aeHandler = new EjbsContext(ejbDescs, ejbClass);
        } else if (ejbDescs != null && ejbDescs.length == 1) {
            aeHandler = new EjbContext(ejbDescs[0], ejbClass);
        }
        if (aeHandler != null) {
            this.getProcessingContext().pushHandler(aeHandler);
        }
        return aeHandler;
    }

    public HandlerChainContainer[] getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        if (serviceSideHandlerChain) {
            EjbDescriptor[] ejbs = declaringClass.isInterface() ? this.getDescriptor().getEjbBySEIName(declaringClass.getName()) : this.getDescriptor().getEjbByClassName(declaringClass.getName());
            ArrayList<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(this.getDescriptor().getWebServices().getEndpointsImplementedBy(ejb));
            }
            return result.toArray(new HandlerChainContainer[0]);
        }
        ArrayList<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
        result.addAll(this.getDescriptor().getServiceReferenceDescriptors());
        return result.toArray(new HandlerChainContainer[0]);
    }

    public ServiceReferenceContainer[] getServiceRefContainers() {
        ServiceReferenceContainer[] container = new ServiceReferenceContainer[this.getDescriptor().getEjbs().size()];
        ServiceReferenceContainer[] ret = this.getDescriptor().getEjbs().toArray(container);
        return ret;
    }

    public AnnotatedElementHandler createContextForEjbInterceptor() {
        Class interceptorClass = (Class)this.getProcessingContext().getProcessor().getLastAnnotatedElement(ElementType.TYPE);
        EjbInterceptor ejbInterceptor = this.getDescriptor().getInterceptorByClassName(interceptorClass.getName());
        EjbInterceptorContext aeHandler = null;
        if (ejbInterceptor != null) {
            aeHandler = new EjbInterceptorContext(ejbInterceptor);
            this.getProcessingContext().pushHandler(aeHandler);
        }
        return aeHandler;
    }
}

