/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.context;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.impl.ComponentDefinition;

public class EjbContext
extends ResourceContainerContextImpl {
    private WebServiceEndpoint endpoint;
    private Method[] methods;
    private boolean inherited;
    private ArrayList<PostProcessInfo> postProcessInfos = new ArrayList();

    public EjbContext(EjbDescriptor currentEjb, Class ejbClass) {
        super(currentEjb);
        this.componentClassName = currentEjb.getEjbClassName();
        ComponentDefinition cdef = new ComponentDefinition(ejbClass);
        this.methods = cdef.getMethods();
        Class superClass = ejbClass.getSuperclass();
        this.inherited = superClass != null && !Object.class.equals(superClass);
    }

    public EjbDescriptor getDescriptor() {
        return (EjbDescriptor)this.descriptor;
    }

    public void setDescriptor(EjbDescriptor currentEjb) {
        this.descriptor = currentEjb;
    }

    public void setEndpoint(WebServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void endElement(ElementType type, AnnotatedElement element) throws AnnotationProcessorException {
        if (ElementType.TYPE.equals((Object)type)) {
            for (PostProcessInfo ppInfo : this.postProcessInfos) {
                ppInfo.postProcessor.postProcessAnnotation(ppInfo.ainfo, this);
            }
            this.getProcessingContext().popHandler();
        }
    }

    public Class getDeclaringClass(MethodDescriptor md) {
        Method method = md.getMethod(this.getDescriptor());
        Class<?> declaringClass = null;
        for (Method m : this.methods) {
            if (!TypeUtil.sameMethodSignature(m, method)) continue;
            declaringClass = m.getDeclaringClass();
        }
        return declaringClass;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void addPostProcessInfo(AnnotationInfo ainfo, PostProcessor postProcessor) {
        PostProcessInfo ppInfo = new PostProcessInfo();
        ppInfo.ainfo = ainfo;
        ppInfo.postProcessor = postProcessor;
        this.postProcessInfos.add(ppInfo);
    }

    public ServiceReferenceContainer[] getServiceRefContainers(String implName) {
        return this.getDescriptor().getEjbBundleDescriptor().getEjbByClassName(implName);
    }

    public HandlerChainContainer[] getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        if (serviceSideHandlerChain) {
            EjbDescriptor[] ejbs = this.getDescriptor().getEjbBundleDescriptor().getEjbByClassName(declaringClass.getName());
            ArrayList<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(this.getDescriptor().getEjbBundleDescriptor().getWebServices().getEndpointsImplementedBy(ejb));
            }
            return result.toArray(new HandlerChainContainer[0]);
        }
        ArrayList<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
        result.addAll(this.getDescriptor().getEjbBundleDescriptor().getServiceReferenceDescriptors());
        return result.toArray(new HandlerChainContainer[0]);
    }

    private class PostProcessInfo {
        public AnnotationInfo ainfo;
        public PostProcessor postProcessor;

        private PostProcessInfo() {
        }
    }
}

