/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.ejb.Stateless;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServiceProviderHandler
implements AnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return WebServiceProvider.class;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        Class[] dependencies = new Class[]{Stateless.class};
        return dependencies;
    }

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebService newWS;
        WebServicesDescriptor wsDesc;
        WebServiceEndpoint endpoint;
        String portName;
        String targetNameSpace;
        BundleDescriptor bundleDesc;
        ResourceContainerContextImpl ctx;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        if (!(annElem instanceof Class)) {
            AnnotationProcessorException ape = new AnnotationProcessorException("@WebServiceProvider can only be specified on TYPE", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.FAILED);
        }
        if (!Provider.class.isAssignableFrom((Class)annElem)) {
            AnnotationProcessorException ape = new AnnotationProcessorException(annElem.toString() + "does not implement the javax.xml.ws.Provider interface", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.FAILED);
        }
        WebServiceProvider ann = (WebServiceProvider)annInfo.getAnnotation();
        if (annElem.getAnnotation(Stateless.class) != null) {
            ctx = (EjbContext)annCtx;
            bundleDesc = ((EjbContext)ctx).getDescriptor().getEjbBundleDescriptor();
            bundleDesc.setSpecVersion("3.0");
        } else {
            ctx = (WebBundleContext)annCtx;
            bundleDesc = ((WebBundleContext)ctx).getDescriptor();
            bundleDesc.setSpecVersion("2.5");
        }
        String portComponentName = ((Class)annElem).getName();
        String svcName = ann.serviceName();
        if (svcName == null) {
            svcName = "";
        }
        String userSpecifiedBinding = null;
        BindingType bindingAnn = ((Class)annElem).getAnnotation(BindingType.class);
        if (bindingAnn != null) {
            userSpecifiedBinding = bindingAnn.value();
        }
        if ((targetNameSpace = ann.targetNamespace()) == null) {
            targetNameSpace = "";
        }
        if ((portName = ann.portName()) == null) {
            portName = "";
        }
        if ((endpoint = (wsDesc = bundleDesc.getWebServices()).getEndpointByName(portComponentName)) == null) {
            newWS = svcName.length() != 0 ? wsDesc.getWebServiceByName(svcName) : wsDesc.getWebServiceByName(((Class)annElem).getSimpleName() + "Service");
            if (newWS == null) {
                newWS = new WebService();
                if (svcName.length() != 0) {
                    newWS.setName(svcName);
                } else {
                    newWS.setName(((Class)annElem).getSimpleName() + "Service");
                }
                wsDesc.addWebService(newWS);
            }
            endpoint = new WebServiceEndpoint();
            endpoint.setEndpointName(portComponentName);
            newWS.addEndpoint(endpoint);
            wsDesc.setSpecVersion("1.2");
        } else {
            newWS = endpoint.getWebService();
        }
        if (endpoint.getWsdlService() != null) {
            if (targetNameSpace != null && targetNameSpace.length() != 0 && !endpoint.getWsdlService().getNamespaceURI().equals(targetNameSpace)) {
                throw new AnnotationProcessorException("Target Namespace inwsdl-service element does not match @WebService.targetNamespace", annInfo);
            }
            targetNameSpace = endpoint.getWsdlService().getNamespaceURI();
        }
        if (!endpoint.hasUserSpecifiedProtocolBinding() && userSpecifiedBinding != null && userSpecifiedBinding.length() != 0) {
            endpoint.setProtocolBinding(userSpecifiedBinding);
        }
        if (newWS.getWsdlFileUri() == null && ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
            newWS.setWsdlFileUri(ann.wsdlLocation());
        }
        annElem = annInfo.getAnnotatedElement();
        Class clz = (Class)annElem;
        Class<?> serviceEndpointIntf = null;
        for (Class<?> intf : clz.getInterfaces()) {
            if (!Provider.class.isAssignableFrom(intf)) continue;
            serviceEndpointIntf = intf;
            break;
        }
        if (serviceEndpointIntf == null) {
            endpoint.setServiceEndpointInterface("javax.xml.ws.Provider");
        } else {
            endpoint.setServiceEndpointInterface(serviceEndpointIntf.getName());
        }
        if (ModuleType.WAR.equals(bundleDesc.getModuleType())) {
            if (endpoint.getServletImplClass() == null) {
                endpoint.setServletImplClass(((Class)annElem).getName());
            }
            WebBundleDescriptor webBundle = (WebBundleDescriptor)bundleDesc;
            if (endpoint.getWebComponentLink() == null) {
                endpoint.setWebComponentLink(portComponentName);
            }
            if (endpoint.getWebComponentImpl() == null) {
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(endpoint.getWebComponentLink());
                if (webComponent == null) {
                    webComponent = new WebComponentDescriptor();
                    webComponent.setServlet(true);
                    webComponent.setWebComponentImplementation(((Class)annElem).getCanonicalName());
                    webComponent.setName(endpoint.getEndpointName());
                    webComponent.addUrlPattern("/" + newWS.getName());
                    webBundle.addWebComponentDescriptor(webComponent);
                }
                endpoint.setWebComponentImpl(webComponent);
            }
        } else if (endpoint.getEjbLink() == null) {
            EjbDescriptor[] ejbDescs = ((EjbBundleDescriptor)bundleDesc).getEjbByClassName(((Class)annElem).getName());
            if (ejbDescs.length != 1) {
                throw new AnnotationProcessorException("Unable to find matching descriptor for EJB endpoint", annInfo);
            }
            endpoint.setEjbComponentImpl(ejbDescs[0]);
            ejbDescs[0].setWebServiceEndpointInterfaceName(endpoint.getServiceEndpointInterface());
            endpoint.setEjbLink(ejbDescs[0].getName());
        }
        if (endpoint.getWsdlPort() == null) {
            endpoint.setWsdlPort(new QName(targetNameSpace, portName, "ns1"));
        }
        if (endpoint.getWsdlService() == null) {
            endpoint.setWsdlService(new QName(targetNameSpace, svcName, "ns1"));
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.PROCESSED);
    }
}

