/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

@Service
public class ApplicationFactory
implements ContractProvider {
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Habitat habitat;
    @Inject
    ArchivistFactory archivistFactory;
    protected static final Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Archivist.class);

    public Application openArchive(URI jarFile) throws IOException, SAXParseException {
        return this.openArchive(jarFile, false);
    }

    public Application openArchive(Archivist archivist, URI jarFile, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        ReadableArchive archive = this.archiveFactory.openArchive(jarFile);
        Application application = this.openArchive(archivist, archive, handleRuntimeInfo);
        archive.close();
        return application;
    }

    public Application openArchive(Archivist archivist, ReadableArchive in, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        return this.openArchive(in.getURI().getSchemeSpecificPart(), archivist, in, handleRuntimeInfo);
    }

    public Application openArchive(String appName, Archivist archivist, ReadableArchive in, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        Application application;
        archivist.setHandleRuntimeInfo(false);
        Object descriptor = archivist.open(in);
        if (descriptor instanceof Application) {
            application = (Application)descriptor;
            application.setRegistrationName(appName);
        } else {
            BundleDescriptor aBundle = (BundleDescriptor)descriptor;
            if (aBundle == null) {
                logger.log(Level.SEVERE, localStrings.getLocalString("enterprise.deployment.cannotreadDDs", "Cannot read the Deployment Descriptors for module {0}", in.getURI()));
                return null;
            }
            ModuleDescriptor newModule = archivist.createModuleDescriptor(aBundle);
            newModule.setArchiveUri(in.getURI().getSchemeSpecificPart());
            application = Application.createApplication(this.habitat, appName, newModule);
        }
        if (handleRuntimeInfo) {
            archivist.setHandleRuntimeInfo(true);
            archivist.readRuntimeDeploymentDescriptor(in, descriptor);
        }
        return application;
    }

    public Application openArchive(URI jarFile, boolean handleRuntimeInfo) throws IOException, SAXParseException {
        ReadableArchive in = this.archiveFactory.openArchive(jarFile);
        Archivist archivist = this.archivistFactory.getPrivateArchivistFor(in);
        return this.openArchive(archivist, jarFile, handleRuntimeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationName(File jarFile) throws IOException {
        block8: {
            if (!jarFile.exists()) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", jarFile));
            }
            JarFile jar = null;
            try {
                jar = new JarFile(jarFile);
                ApplicationDeploymentDescriptorFile node = new ApplicationDeploymentDescriptorFile();
                node.setXMLValidation(false);
                ZipEntry deploymentEntry = jar.getEntry(node.getDeploymentDescriptorPath());
                if (deploymentEntry == null) break block8;
                try {
                    Application application = (Application)node.read(jar.getInputStream(deploymentEntry));
                    String string = application.getDisplayName();
                    return string;
                }
                catch (Exception pe) {
                    pe.printStackTrace();
                }
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
            }
        }
        return null;
    }

    public void readPersistenceDeploymentDescriptorsRecursively(ReadableArchive archive, Application application) throws IOException, SAXParseException {
        new ApplicationArchivist().readPersistenceDeploymentDescriptorsRecursively(archive, application);
    }
}

