/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.enterprise.naming.impl.SerialNameParser;
import com.sun.enterprise.naming.util.LogFacade;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class TransientContext
implements Context,
Serializable {
    static Logger _logger = LogFacade.getLogger();
    public static final boolean debug = false;
    Hashtable myEnv;
    private Hashtable bindings = new Hashtable();
    static NameParser myParser = new SerialNameParser();

    public Context createSubcontext(String name) throws NamingException {
        return this.drillDownAndCreateSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        this.drillDownAndDestroySubcontext(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context drillDownAndCreateSubcontext(String name) throws NamingException {
        TransientContext ctx;
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            throw new InvalidNameException("Cannot create empty subcontext");
        }
        if (n.size() == 1) {
            if (this.bindings.containsKey(name)) {
                throw new NameAlreadyBoundException("Subcontext " + name + "already present");
            }
            TransientContext ctx2 = null;
            ctx2 = new TransientContext();
            this.bindings.put(name, ctx2);
            return ctx2;
        }
        String suffix = n.getSuffix(1).toString();
        try {
            ctx = this.resolveContext(n.get(0));
        }
        catch (NameNotFoundException e) {
            ctx = new TransientContext();
        }
        Context retCtx = ctx.createSubcontext(suffix);
        this.bindings.put(n.get(0), ctx);
        return retCtx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drillDownAndDestroySubcontext(String name) throws NamingException {
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            throw new InvalidNameException("Cannot destoy empty subcontext");
        }
        if (n.size() == 1) {
            if (!this.bindings.containsKey(name)) throw new NameNotFoundException("Subcontext: " + name + " not found");
            this.bindings.remove(name);
            return;
        } else {
            String suffix = n.getSuffix(1).toString();
            TransientContext ctx = this.resolveContext(n.get(0));
            ctx.destroySubcontext(suffix);
        }
    }

    public Object lookup(String name) throws NamingException {
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (n.size() == 1) {
            return this.doLookup(((Object)n).toString());
        }
        String suffix = n.getSuffix(1).toString();
        TransientContext ctx = this.resolveContext(n.get(0));
        return ctx.lookup(suffix);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    private Object doLookup(String name) throws NamingException {
        Object answer = this.bindings.get(name);
        if (answer == null) {
            throw new NameNotFoundException(name + " not found");
        }
        return answer;
    }

    public void bind(String name, Object obj) throws NamingException {
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (n.size() == 1) {
            this.doBindOrRebind(((Object)n).toString(), obj, false);
        } else {
            Context ctx;
            String suffix = n.getSuffix(1).toString();
            try {
                ctx = this.resolveContext(n.get(0));
            }
            catch (NameNotFoundException e) {
                ctx = this.createSubcontext(n.get(0));
            }
            ctx.bind(suffix, obj);
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    private TransientContext resolveContext(String s) throws NamingException {
        Object obj = this.bindings.get(s);
        if (obj == null) {
            throw new NameNotFoundException(s);
        }
        if (!(obj instanceof TransientContext)) {
            throw new NameAlreadyBoundException(s);
        }
        TransientContext ctx = (TransientContext)obj;
        return ctx;
    }

    private void doBindOrRebind(String name, Object obj, boolean rebind) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (!rebind && this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (n.size() == 1) {
            this.doBindOrRebind(((Object)n).toString(), obj, true);
        } else {
            String suffix = n.getSuffix(1).toString();
            Context ctx = null;
            try {
                ctx = this.resolveContext(n.get(0));
                ctx.rebind(suffix, obj);
            }
            catch (NameNotFoundException e) {
                ctx = this.createSubcontext(n.get(0));
                ctx.rebind(suffix, obj);
            }
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    private void doUnbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        if (this.bindings.get(name) == null) {
            throw new NameNotFoundException("Cannot find name to unbind");
        }
        this.bindings.remove(name);
    }

    public void unbind(String name) throws NamingException {
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        if (n.size() == 1) {
            this.doUnbind(((Object)n).toString());
        } else {
            String suffix = n.getSuffix(1).toString();
            TransientContext ctx = this.resolveContext(n.get(0));
            ctx.unbind(suffix);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.bindings.get(newname) != null) {
            throw new NameAlreadyBoundException(newname + " is already bound");
        }
        Object oldBinding = this.bindings.remove(oldname);
        if (oldBinding == null) {
            throw new NameNotFoundException(oldname + " not bound");
        }
        this.bindings.put(newname, oldBinding);
    }

    public Hashtable list() {
        return this.bindings;
    }

    public Hashtable listContext(String name) throws NamingException {
        if (name.equals("")) {
            return this.bindings;
        }
        Object target = this.lookup(name);
        if (target instanceof TransientContext) {
            return ((TransientContext)target).listContext("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new RepNames(this.bindings);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new RepBindings(this.bindings);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace() not implemented");
    }

    private static void print(Hashtable ht) {
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object value = ht.get(key);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "[" + key + ":" + key.getClass().getName() + ", " + value + ":" + value.getClass().getName() + "]");
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

