/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.rm;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;

public class ResourceManagerImpl
implements ResourceManager {
    static Logger _logger = null;

    public Transaction getTransaction() throws PoolingException {
        InvocationManager invmgr = ConnectorRuntime.getRuntime().getInvocationManager();
        Object inv = invmgr.getCurrentInvocation();
        if (inv == null) {
            try {
                return ConnectorRuntime.getRuntime().getTransaction();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return (Transaction)((ComponentInvocation)inv).getTransaction();
    }

    public Object getComponent() {
        InvocationManager invmgr = ConnectorRuntime.getRuntime().getInvocationManager();
        Object inv = invmgr.getCurrentInvocation();
        if (inv == null) {
            return null;
        }
        return ((ComponentInvocation)inv).getInstance();
    }

    public void enlistResource(ResourceHandle h) throws PoolingException {
        this.registerResource(h);
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        block9: {
            try {
                Transaction tran = null;
                JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
                if (!handle.isTransactional()) break block9;
                InvocationManager invmgr = ConnectorRuntime.getRuntime().getInvocationManager();
                Object inv = invmgr.getCurrentInvocation();
                if (inv == null) {
                    try {
                        tran = tm.getTransaction();
                    }
                    catch (Exception e) {
                        tran = null;
                        _logger.log(Level.INFO, e.getMessage());
                    }
                } else {
                    tran = (Transaction)((ComponentInvocation)inv).getTransaction();
                    tm.registerComponentResource(handle);
                }
                if (tran == null) break block9;
                try {
                    tm.enlistResource(tran, handle);
                }
                catch (Exception ex) {
                    _logger.fine("Exception whle trying to enlist resource " + ex.getMessage());
                    if (inv != null) {
                        _logger.fine("Attempting to unregister component resource");
                        tm.unregisterComponentResource(handle);
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "poolmgr.component_register_exception", ex);
                throw new PoolingException(ex.toString(), ex);
            }
        }
    }

    protected void enlist(JavaEETransactionManager tm, Transaction tran, ResourceHandle h) throws PoolingException {
        try {
            tm.enlistResource(tran, h);
        }
        catch (Exception e) {
            PoolingException pe = new PoolingException(e.getMessage());
            pe.initCause(e);
            throw pe;
        }
    }

    public void rollBackTransaction() {
        InvocationManager invmgr = ConnectorRuntime.getRuntime().getInvocationManager();
        JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
        Transaction tran = null;
        try {
            Object inv = invmgr.getCurrentInvocation();
            if (inv == null) {
                try {
                    tran = tm.getTransaction();
                }
                catch (Exception e) {
                    tran = null;
                    _logger.log(Level.INFO, e.getMessage());
                }
            } else {
                tran = (Transaction)((ComponentInvocation)inv).getTransaction();
            }
            if (tran != null) {
                tran.setRollbackOnly();
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    public void delistResource(ResourceHandle resource, int xaresFlag) {
        this.unregisterResource(resource, xaresFlag);
    }

    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
        Transaction tran = null;
        try {
            if (resource.isTransactional()) {
                InvocationManager invmgr = ConnectorRuntime.getRuntime().getInvocationManager();
                Object inv = invmgr.getCurrentInvocation();
                if (inv == null) {
                    try {
                        tran = tm.getTransaction();
                    }
                    catch (Exception e) {
                        tran = null;
                        _logger.log(Level.INFO, e.getMessage());
                    }
                } else {
                    tran = (Transaction)((ComponentInvocation)inv).getTransaction();
                    tm.unregisterComponentResource(resource);
                }
                if (tran != null && resource.isEnlisted()) {
                    tm.delistResource(tran, resource, xaresFlag);
                }
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
        }
        catch (InvocationException ex) {
            // empty catch block
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

