/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.factory;

import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactory;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FactoryForSecurityManagerFactoryImpl
implements FactoryForSecurityManagerFactory {
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static FactoryForSecurityManagerFactory _theFactory;
    private static String WEB;
    private static String EJB;

    private FactoryForSecurityManagerFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryForSecurityManagerFactory getInstance() {
        try {
            rwLock.readLock().lock();
            if (_theFactory != null) {
                FactoryForSecurityManagerFactory factoryForSecurityManagerFactory = _theFactory;
                return factoryForSecurityManagerFactory;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        try {
            rwLock.writeLock().lock();
            if (_theFactory == null) {
                _theFactory = new FactoryForSecurityManagerFactoryImpl();
            }
            FactoryForSecurityManagerFactory factoryForSecurityManagerFactory = _theFactory;
            return factoryForSecurityManagerFactory;
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    public SecurityManagerFactory getSecurityManagerFactory(String type) {
        if (type.equalsIgnoreCase(WEB) || type.equalsIgnoreCase(EJB)) {
            // empty if block
        }
        return null;
    }

    static {
        WEB = "web";
        EJB = "ejb";
    }
}

