/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.security.jmac.config.EntryInfo;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.security.jmac.config.RegistrationContextImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.config.AuthConfigFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegStoreFileParser {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final String SEP = ":";
    private static final String CON_ENTRY = "con-entry";
    private static final String REG_ENTRY = "reg-entry";
    private static final String REG_CTX = "reg-ctx";
    private static final String LAYER = "layer";
    private static final String APP_CTX = "app-ctx";
    private static final String DESCRIPTION = "description";
    private static final String[] INDENT = new String[]{"", "  ", "    "};
    private File confFile;
    private List<EntryInfo> entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegStoreFileParser(String pathParent, String pathChild, boolean create) {
        block10: {
            try {
                this.confFile = new File(pathParent, pathChild);
                if (this.confFile.exists()) {
                    this.loadEntries();
                    break block10;
                }
                if (create) {
                    File file = this.confFile;
                    synchronized (file) {
                        this.entries = GFAuthConfigFactory.getDefaultProviders();
                        this.writeEntries();
                        break block10;
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "jmac.factory_file_not_found", pathParent + File.pathSeparator + pathChild);
                }
            }
            catch (IOException ioe) {
                this.logWarningDefault(ioe);
            }
            catch (IllegalArgumentException iae) {
                this.logWarningDefault(iae);
            }
        }
        if (this.entries == null) {
            this.entries = GFAuthConfigFactory.getDefaultProviders();
        }
    }

    private void logWarningUpdated(Exception exception) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jmac.factory_could_not_persist", exception.toString());
        }
    }

    private void logWarningDefault(Exception exception) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jmac.factory_could_not_read", exception.toString());
        }
    }

    List<EntryInfo> getPersistedEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(String className, AuthConfigFactory.RegistrationContext ctx, Map properties) {
        File file = this.confFile;
        synchronized (file) {
            if (this.checkAndAddToList(className, ctx, properties)) {
                try {
                    this.writeEntries();
                }
                catch (IOException ioe) {
                    this.logWarningUpdated(ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(AuthConfigFactory.RegistrationContext ctx) {
        File file = this.confFile;
        synchronized (file) {
            if (this.checkAndRemoveFromList(ctx)) {
                try {
                    this.writeEntries();
                }
                catch (IOException ioe) {
                    this.logWarningUpdated(ioe);
                }
            }
        }
    }

    private boolean checkAndAddToList(String className, AuthConfigFactory.RegistrationContext ctx, Map props) {
        EntryInfo newEntry;
        EntryInfo entry;
        if (props != null && props.isEmpty()) {
            props = null;
        }
        if ((entry = this.getMatchingRegEntry(newEntry = new EntryInfo(className, (Map<String, String>)props, ctx))) == null) {
            this.entries.add(newEntry);
            return true;
        }
        if (entry.isConstructorEntry()) {
            return false;
        }
        if (entry.getRegContexts().contains(ctx)) {
            return false;
        }
        entry.getRegContexts().add(new RegistrationContextImpl(ctx));
        return true;
    }

    private boolean checkAndRemoveFromList(AuthConfigFactory.RegistrationContext target) {
        boolean retValue = false;
        for (EntryInfo info : this.entries) {
            if (info.isConstructorEntry()) continue;
            Iterator<AuthConfigFactory.RegistrationContext> iter = info.getRegContexts().iterator();
            while (iter.hasNext()) {
                AuthConfigFactory.RegistrationContext ctx = iter.next();
                if (!ctx.equals(target)) continue;
                iter.remove();
                retValue = true;
            }
        }
        return retValue;
    }

    private EntryInfo getMatchingRegEntry(EntryInfo target) {
        for (EntryInfo info : this.entries) {
            if (!info.equals(target)) continue;
            return info;
        }
        return null;
    }

    private void writeEntries() throws IOException {
        if (!this.confFile.canWrite() && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jmac.factory_cannot_write_file", this.confFile.getPath());
        }
        this.clearExistingFile();
        PrintWriter out = new PrintWriter(this.confFile);
        int indent = 0;
        for (EntryInfo info : this.entries) {
            if (info.isConstructorEntry()) {
                this.writeConEntry(info, out, indent);
                continue;
            }
            this.writeRegEntry(info, out, indent);
        }
        out.close();
    }

    private void writeConEntry(EntryInfo info, PrintWriter out, int i) {
        out.println(INDENT[i++] + CON_ENTRY + " {");
        out.println(INDENT[i] + info.getClassName());
        Map<String, String> props = info.getProperties();
        if (props != null) {
            for (String key : props.keySet()) {
                out.println(INDENT[i] + key + SEP + props.get(key));
            }
        }
        out.println(INDENT[--i] + "}");
    }

    private void writeRegEntry(EntryInfo info, PrintWriter out, int i) {
        out.println(INDENT[i++] + REG_ENTRY + " {");
        if (info.getClassName() != null) {
            this.writeConEntry(info, out, i);
        }
        for (AuthConfigFactory.RegistrationContext ctx : info.getRegContexts()) {
            out.println(INDENT[i++] + REG_CTX + " {");
            if (ctx.getMessageLayer() != null) {
                out.println(INDENT[i] + LAYER + SEP + ctx.getMessageLayer());
            }
            if (ctx.getAppContext() != null) {
                out.println(INDENT[i] + APP_CTX + SEP + ctx.getAppContext());
            }
            if (ctx.getDescription() != null) {
                out.println(INDENT[i] + DESCRIPTION + SEP + ctx.getDescription());
            }
            out.println(INDENT[--i] + "}");
        }
        out.println(INDENT[--i] + "}");
    }

    private void clearExistingFile() throws IOException {
        if (this.confFile.exists()) {
            this.confFile.delete();
        }
        this.confFile.createNewFile();
    }

    private void loadEntries() throws IOException {
        this.entries = new ArrayList<EntryInfo>();
        BufferedReader reader = new BufferedReader(new FileReader(this.confFile));
        String line = reader.readLine();
        while (line != null) {
            String trimLine = line.trim();
            if (trimLine.startsWith(CON_ENTRY)) {
                this.entries.add(this.readConEntry(reader));
            } else if (trimLine.startsWith(REG_ENTRY)) {
                this.entries.add(this.readRegEntry(reader));
            }
            line = reader.readLine();
        }
    }

    private EntryInfo readConEntry(BufferedReader reader) throws IOException {
        String className = reader.readLine().trim();
        Map<String, String> properties = this.readProperties(reader);
        return new EntryInfo(className, properties);
    }

    private Map<String, String> readProperties(BufferedReader reader) throws IOException {
        String line = reader.readLine().trim();
        if (line.equals("}")) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        while (!line.equals("}")) {
            properties.put(line.substring(0, line.indexOf(SEP)), line.substring(line.indexOf(SEP) + 1, line.length()));
            line = reader.readLine().trim();
        }
        return properties;
    }

    private EntryInfo readRegEntry(BufferedReader reader) throws IOException {
        String className = null;
        Map<String, String> properties = null;
        ArrayList<AuthConfigFactory.RegistrationContext> ctxs = new ArrayList<AuthConfigFactory.RegistrationContext>();
        String line = reader.readLine().trim();
        while (!line.equals("}")) {
            if (line.startsWith(CON_ENTRY)) {
                EntryInfo conEntry = this.readConEntry(reader);
                className = conEntry.getClassName();
                properties = conEntry.getProperties();
            } else if (line.startsWith(REG_CTX)) {
                ctxs.add(this.readRegContext(reader));
            }
            line = reader.readLine().trim();
        }
        return new EntryInfo(className, properties, ctxs);
    }

    private AuthConfigFactory.RegistrationContext readRegContext(BufferedReader reader) throws IOException {
        String layer = null;
        String appCtx = null;
        String description = null;
        String line = reader.readLine().trim();
        while (!line.equals("}")) {
            String value = line.substring(line.indexOf(SEP) + 1, line.length());
            if (line.startsWith(LAYER)) {
                layer = value;
            } else if (line.startsWith(APP_CTX)) {
                appCtx = value;
            } else if (line.startsWith(DESCRIPTION)) {
                description = value;
            }
            line = reader.readLine().trim();
        }
        return new RegistrationContextImpl(layer, appCtx, description, true);
    }
}

