/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.InstallerThread;
import com.sun.enterprise.v3.admin.adapter.ProgressObject;
import com.sun.enterprise.v3.admin.adapter.Utils;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyOutputBuffer;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.internal.api.AdminAuthenticator;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public final class AdminConsoleAdapter
extends GrizzlyAdapter
implements Adapter,
PostConstruct,
EventListener {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    AdminService as;
    private String contextRoot;
    private final List<URL> urls = new ArrayList<URL>();
    private File diskLocation;
    private String proxyHost;
    private int proxyPort;
    private long visitorId;
    private AdapterState state = AdapterState.UNINITIAZED;
    private ProgressObject progress = new ProgressObject();
    private final CountDownLatch latch = new CountDownLatch(1);
    @Inject
    private Logger log;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;
    @Inject(optional=true)
    AdminAuthenticator authenticator = null;
    @Inject
    Events events;
    private String statusHtml;
    private String initHtml = Utils.packageResource2String("downloadgui.html");
    private static final String PROXY_HOST_PARAM = "proxyHost";
    private static final String PROXY_PORT_PARAM = "proxyPort";
    private static final String OK_PARAM = "ok";
    private static final String VISITOR_PARAM = "visitor";
    private static final String VISITOR_TOKEN = "%%%VISITOR%%%";
    private static final String MYURL_TOKEN = "%%%MYURL%%%";
    private static final String STATUS_TOKEN = "%%%STATUS%%%";
    static final String ADMIN_APP_NAME = "__admingui";
    static final String ADMIN_APP_WAR = "__admingui.war";

    public AdminConsoleAdapter() throws IOException {
        this.statusHtml = Utils.packageResource2String("status.html");
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        try {
            if (!this.latch.await(100L, TimeUnit.SECONDS)) {
                this.log.severe("Cannot process admin console request in time");
                return;
            }
        }
        catch (InterruptedException e) {
            this.log.severe("Cannot process admin console request");
            return;
        }
        this.logRequest(req);
        this.handleAuth(req, res);
        if (this.state == AdapterState.APPLICATION_LOADED) {
            this.handleLoadedState();
        } else {
            AdminConsoleAdapter adminConsoleAdapter = this;
            synchronized (adminConsoleAdapter) {
                if (this.state == AdapterState.APPLICATION_NOT_INSTALLED) {
                    this.handleNotInstalledState(req, res);
                } else if (this.state == AdapterState.INSTALLING) {
                    this.handleInstallingState(req, res);
                } else if (this.state == AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED) {
                    this.handleInstalledButNotLoadedState(req, res);
                }
                if (this.state == AdapterState.APPLICATION_LOADED) {
                    this.handleLoadedState();
                }
            }
        }
    }

    public void postConstruct() {
        this.events.register(this);
        this.init();
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        this.latch.countDown();
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("AdminConsoleAdapter is ready.");
        }
    }

    private void handleAuth(GrizzlyRequest greq, GrizzlyResponse gres) {
        try {
            File realmFile = new File(this.env.getProps().get("com.sun.aas.instanceRoot") + "/config/admin-keyfile");
            if (this.authenticator != null && realmFile.exists() && !this.authenticator.authenticate(greq.getRequest(), realmFile)) {
                gres.setStatus(401);
                gres.addHeader("WWW-Authenticate", "BASIC");
                gres.finishResponse();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (this.as == null || this.as.getProperty() == null || this.as.getProperty().isEmpty()) {
            String msg = "Define following properties in <admin-service> element in domain.xmlfor admin console to work properly\nadminConsoleContextRoot, adminConsoleDownloadLocation, adminConsoleFolder";
            this.log.info(msg);
            return;
        }
        List<Property> props = this.as.getProperty();
        for (Property prop : props) {
            this.setContextRoot(prop);
            this.setDownloadLocations(prop);
            this.setLocationOnDisk(prop);
        }
        this.initState();
    }

    private void initState() {
        this.state = this.appExistsInConfig() ? AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED : AdapterState.APPLICATION_NOT_INSTALLED;
    }

    private boolean appExistsInConfig() {
        return this.getConfig() != null;
    }

    private Application getConfig() {
        Application app = this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), ADMIN_APP_NAME);
        return app;
    }

    private void logRequest(GrizzlyRequest req) {
        this.log.info("AdminConsoleAdapter's STATE IS: " + (Object)((Object)this.state));
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Current Thread: " + Thread.currentThread().getName());
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String values = Arrays.toString(req.getParameterValues(name));
                this.log.fine("Parameter name: " + name + " values: " + values);
            }
        }
    }

    private void setContextRoot(Property prop) {
        if (prop == null) {
            this.contextRoot = "/admin";
            return;
        }
        if ("adminConsoleContextRoot".equals(prop.getName())) {
            if (prop.getValue() != null && prop.getValue().startsWith("/")) {
                this.contextRoot = prop.getValue();
                this.log.info("Admin Console Adapter: context root: " + this.contextRoot);
            } else {
                this.log.info("Invalid context root for the admin console application, using default:/admin");
                this.contextRoot = "/admin";
            }
        }
    }

    private void setDownloadLocations(Property prop) {
        if ("adminConsoleDownloadLocation".equals(prop.getName())) {
            String value = prop.getValue();
            if (value != null && !"".equals(value)) {
                String[] strings;
                Pattern sp = Pattern.compile("\\|");
                for (String s : strings = sp.split(value)) {
                    try {
                        this.urls.add(new URL(s));
                        this.logFine(s);
                    }
                    catch (MalformedURLException me) {
                        this.log.info("Ignored invalid URL format: " + s);
                    }
                }
            } else {
                this.log.info("The value for: " + prop.getName() + " is invalid");
            }
        }
    }

    private void setLocationOnDisk(Property prop) {
        if ("adminConsoleFolder".equals(prop.getName()) && prop.getValue() != null) {
            this.diskLocation = new File(prop.getValue());
            this.logFine("Admin Console will be downloaded to: " + this.diskLocation.getAbsolutePath());
            if (!this.diskLocation.canWrite()) {
                this.log.warning(this.diskLocation.getAbsolutePath() + " can't be written to, download will fail");
            }
        }
    }

    private URL getMyUrl(GrizzlyRequest req) {
        try {
            String host = InetAddress.getLocalHost().getHostName();
            URL url = new URL("http://" + host + ":" + req.getServerPort() + this.contextRoot);
            return url;
        }
        catch (MalformedURLException me) {
            throw new RuntimeException(me);
        }
        catch (UnknownHostException ue) {
            throw new RuntimeException(ue);
        }
    }

    private synchronized void handleNotInstalledState(GrizzlyRequest req, GrizzlyResponse res) {
        InteractionResult ir = this.getUserInteractionResult(req);
        if (ir == InteractionResult.OK) {
            this.state = AdapterState.INSTALLING;
            this.startThread();
            this.sendStatusPage(res);
        } else if (ir == InteractionResult.CANCEL) {
            this.state = AdapterState.APPLICATION_NOT_INSTALLED;
        } else {
            this.state = AdapterState.APPLICATION_NOT_INSTALLED;
            this.sendConsentPage(req, res);
        }
    }

    private void startThread() {
        File toFile = new File(this.diskLocation, "admingui.war");
        new InstallerThread(this.urls, toFile, this.proxyHost, this.proxyPort, this.progress, this.domain, this.env, this.contextRoot).start();
    }

    private synchronized InteractionResult getUserInteractionResult(GrizzlyRequest req) {
        String v = this.visitorId + "";
        if (req.getParameter(VISITOR_PARAM) != null && v.equals(req.getParameter(VISITOR_PARAM))) {
            if (req.getParameter(OK_PARAM) != null) {
                this.proxyHost = req.getParameter(PROXY_HOST_PARAM);
                if (this.proxyHost != null) {
                    String ps = req.getParameter(PROXY_PORT_PARAM);
                    try {
                        this.proxyPort = Integer.parseInt(ps);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                return InteractionResult.OK;
            }
            return InteractionResult.CANCEL;
        }
        return InteractionResult.FIRST_TIMER;
    }

    private synchronized void sendConsentPage(GrizzlyRequest req, GrizzlyResponse res) {
        GrizzlyOutputBuffer ob = res.getOutputBuffer();
        res.setStatus(200);
        res.setContentType("text/html");
        try {
            byte[] bytes;
            try {
                String hp = this.contextRoot.startsWith("/") ? "" : "/";
                hp = hp + this.contextRoot + "/";
                this.visitorId = System.currentTimeMillis();
                bytes = this.initHtml.replace(MYURL_TOKEN, hp).replace(VISITOR_TOKEN, this.visitorId + "").getBytes();
            }
            catch (Exception e) {
                bytes = ("Catastrophe:" + e.getMessage()).getBytes();
            }
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatusPage(GrizzlyResponse res) {
        GrizzlyOutputBuffer ob = res.getOutputBuffer();
        res.setStatus(200);
        res.setContentType("text/html");
        try {
            String status = "";
            ProgressObject progressObject = this.progress;
            synchronized (progressObject) {
                status = this.progress.getMessage();
                if (this.progress.isDone()) {
                    this.state = this.progress.getAdapterState() == AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED ? AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED : AdapterState.APPLICATION_NOT_INSTALLED;
                }
            }
            byte[] bytes = this.statusHtml.replace(STATUS_TOKEN, status).getBytes();
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleInstallingState(GrizzlyRequest req, GrizzlyResponse res) {
        this.sendStatusPage(res);
    }

    private synchronized void handleInstalledButNotLoadedState(GrizzlyRequest req, GrizzlyResponse res) {
        Application config = this.getConfig();
        if (config == null) {
            throw new IllegalStateException("handleInstalledButNotLoadedState called with no system app entry");
        }
        String sn = this.env.getInstanceName();
        ApplicationRef ref = this.domain.getApplicationRefInServer(sn, ADMIN_APP_NAME);
        this.habitat.getComponent(ApplicationLoaderService.class).processApplication(config, ref, this.logger);
        this.state = AdapterState.APPLICATION_LOADED;
        try {
            this.sendStatusPage(res);
            res.finishResponse();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void handleLoadedState() {
        this.statusHtml = null;
        this.initHtml = null;
    }

    private void logFine(String s) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InteractionResult {
        OK,
        CANCEL,
        FIRST_TIMER;

    }
}

