/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.ContainerInfo;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ContainerStarter {
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Habitat habitat;
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ContainerInfo> startContainer(Sniffer sniffer, Module snifferModule) {
        ClassLoader containerClassLoader;
        String root;
        assert (sniffer != null);
        String containerName = sniffer.getModuleType();
        assert (containerName != null);
        Object version = null;
        String containerHome = StringUtils.getProperty(containerName + ".home");
        if (containerHome == null && (root = System.getProperty("com.sun.aas.installRoot")) != null) {
            File location = new File(root);
            location = new File(location, "modules");
            location = new File(location, containerName);
            containerHome = location.getAbsolutePath();
            System.setProperty(containerName + ".home", containerHome);
        }
        try {
            Module[] modules = sniffer.setup(containerHome, this.logger);
            containerClassLoader = modules != null ? this.setContainerClassLoader(modules) : snifferModule.getClassLoader();
        }
        catch (FileNotFoundException fnf) {
            this.logger.log(Level.SEVERE, fnf.getMessage());
            return null;
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>();
        for (String name : sniffer.getContainersNames()) {
            try {
                Inhabitant<Container> provider = this.habitat.getInhabitant(Container.class, name);
                if (provider == null) {
                    try {
                        Class<Container> containerClass = containerClassLoader.loadClass(name).asSubclass(Container.class);
                        if (containerClass != null && (provider = this.habitat.getInhabitantByType(containerClass)) == null) {
                            this.logger.severe("Cannot find the container " + name + " in the habitat, is it annotated with @Service");
                            Collection<ContainerInfo> collection = null;
                            return collection;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (provider == null) {
                        this.logger.severe("Cannot find Container named " + name);
                        this.logger.severe("Cannot start " + sniffer.getModuleType() + " container");
                        Collection<ContainerInfo> e = null;
                        return e;
                    }
                }
                Thread.currentThread().setContextClassLoader(containerClassLoader);
                if (provider == null) continue;
                ContainerInfo info = new ContainerInfo(provider, sniffer, containerClassLoader);
                ContainerRegistry registry = this.habitat.getComponent(ContainerRegistry.class);
                registry.addContainer(name, info);
                containers.add(info);
            }
            catch (ComponentException e) {
                this.logger.log(Level.SEVERE, "Cannot create or inject Container", e);
                Collection<ContainerInfo> collection = null;
                return collection;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        return containers;
    }

    ClassLoader setContainerClassLoader(Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException("passed null module list to setContainerClassLoader");
        }
        if (modules.length == 1) {
            return modules[0].getClassLoader();
        }
        ArrayList<ModuleDefinition> defs = new ArrayList<ModuleDefinition>(modules.length);
        for (Module module : modules) {
            defs.add(module.getModuleDefinition());
        }
        return this.modulesRegistry.getModulesClassLoader(modules[0].getClassLoader(), defs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void explodeJar(File source, File destination) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(source);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String fileSystemName = entry.getName().replace('/', File.separatorChar);
                File out = new File(destination, fileSystemName);
                if (entry.isDirectory()) {
                    out.mkdirs();
                    continue;
                }
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    if (!out.getParentFile().exists()) {
                        out.getParentFile().mkdirs();
                    }
                    is = new BufferedInputStream(jarFile.getInputStream(entry));
                    fos = new FileOutputStream(out);
                    ReadableByteChannel inChannel = Channels.newChannel(is);
                    FileChannel outChannel = fos.getChannel();
                    outChannel.transferFrom(inChannel, 0L, entry.getSize());
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (fos == null) continue;
                    fos.close();
                }
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }
}

