/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.v3.server.DynamicReloader;
import java.beans.PropertyChangeEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
@Async
public class DynamicReloadService
implements ConfigListener,
Startup,
PostConstruct,
PreDestroy {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    Applications applications;
    @Inject
    Habitat habitat;
    private static final Logger logger = Logger.getLogger("org.glassfish.deployment");
    private Timer timer;
    private TimerTask timerTask;
    private DynamicReloader reloader;
    private static final String DEFAULT_POLL_INTERVAL_IN_SECONDS = "2";
    private static final String DEFAULT_DYNAMIC_RELOAD_ENABLED = "true";

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        try {
            logger.fine("[Reloader] ReloaderService starting");
            this.reloader = new DynamicReloader(this.applications, logger, this.habitat);
            this.timer = new Timer("DynamicReloader", true);
            this.timerTask = new TimerTask(){

                public void run() {
                    try {
                        DynamicReloadService.this.reloader.run();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            if (this.isEnabled(this.activeDasConfig)) {
                this.start(this.getPollIntervalInSeconds(this.activeDasConfig));
            } else {
                logger.fine("[Reloader] Reloader is configured as disabled, so NOT starting the periodic task");
            }
            logger.fine("[Reloader] Service start-up complete");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void preDestroy() {
        this.stop();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private boolean isEnabled(DasConfig config) {
        return Boolean.parseBoolean(config.getDynamicReloadEnabled());
    }

    private int getPollIntervalInSeconds(DasConfig config) {
        int result;
        try {
            result = Integer.parseInt(config.getDynamicReloadPollIntervalInSeconds());
        }
        catch (NumberFormatException e) {
            result = Integer.parseInt(DEFAULT_POLL_INTERVAL_IN_SECONDS);
        }
        return result;
    }

    private void start(int pollIntervalInSeconds) {
        long pollIntervalInMS = pollIntervalInSeconds * 1000;
        this.timer.schedule(this.timerTask, pollIntervalInMS, pollIntervalInMS);
        logger.fine("[Reloader] Started, monitoring every " + pollIntervalInSeconds + " seconds");
    }

    private void stop() {
        logger.fine("[Reloader] Stopping");
        this.reloader.cancel();
        this.timerTask.cancel();
        this.timer.cancel();
    }

    private void reschedule(int pollIntervalInSeconds) {
        logger.fine("[Reloader] Restarting...");
        this.stop();
        try {
            this.reloader.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.start(pollIntervalInSeconds);
    }

    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        Boolean newEnabled = null;
        Integer newPollIntervalInSeconds = null;
        for (PropertyChangeEvent event : events) {
            if (!(event.getSource() instanceof DasConfig)) continue;
            if (event.getPropertyName().equals("dynamic-reload-enabled")) {
                newEnabled = Boolean.valueOf((String)event.getNewValue());
                continue;
            }
            if (!event.getPropertyName().equals("dynamic-reload-poll-interval-in-seconds")) continue;
            newPollIntervalInSeconds = new Integer((String)event.getNewValue());
        }
        if (newEnabled != null) {
            if (newEnabled.booleanValue()) {
                this.start(newPollIntervalInSeconds == null ? this.getPollIntervalInSeconds(this.activeDasConfig) : newPollIntervalInSeconds.intValue());
            } else {
                this.stop();
            }
        } else if (newPollIntervalInSeconds != null && this.isEnabled(this.activeDasConfig)) {
            this.reschedule(newPollIntervalInSeconds);
        }
        return null;
    }
}

