/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.HttpParserState;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.enterprise.v3.services.impl.V3Mapper;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerMapper {
    private static final String ROOT = "/";
    private Mapper mapper;
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private String defaultHostName = "server";
    private Logger logger;
    private UDecoder urlDecoder = new UDecoder();
    private ConcurrentLinkedQueue<HttpParserState> parserStates;

    public ContainerMapper(GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this.grizzlyEmbeddedHttp = grizzlyEmbeddedHttp;
        this.parserStates = new ConcurrentLinkedQueue();
        this.logger = GrizzlyEmbeddedHttp.logger();
    }

    protected void setDefaultHost(String defaultHost) {
        this.defaultHostName = defaultHost;
    }

    protected void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected synchronized void configureMapper() {
        this.mapper.setDefaultHostName(this.defaultHostName);
        Mapper.setAllowReplacement(true);
    }

    public void register(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container, List<ProtocolFilter> contextProtocolFilters) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER(" + this + ") REGISTER contextRoot: " + contextRoot + " adapter: " + adapter + " container: " + container + " contextProtocolFilters: " + contextProtocolFilters);
        }
        if (adapter.getClass().getName().equals("org.apache.catalina.connector.CoyoteAdapter")) {
            return;
        }
        for (String host : vs) {
            this.mapper.addContext(host, this.slash(contextRoot), new ContextRootInfo(adapter, container, contextProtocolFilters), new String[0], null);
        }
    }

    private String slash(String path) {
        if (!path.startsWith(ROOT)) {
            return ROOT + path;
        }
        return path;
    }

    public void unregister(String contextRoot) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER (" + this + ") UNREGISTER contextRoot: " + contextRoot);
        }
        this.mapper.removeContext(this.defaultHostName, this.slash(contextRoot));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean map(SelectionKey selectionKey, ByteBuffer byteBuffer, GlassfishProtocolChain protocolChain, List<ProtocolFilter> defaultProtocolFilters, ContextRootInfo fallbackContextRootInfo) throws Exception {
        List<ProtocolFilter> fallbackProtocolFilters;
        HttpParserState state = this.parserStates.poll();
        if (state == null) {
            state = new HttpParserState();
        } else {
            state.reset();
        }
        state.setBuffer(byteBuffer);
        byte[] contextBytes = null;
        byte[] hostBytes = null;
        try {
            contextBytes = HttpUtils.readRequestLine(selectionKey, state, InputReader.getDefaultReadTimeout());
            if (contextBytes != null) {
                state.setState(0);
                hostBytes = HttpUtils.readHost(selectionKey, state, 1000);
            }
        }
        finally {
            this.parserStates.offer(state);
        }
        if (contextBytes == null) {
            return false;
        }
        MessageBytes decodedURI = MessageBytes.newInstance();
        decodedURI.setBytes(contextBytes, 0, contextBytes.length);
        MessageBytes hostMB = MessageBytes.newInstance();
        if (hostBytes != null) {
            hostMB.setBytes(hostBytes, 0, hostBytes.length);
        }
        try {
            HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, null, null);
        }
        catch (Exception ex) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Invalid url", ex);
            }
            return false;
        }
        HttpUtils.parseHost(hostMB, ((SocketChannel)selectionKey.channel()).socket());
        MappingData mappingData = new MappingData();
        this.mapper.map(hostMB, decodedURI, mappingData);
        Adapter adapter = null;
        ContextRootInfo contextRootInfo = null;
        if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
            contextRootInfo = (ContextRootInfo)mappingData.context;
            adapter = contextRootInfo.getAdapter();
        } else if (mappingData.context != null && mappingData.context.getClass().getName().equals("com.sun.enterprise.web.WebModule")) {
            MessageBytes fullDecodedUri = MessageBytes.newInstance();
            fullDecodedUri.duplicate(decodedURI);
            fullDecodedUri.toBytes();
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            workerThread.getAttachment().setAttribute("mappingData", mappingData);
            workerThread.getAttachment().setAttribute("decodedURI", fullDecodedUri);
            adapter = ((V3Mapper)this.mapper).getAdapter();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAP (" + this + ") contextRoot: " + new String(contextBytes) + " defaultProtocolFilters: " + defaultProtocolFilters + " fallback: " + fallbackContextRootInfo + " adapter: " + adapter + " mappingData.context " + mappingData.context);
        }
        if (adapter == null && fallbackContextRootInfo != null) {
            adapter = fallbackContextRootInfo.getAdapter();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Fallback adapter is taken: " + adapter);
            }
        }
        if (adapter == null) {
            return false;
        }
        this.bindAdapter(adapter);
        List<ProtocolFilter> filtersToInject = null;
        if (contextRootInfo != null && contextRootInfo.getContainer() != null) {
            List<ProtocolFilter> contextRootProtocolFilters = contextRootInfo.getProtocolFilters();
            List<ProtocolFilter> list = filtersToInject = contextRootProtocolFilters != null ? contextRootProtocolFilters : defaultProtocolFilters;
            if (filtersToInject != null) {
                protocolChain.setDynamicProtocolFilters(filtersToInject);
            }
        } else if (fallbackContextRootInfo != null && (fallbackProtocolFilters = fallbackContextRootInfo.getProtocolFilters()) != null && !fallbackProtocolFilters.isEmpty()) {
            protocolChain.setDynamicProtocolFilters(fallbackProtocolFilters);
        }
        return true;
    }

    private Adapter bindAdapter(Adapter adapter) {
        this.bindProcessorTask(adapter);
        return adapter;
    }

    private void bindProcessorTask(Adapter adapter) {
        HttpWorkerThread workerThread = (HttpWorkerThread)Thread.currentThread();
        DefaultProcessorTask processorTask = (DefaultProcessorTask)workerThread.getProcessorTask();
        if (processorTask == null) {
            try {
                processorTask = (DefaultProcessorTask)this.grizzlyEmbeddedHttp.getProcessorTask();
            }
            catch (ClassCastException ex) {
                this.logger.log(Level.SEVERE, "Invalid ProcessorTask instance", ex);
            }
            workerThread.setProcessorTask(processorTask);
        }
        processorTask.setAdapter(adapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextRootInfo {
        protected Adapter adapter;
        protected ApplicationContainer container;
        protected List<ProtocolFilter> protocolFilters;

        public ContextRootInfo() {
        }

        public ContextRootInfo(Adapter adapter, ApplicationContainer container, List<ProtocolFilter> protocolFilters) {
            this.adapter = adapter;
            this.container = container;
            this.protocolFilters = protocolFilters;
        }

        public Adapter getAdapter() {
            return this.adapter;
        }

        public void setAdapter(Adapter adapter) {
            this.adapter = adapter;
        }

        public ApplicationContainer getContainer() {
            return this.container;
        }

        public void setContainer(ApplicationContainer container) {
            this.container = container;
        }

        public List<ProtocolFilter> getProtocolFilters() {
            return this.protocolFilters;
        }

        public void setProtocolFilters(List<ProtocolFilter> protocolFilters) {
            this.protocolFilters = protocolFilters;
        }
    }
}

