/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.web.BasePersistenceStrategyBuilder;
import com.sun.enterprise.web.PESessionLocker;
import com.sun.enterprise.web.PESessionLockingStandardPipeline;
import com.sun.enterprise.web.ServerConfigLookup;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;

public class MemoryStrategyBuilder
extends BasePersistenceStrategyBuilder {
    public void initializePersistenceStrategy(Context ctx, SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        super.initializePersistenceStrategy(ctx, smBean, serverConfigLookup);
        String persistenceType = "memory";
        String ctxPath = ctx.getPath();
        if (ctxPath != null && !ctxPath.equals("")) {
            Object[] params = new Object[]{ctx.getPath(), persistenceType};
            _logger.log(Level.FINE, "webcontainer.noPersistence", params);
        }
        StandardManager mgr = new StandardManager();
        if (this.sessionFilename == null) {
            mgr.setPathname(this.sessionFilename);
        } else {
            mgr.setPathname(this.prependContextPathTo(this.sessionFilename, ctx));
        }
        StandardContext sctx = (StandardContext)ctx;
        sctx.restrictedSetPipeline(new PESessionLockingStandardPipeline(sctx));
        mgr.setMaxActiveSessions(this.maxSessions);
        mgr.setSessionLocker(new PESessionLocker(ctx));
        ctx.setManager(mgr);
        if (this.sessionIdGeneratorClassname != null) {
            try {
                UuidGenerator generator = (UuidGenerator)Class.forName(this.sessionIdGeneratorClassname).newInstance();
                mgr.setUuidGenerator(generator);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Unable to load session uuid generator " + this.sessionIdGeneratorClassname, ex);
            }
        }
        if (!sctx.isSessionTimeoutOveridden()) {
            mgr.setMaxInactiveInterval(this.sessionMaxInactiveInterval);
        }
    }
}

