/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ReinvokeAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class DefaultProtocolChain
implements ProtocolChain,
ReinvokeAware {
    protected List<ProtocolFilter> protocolFilters = new ArrayList<ProtocolFilter>();
    protected Collection<EventHandler> eventHandlers = new HashSet<EventHandler>();
    protected boolean continousExecution = true;

    public void execute(Context ctx) throws Exception {
        this.execute(ctx, 0);
    }

    public void execute(Context ctx, int firstFilter) throws Exception {
        if (this.protocolFilters.size() != 0) {
            boolean reinvokeChain = true;
            while (reinvokeChain) {
                int currentPosition = this.executeProtocolFilter(ctx, firstFilter);
                reinvokeChain = this.postExecuteProtocolFilter(currentPosition, ctx);
            }
        }
    }

    protected int executeProtocolFilter(Context ctx) {
        return this.executeProtocolFilter(ctx, 0);
    }

    protected int executeProtocolFilter(Context ctx, int firstFilter) {
        int size = this.protocolFilters.size();
        int currentPosition = 0;
        ProtocolFilter protocolFilter = null;
        for (int i = firstFilter; i < size; ++i) {
            boolean invokeNext;
            try {
                protocolFilter = this.protocolFilters.get(i);
                invokeNext = protocolFilter.execute(ctx);
            }
            catch (Exception ex) {
                invokeNext = false;
                Controller.logger().log(Level.SEVERE, "ProtocolChain exception", ex);
                this.notifyException(Phase.EXECUTE, protocolFilter, ex);
            }
            currentPosition = --i;
            if (!invokeNext) break;
        }
        return currentPosition;
    }

    protected boolean postExecuteProtocolFilter(int currentPosition, Context ctx) {
        boolean invokeNext = true;
        ProtocolFilter tmpHandler = null;
        boolean reinvokeChain = false;
        for (int i = currentPosition; i > -1; --i) {
            try {
                tmpHandler = this.protocolFilters.get(i);
                invokeNext = tmpHandler.postExecute(ctx);
            }
            catch (Exception ex) {
                Controller.logger().log(Level.SEVERE, "ProtocolChain exception", ex);
                this.notifyException(Phase.POST_EXECUTE, tmpHandler, ex);
            }
            if (!invokeNext) break;
        }
        if (this.continousExecution && currentPosition == this.protocolFilters.size() - 1 && (Boolean)ctx.removeAttribute("succes_read") == Boolean.TRUE) {
            reinvokeChain = true;
        }
        return reinvokeChain;
    }

    public boolean removeFilter(ProtocolFilter theFilter) {
        return this.protocolFilters.remove(theFilter);
    }

    public boolean addFilter(ProtocolFilter protocolFilter) {
        return this.protocolFilters.add(protocolFilter);
    }

    public void addFilter(int pos, ProtocolFilter protocolFilter) {
        this.protocolFilters.add(pos, protocolFilter);
    }

    public ProtocolFilter setProtocolFilter(int pos, ProtocolFilter protocolFilter) {
        return this.protocolFilters.set(pos, protocolFilter);
    }

    public void setContinuousExecution(boolean continousExecution) {
        this.continousExecution = continousExecution;
        for (ProtocolFilter filter : this.protocolFilters) {
            if (!(filter instanceof ReinvokeAware)) continue;
            ((ReinvokeAware)((Object)filter)).setContinuousExecution(continousExecution);
            break;
        }
    }

    public boolean isContinuousExecution() {
        return this.continousExecution;
    }

    public boolean addEventHandler(EventHandler eventHandler) {
        return this.eventHandlers.add(eventHandler);
    }

    public boolean removeEventHandler(EventHandler eventHandler) {
        return this.eventHandlers.remove(eventHandler);
    }

    protected void notifyException(Phase phase, ProtocolFilter filter, Throwable throwable) {
        for (EventHandler eventHandler : this.eventHandlers) {
            try {
                eventHandler.onException(phase, filter, throwable);
            }
            catch (Exception e) {
                Controller.logger().log(Level.SEVERE, "ProtocolChain notifyException exception", e);
            }
        }
    }

    public static interface EventHandler {
        public void onException(Phase var1, ProtocolFilter var2, Throwable var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        EXECUTE,
        POST_EXECUTE;

    }
}

