/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RubyObjectPool;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.standalone.MimeType;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RailsAdapter
extends GrizzlyAdapter {
    private final RubyObjectPool pool;
    private RubyRuntimeAsyncFilter asyncFilter;
    private final String contextRoot;
    private final Map environment = new HashMap();
    protected File webDir = null;
    private ReentrantLock initializedLock = new ReentrantLock();
    protected ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();
    private final Map<Ruby, WeakHashMap<Thread, RubyThread>> threadMaps = new HashMap<Ruby, WeakHashMap<Thread, RubyThread>>();

    public RailsAdapter(String railsRoot, String jrubyLib, int numRt, boolean asyncExecution, RubyRuntimeAsyncFilter asyncFilter) {
        this("/", railsRoot, jrubyLib, numRt, asyncExecution);
        this.asyncFilter = asyncFilter;
        asyncFilter.setRubyRuntimeQueue(this.pool.getRubyRuntimeQueue());
    }

    public RailsAdapter(String contextRoot, String railsRoot, String jrubyLib, int numRt, boolean asyncExecution) {
        super(railsRoot);
        this.setHandleStaticResources(true);
        this.setRootFolder(railsRoot + "/public");
        this.contextRoot = contextRoot;
        this.pool = new RubyObjectPool(railsRoot, jrubyLib, numRt, asyncExecution);
    }

    RubyObjectPool getPool() {
        return this.pool;
    }

    void startRubyRuntimePool() {
        try {
            SelectorThread.logger().log(Level.INFO, "Starting Rails instances");
            this.pool.start();
        }
        catch (RaiseException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            RubyException re = e.getException();
            String rubyMessage = (String)JavaEmbedUtils.rubyToJava((Ruby)this.pool.borrowRuntime(), (IRubyObject)re.message, String.class);
            String message = "Failed to load Rails: " + rubyMessage + "\n";
            RubyArray backtrace = (RubyArray)re.backtrace();
            for (Object aBacktrace : backtrace) {
                String traceLine = (String)aBacktrace;
                message = message + "\t" + traceLine + "\n";
            }
            this.getLogger().log(Level.SEVERE, message, e);
            throw e;
        }
    }

    void stopRubyRuntimePool() {
        this.pool.stop();
    }

    private void loadRuntimeEnvironment(Ruby runtime) {
        String logger;
        String root;
        if (!(this.contextRoot == null || this.contextRoot.equals("/") || (root = runtime.getGlobalVariables().get("$root").asString().asJavaString()) != null && root.equals(this.contextRoot))) {
            runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.contextRoot));
        }
        if ((logger = runtime.getGlobalVariables().get("$logger").asString().asJavaString()) == null || logger.length() == 0) {
            IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)new Logger(this.getLogger()));
            runtime.defineReadonlyVariable("$logger", loggerObj);
        }
        RubyHash env = (RubyHash)runtime.getObject().getConstant("ENV");
        if (this.environment.size() == 0) {
            this.environment.putAll(env);
        } else {
            env.clear();
            env.putAll(this.environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        res.getResponse().setCommitted(true);
        Ruby runtime = null;
        try {
            runtime = this.pool.borrowRuntime();
            if (runtime == null) {
                throw new IllegalStateException("No Rails Instances available to satisfy the current request");
            }
            this.dispatchRailsRequest(runtime, req, res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (runtime != null) {
                this.pool.returnRuntime(runtime);
                if (this.asyncFilter != null) {
                    this.asyncFilter.resume();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyThread getContextThread(Ruby runtime) {
        RubyThread contextThread = null;
        Map<Ruby, WeakHashMap<Thread, RubyThread>> map = this.threadMaps;
        synchronized (map) {
            WeakHashMap<Thread, Object> threadMap = this.threadMaps.get(runtime);
            if (threadMap != null) {
                contextThread = threadMap.get(Thread.currentThread());
            } else {
                threadMap = new WeakHashMap();
                this.threadMaps.put(runtime, threadMap);
            }
            if (contextThread == null) {
                contextThread = RubyThread.adopt((IRubyObject)runtime.getThread(), (Thread)Thread.currentThread());
                threadMap.put(Thread.currentThread(), contextThread);
            }
        }
        return contextThread;
    }

    private void dispatchRailsRequest(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        RubyThread oldContext = runtime.getThreadService().getMainThread();
        try {
            RubyThread context = this.getContextThread(runtime);
            runtime.getThreadService().setMainThread(context);
            GrizzlyOutputStream os = res.getOutputStream();
            RubyIO iObj = new RubyIO(runtime, (InputStream)req.getInputStream());
            runtime.defineReadonlyVariable("$stdin", (IRubyObject)iObj);
            RubyIO oObj = new RubyIO(runtime, (OutputStream)os);
            runtime.defineReadonlyVariable("$stdout", (IRubyObject)oObj);
            this.loadRuntimeEnvironment(runtime);
            Object[] args = new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)req.getRequest())};
            IRubyObject responder = runtime.getGlobalVariables().get("$responder");
            JavaEmbedUtils.invokeMethod((Ruby)runtime, (Object)responder, (String)"service", (Object[])args, IRubyObject.class);
        }
        catch (RaiseException e) {
            this.getLogger().log(Level.SEVERE, e.getLocalizedMessage(), e);
            RubyException exception = e.getException();
            exception.printBacktrace(System.err);
            throw e;
        }
        finally {
            runtime.getThreadService().setMainThread(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(String uri, Request req, Response res) throws Exception {
        if (this.contextRoot != null && uri.startsWith(this.contextRoot)) {
            uri = uri.substring(this.contextRoot.length());
        }
        FileInputStream fis = null;
        try {
            File resource;
            if (this.webDir == null) {
                this.initializedLock.lock();
                try {
                    this.webDir = new File(this.getRootFolder());
                    try {
                        this.setRootFolder(this.webDir.getCanonicalPath());
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "service()", e);
                    }
                }
                finally {
                    this.initializedLock.unlock();
                }
            }
            if ((resource = this.cache.get(uri)) == null) {
                resource = new File(this.webDir, uri);
                this.cache.put(uri, resource);
            }
            if (resource.isDirectory()) {
                resource = new File(resource, "index.html");
                this.cache.put(uri, resource);
            }
            if (!resource.exists()) {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "File not found  " + resource);
                }
                res.setStatus(404);
                this.customizedErrorPage(req, res);
                return;
            }
            res.setStatus(200);
            int dot = uri.lastIndexOf(".");
            if (dot > 0) {
                String ext = uri.substring(dot + 1);
                String ct = MimeType.get(ext);
                if (ct != null) {
                    res.setContentType(ct);
                }
            } else {
                res.setContentType(MimeType.get("html"));
            }
            res.setContentLength((int)resource.length());
            res.sendHeaders();
            fis = new FileInputStream(resource);
            byte[] b = new byte[8192];
            ByteChunk chunk = new ByteChunk();
            int rd = 0;
            while ((rd = fis.read(b)) > 0) {
                chunk.setBytes(b, 0, rd);
                res.doWrite(chunk);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
        }
        res.setCommitted(true);
    }

    private static class Logger {
        private final java.util.logging.Logger logger;

        public Logger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        public void log(String msg) {
            this.logger.info(msg);
        }
    }
}

