/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.ClassCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyObjectPool {
    public static final long DEFAULT_TIMEOUT = 360L;
    private final String jrubyLib;
    private final int defaultNumberOfRuntime = 5;
    private final BlockingQueue<Ruby> queue = new LinkedBlockingQueue<Ruby>();
    private final boolean asyncEnabled;
    private final int numberOfRuntime;
    private final String railsRoot;

    public RubyObjectPool(String railsRoot, String jrubyLib, int numRunTime, boolean asyncEnabled) {
        this.railsRoot = railsRoot;
        this.jrubyLib = jrubyLib;
        this.asyncEnabled = asyncEnabled;
        this.numberOfRuntime = numRunTime > 0 ? numRunTime : 5;
    }

    public Ruby borrowRuntime() {
        if (this.isAsyncEnabled()) {
            try {
                return this.queue.poll(360L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return (Ruby)this.queue.poll();
    }

    public void returnRuntime(Ruby runtime) {
        this.queue.offer(runtime);
    }

    public void start() {
        try {
            if (this.jrubyLib == null) {
                throw new IllegalStateException("jrubyLib or railsRoot can not be null.");
            }
            int pnum = Runtime.getRuntime().availableProcessors();
            ExecutorService exec = Executors.newFixedThreadPool(pnum + 1);
            for (int i = 0; i < this.numberOfRuntime; ++i) {
                exec.execute(new Runnable(){

                    public void run() {
                        long startTime = System.currentTimeMillis();
                        Ruby runtime = RubyObjectPool.this.initializeRubyRuntime();
                        SelectorThread.logger().log(Level.INFO, "JRuby and Rails instance instantiation took : " + (System.currentTimeMillis() - startTime) + "ms");
                        RubyObjectPool.this.queue.offer(runtime);
                    }
                });
            }
            exec.shutdown();
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        for (Ruby ruby : this.queue) {
            ruby.tearDown();
        }
        this.queue.clear();
    }

    private Ruby setupRails(Ruby runtime, File rdebugScript) {
        LoadService loadService = runtime.getLoadService();
        if (rdebugScript != null) {
            String iosynch = System.getProperty("glassfish.rdebug.iosynch");
            if (iosynch != null && iosynch.length() > 0 && new File(iosynch).exists()) {
                SelectorThread.logger().log(Level.FINEST, "rdebug io synchronized by " + new File(iosynch).getAbsolutePath());
                loadService.require(iosynch);
            }
            try {
                SelectorThread.logger().log(Level.FINEST, "Initializing rdebug...");
                runtime.runFromMain((InputStream)new BufferedInputStream(new FileInputStream(rdebugScript)), rdebugScript.getAbsolutePath());
                SelectorThread.logger().log(Level.FINE, "rdebug started for " + this.railsRoot);
            }
            catch (Exception ex) {
                SelectorThread.logger().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        } else {
            loadService.require(this.railsRoot + "/config/environment");
            loadService.require("cgi/force_nph");
            loadService.require("dispatcher");
        }
        IRubyObject responder = JavaEmbedUtils.newRuntimeAdapter().eval(runtime, this.getDispatcherString());
        runtime.defineReadonlyVariable("$responder", responder);
        return runtime;
    }

    private Ruby initializeRubyRuntime() {
        ArrayList<String> libs = new ArrayList<String>();
        libs.add("META-INF/jruby.home/lib/ruby/site_ruby/1.8");
        ClassCache cache = new ClassCache(RubyObjectPool.class.getClassLoader());
        RubyInstanceConfig config = new RubyInstanceConfig();
        File rdebugScript = this.configureRDebug(config);
        config.setLoader(RubyObjectPool.class.getClassLoader());
        config.setClassCache(cache);
        Ruby runtime = JavaEmbedUtils.initialize(libs, (RubyInstanceConfig)config);
        return this.setupRails(runtime, rdebugScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File configureRDebug(RubyInstanceConfig config) {
        String rdebug = System.getProperty("glassfish.rdebug");
        File rdebugScript = null;
        if (rdebug != null && rdebug.length() > 0) {
            SelectorThread.logger().log(Level.FINER, "Enabling rdebug-ide for Grizzly/Rails.");
            rdebugScript = new File(rdebug);
            if (rdebugScript.exists()) {
                String debugPort;
                ArrayList<String> args = new ArrayList<String>();
                String rdebugVersion = System.getProperty("glassfish.rdebug.version");
                if (rdebugVersion != null && rdebugVersion.length() > 0) {
                    args.add(rdebugVersion);
                }
                if ((debugPort = System.getProperty("glassfish.rdebug.port")) != null && debugPort.length() > 0) {
                    args.add("-p");
                    args.add(debugPort);
                    if ("true".equals(System.getProperty("glassfish.rdebug.verbose"))) {
                        args.add("-d");
                    }
                    args.add("--");
                    File script = null;
                    Writer writer = null;
                    try {
                        script = File.createTempFile("grizzly_jruby_debug_", ".rb");
                        script.deleteOnExit();
                        writer = new FileWriter(script);
                        writer.write("#!/usr/bin/env jruby\n#\n# Launch script for Grizzly/JRuby connector when debugging Rails apps\n# on GlassFish V3.\n#\nrequire \"" + this.railsRoot.replace("\\", "/") + "/config/environment\"\n" + "require \"cgi/force_nph\"\n" + "require \"dispatcher\"\n");
                        writer.flush();
                        args.add(script.getAbsolutePath());
                        config.setArgv(args.toArray(new String[args.size()]));
                    }
                    catch (IOException ex) {
                        SelectorThread.logger().log(Level.SEVERE, "Error writing Rails launch script for rdebug.", ex);
                        rdebugScript = null;
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException ex) {
                                SelectorThread.logger().log(Level.SEVERE, "Exception closing " + script.getAbsolutePath(), ex);
                            }
                        }
                    }
                } else {
                    SelectorThread.logger().log(Level.SEVERE, "glassfish.rdebug.port undefined.  Disabling rdebug.");
                    rdebugScript = null;
                }
            } else {
                SelectorThread.logger().log(Level.SEVERE, "rdebug-ide script " + rdebugScript.getAbsolutePath() + " does not exist.  Disabling rdebug");
                rdebugScript = null;
            }
        }
        return rdebugScript;
    }

    public String getJrubyLib() {
        return this.jrubyLib;
    }

    public int getNumberOfRuntime() {
        return this.numberOfRuntime;
    }

    protected BlockingQueue<Ruby> getRubyRuntimeQueue() {
        return this.queue;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    private String getDispatcherString() {
        StringBuffer completeText = new StringBuffer();
        try {
            InputStream is = this.getClass().getResourceAsStream("/dispatch.rb");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String str = br.readLine();
            while (str != null) {
                completeText.append(str);
                completeText.append("\n");
                str = br.readLine();
            }
        }
        catch (Exception e) {
            SelectorThread.logger().log(Level.WARNING, "Exception when trying to read the dispatch.rb script", e);
        }
        return completeText.toString();
    }
}

