/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.util.concurrent.Callable;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerThreadImpl
extends WorkerThread {
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    protected Runnable target;
    protected Pipeline<Callable> pipeline;
    protected volatile boolean execute = true;
    protected static final ThreadGroup threadGroup = new ThreadGroup("Grizzly");
    private ThreadAttachment threadAttachment;
    private ByteBufferFactory.ByteBufferType byteBufferType = ByteBufferFactory.ByteBufferType.HEAP_VIEW;
    private int initialByteBufferSize;

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, 8192);
    }

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable, int initialByteBufferSize) {
        super(threadGroup, runnable);
        this.setDaemon(true);
        this.target = runnable;
        this.initialByteBufferSize = initialByteBufferSize;
    }

    public WorkerThreadImpl(Pipeline<Callable> pipeline, String name) {
        this(pipeline, name, 8192);
    }

    public WorkerThreadImpl(Pipeline<Callable> pipeline, String name, int initialByteBufferSize) {
        super(threadGroup, name);
        this.pipeline = pipeline;
        this.setDaemon(true);
        this.initialByteBufferSize = initialByteBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBufferFactory.allocate(this.byteBufferType, this.initialByteBufferSize);
        }
        if (this.target != null) {
            this.target.run();
            return;
        }
        while (this.execute) {
            try {
                Callable t = this.pipeline.waitForIoTask();
                if (t == null) continue;
                t.call();
                t = null;
            }
            catch (Throwable t) {
                if (this.execute) {
                    Controller.logger().log(Level.SEVERE, "WorkerThreadImpl unexpected exception: ", t);
                    continue;
                }
                Controller.logger().log(Level.FINE, "WorkerThreadImpl unexpected exception, when WorderThread supposed to be closed: ", t);
            }
            finally {
                this.reset();
            }
        }
    }

    @Override
    public void terminate() {
        this.execute = false;
    }

    @Override
    public ThreadAttachment updateAttachment(int mode) {
        ThreadAttachment currentAttachment = this.getAttachment();
        currentAttachment.reset();
        if ((mode & ThreadAttachment.Mode.BYTE_BUFFER) != 0) {
            currentAttachment.setByteBuffer(this.byteBuffer);
        }
        if ((mode & ThreadAttachment.Mode.SSL_ENGINE) != 0) {
            currentAttachment.setSSLEngine(this.sslEngine);
        }
        if ((mode & ThreadAttachment.Mode.INPUT_BB) != 0) {
            currentAttachment.setInputBB(this.inputBB);
        }
        if ((mode & ThreadAttachment.Mode.OUTPUT_BB) != 0) {
            currentAttachment.setOutputBB(this.outputBB);
        }
        currentAttachment.setMode(mode);
        return currentAttachment;
    }

    @Override
    public ThreadAttachment getAttachment() {
        if (this.threadAttachment == null) {
            this.threadAttachment = new ThreadAttachment();
        }
        return this.threadAttachment;
    }

    @Override
    public ThreadAttachment detach() {
        ThreadAttachment currentAttachment = this.getAttachment();
        int mode = currentAttachment.getMode();
        this.updateAttachment(mode);
        if ((mode & ThreadAttachment.Mode.BYTE_BUFFER) != 0) {
            this.byteBuffer = ByteBufferFactory.allocate(this.byteBufferType, this.initialByteBufferSize);
        }
        if ((mode & ThreadAttachment.Mode.SSL_ENGINE) != 0) {
            this.sslEngine = null;
        }
        if ((mode & ThreadAttachment.Mode.INPUT_BB) != 0) {
            this.inputBB = null;
        }
        if ((mode & ThreadAttachment.Mode.OUTPUT_BB) != 0) {
            this.outputBB = null;
        }
        this.threadAttachment = null;
        currentAttachment.deassociate();
        return currentAttachment;
    }

    @Override
    public void attach(ThreadAttachment threadAttachment) {
        threadAttachment.associate();
        int mode = threadAttachment.getMode();
        if ((mode & ThreadAttachment.Mode.BYTE_BUFFER) != 0) {
            this.byteBuffer = threadAttachment.getByteBuffer();
        }
        if ((mode & ThreadAttachment.Mode.SSL_ENGINE) != 0) {
            this.sslEngine = threadAttachment.getSSLEngine();
        }
        if ((mode & ThreadAttachment.Mode.INPUT_BB) != 0) {
            this.inputBB = threadAttachment.getInputBB();
        }
        if ((mode & ThreadAttachment.Mode.OUTPUT_BB) != 0) {
            this.outputBB = threadAttachment.getOutputBB();
        }
        this.threadAttachment = threadAttachment;
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    @Override
    protected void reset() {
        if (this.threadAttachment != null) {
            this.threadAttachment.deassociate();
        }
        this.threadAttachment = null;
        super.reset();
    }
}

