/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateComponentHelper {
    private String _ldmKey = null;
    private transient LayoutDefinition _layoutDefinition = null;

    public UIComponent getChild(UIComponent comp, FacesContext context, String id) {
        if (id == null || id.trim().equals("")) {
            return null;
        }
        UIComponent childComponent = ComponentUtil.findChild(comp, id, id);
        if (childComponent != null) {
            return childComponent;
        }
        LayoutDefinition ld = this.getLayoutDefinition(context);
        if (ld == null) {
            return null;
        }
        LayoutElement elt = LayoutDefinition.getChildLayoutElementById(context, id, ld, comp);
        return this.getChild(comp, context, (LayoutComponent)elt);
    }

    public UIComponent getChild(UIComponent comp, FacesContext context, LayoutComponent descriptor) {
        UIComponent childComponent = null;
        if (descriptor == null) {
            throw new IllegalArgumentException("The LayoutComponent is null!");
        }
        String id = descriptor.getId(context, comp);
        if (id != null && !id.trim().equals("") && (childComponent = ComponentUtil.findChild(comp, id, id)) != null) {
            return childComponent;
        }
        descriptor.beforeCreate(context, comp);
        childComponent = ComponentUtil.createChildComponent(context, descriptor, comp);
        descriptor.afterCreate(context, childComponent);
        return childComponent;
    }

    public LayoutDefinition getLayoutDefinition(FacesContext context) {
        if (this._layoutDefinition != null) {
            return this._layoutDefinition;
        }
        String key = this.getLayoutDefinitionKey();
        if (key == null) {
            throw new NullPointerException("LayoutDefinition key is null!");
        }
        try {
            this._layoutDefinition = LayoutDefinitionManager.getLayoutDefinition(context, key);
        }
        catch (LayoutDefinitionException ex) {
            throw new IllegalArgumentException("A LayoutDefinition was not provided for '" + key + "'!  This is required.", ex);
        }
        return this._layoutDefinition;
    }

    public Object saveState(FacesContext context, Object superState) {
        Object[] values = new Object[]{superState, this._ldmKey};
        return values;
    }

    public Object restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._ldmKey = (String)values[1];
        return values[0];
    }

    public String getLayoutDefinitionKey() {
        return this._ldmKey;
    }

    public void setLayoutDefinitionKey(String key) {
        this._ldmKey = key;
    }

    public <V> V getAttributeValue(UIComponent comp, V field, String attributeName, V defaultValue) {
        if (field != null) {
            return field;
        }
        ValueExpression ve = comp.getValueExpression(attributeName);
        return (V)(ve != null ? ve.getValue(FacesContext.getCurrentInstance().getELContext()) : defaultValue);
    }
}

