/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.dataprovider;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TransactionalDataListener;
import com.sun.data.provider.impl.IndexRowKey;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.jsftemplating.component.dataprovider.IndexFieldKey;
import com.sun.jsftemplating.component.dataprovider.MultipleObjectFieldKeySupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleListDataProvider
extends ObjectListDataProvider {
    private static final long serialVersionUID = 1L;
    private transient MultipleObjectFieldKeySupport support = null;
    private List<List<Object>> _lists = new ArrayList<List<Object>>();
    private Class[] _types = null;
    protected Set<RowKey> _deletes = new TreeSet<RowKey>();

    public MultipleListDataProvider() {
        this.setIncludeFields(false);
    }

    public MultipleListDataProvider(List<List<Object>> list) {
        this(list, false);
    }

    public MultipleListDataProvider(List<List<Object>> lists, boolean includeFields) {
        this.setLists(lists);
        this.setIncludeFields(false);
    }

    public MultipleListDataProvider(Class[] objectTypes) {
        this(objectTypes, false);
    }

    public MultipleListDataProvider(Class[] objTypes, boolean includeFields) {
        this.setObjectTypes(objTypes);
        this.setIncludeFields(includeFields);
    }

    @Override
    public Object getObject(RowKey row) {
        if (!this.isRowAvailable(row)) {
            throw new IndexOutOfBoundsException("" + row);
        }
        int rowIdx = this.getRowIndex(row);
        List<List<Object>> lists = this.getLists();
        Object[] result = new Object[lists.size()];
        int idx = 0;
        for (List<Object> list : lists) {
            result[idx++] = list.get(rowIdx);
        }
        return result;
    }

    @Override
    public Object[] getObjects() {
        List<List<Object>> lists = this.getLists();
        int numLists = lists.size();
        if (numLists == 0) {
            return new Object[0][0];
        }
        int numRows = lists.get(0).size();
        Object[][] result = new Object[numRows][numLists];
        int listNum = 0;
        for (int rowNum = 0; rowNum < numRows; ++rowNum) {
            listNum = 0;
            for (List<Object> list : lists) {
                result[rowNum][listNum++] = list.get(rowNum);
            }
        }
        return result;
    }

    @Override
    public void setObjectType(Class objectType) {
        this.setObjectTypes(new Class[]{objectType});
    }

    public void setObjectTypes(Class[] objectTypes) {
        this._types = objectTypes;
    }

    @Override
    public void removeObject(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRemoved(RowKey row) {
        return this._deletes.contains(row);
    }

    @Override
    public void setObject(RowKey row, Object object) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support the setObject(RowKey, Object) method. " + "Instead use setObjects(RowKey, Object []).");
    }

    public void setObjects(RowKey row, Object[] objects) {
        Object[] previous = (Object[])this.getObject(row);
        int rowNum = this.getRowIndex(row);
        int cnt = 0;
        for (List<Object> list : this.getLists()) {
            list.set(rowNum, objects[cnt++]);
        }
        this.fireValueChanged(null, row, previous, objects);
        if (this.getCursorRow() == row) {
            this.fireValueChanged(null, previous, objects);
        }
    }

    @Override
    public void addObject(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        return this.getSupport().getFieldKey(fieldId);
    }

    @Override
    public FieldKey[] getFieldKeys() throws DataProviderException {
        return this.getSupport().getFieldKeys();
    }

    @Override
    public Class getType(FieldKey fieldKey) throws DataProviderException {
        return this.getSupport().getType(fieldKey);
    }

    @Override
    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        return this.getSupport().isReadOnly(fieldKey);
    }

    @Override
    public Object getValue(FieldKey fieldKey, RowKey rowKey) throws DataProviderException {
        Object val;
        block4: {
            val = null;
            try {
                val = super.getValue(fieldKey, rowKey);
            }
            catch (Exception ex) {
                if (this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
                    throw new IllegalArgumentException("" + fieldKey);
                }
                if (!this.isRowAvailable(rowKey)) {
                    throw new IndexOutOfBoundsException("" + rowKey);
                }
                int index = this.getRowIndex(rowKey);
                if (index >= this.getRowCount()) break block4;
                val = this.getSupport().getValue(fieldKey, this.getListForFieldKey(fieldKey).get(index));
            }
        }
        return val;
    }

    @Override
    public void setValue(FieldKey fieldKey, RowKey rowKey, Object value) throws DataProviderException {
        if (this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException("" + fieldKey);
        }
        if (this.getSupport().isReadOnly(fieldKey)) {
            throw new IllegalStateException("" + fieldKey);
        }
        if (!this.isRowAvailable(rowKey)) {
            throw new IndexOutOfBoundsException("" + rowKey);
        }
        Object previous = this.getValue(fieldKey, rowKey);
        if (previous == null && value == null || previous != null && value != null && previous.equals(value)) {
            return;
        }
        if (!this.getSupport().isAssignable(fieldKey, value)) {
            throw new IllegalArgumentException(fieldKey + " = " + value);
        }
        int index = this.getRowIndex(rowKey);
        this.getSupport().setValue(fieldKey, this.getListForFieldKey(fieldKey).get(index), value);
        this.fireValueChanged(fieldKey, rowKey, previous, value);
        this.fireValueChanged(fieldKey, previous, value);
    }

    @Override
    public RowKey appendRow() throws DataProviderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canAppendRow() throws DataProviderException {
        return this.isUserResizable() && this.getObjectTypes() != null;
    }

    @Override
    public RowKey appendRow(Object object) throws DataProviderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRow(RowKey rowKey) throws DataProviderException {
        if (!this.canRemoveRow(rowKey)) {
            throw new IllegalStateException("This ObjectListDataProvider is not resizable.");
        }
        if (!this.isRowAvailable(rowKey)) {
            throw new IllegalArgumentException("Cannot delete row for row key " + rowKey);
        }
        this._deletes.add(rowKey);
        this.fireRowRemoved(rowKey);
        if (this.getCursorRow() == rowKey) {
            this.fireValueChanged(null, this.getObject(rowKey), null);
        }
    }

    @Override
    public int getRowCount() throws DataProviderException {
        List<List<Object>> lists = this.getLists();
        int count = 0;
        if (lists != null && lists.size() != 0) {
            count = lists.get(0).size();
        }
        return count;
    }

    @Override
    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        int idx = this.getRowIndex(row);
        if (idx < 0) {
            return false;
        }
        return idx < this.getRowCount();
    }

    @Override
    public void commitChanges() throws DataProviderException {
        RowKey[] deletes = this._deletes.toArray(new RowKey[this._deletes.size()]);
        int rowIdx = -1;
        for (int idx = deletes.length - 1; idx >= 0; --idx) {
            rowIdx = this.getRowIndex(deletes[idx]);
            for (List<Object> list : this.getLists()) {
                list.remove(rowIdx);
            }
        }
        this._deletes.clear();
        this.fireChangesCommitted();
    }

    protected void fireChangesCommitted() {
        TransactionalDataListener[] listeners = this.getTransactionalDataListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].changesCommitted(this);
        }
    }

    private void fireChangesReverted() {
        TransactionalDataListener[] listeners = this.getTransactionalDataListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].changesReverted(this);
        }
    }

    @Override
    public void revertChanges() throws DataProviderException {
        this._deletes.clear();
        this.fireChangesReverted();
    }

    public List<List<Object>> getLists() {
        return this._lists;
    }

    public void setLists(List<List<Object>> lists) {
        this._lists = lists;
    }

    public List getListForFieldKey(FieldKey key) {
        if (key != null && !(key instanceof IndexFieldKey)) {
            key = this.support.getFieldKey(key.getFieldId());
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid FieldKey: " + key);
        }
        return this.getLists().get(((IndexFieldKey)key).getIndex());
    }

    private MultipleObjectFieldKeySupport getSupport() {
        Object[] objs;
        if (this.support == null && (objs = (Object[])this.getObject(this.getRowKey(0))) != null && objs.length > 0) {
            this.support = new MultipleObjectFieldKeySupport(objs, this.isIncludeFields());
        }
        return this.support;
    }

    protected int getRowIndex(RowKey rowKey) {
        if (rowKey instanceof IndexRowKey) {
            return ((IndexRowKey)rowKey).getIndex();
        }
        return -1;
    }

    protected RowKey getRowKey(int index) {
        return new IndexRowKey(index);
    }

    @Override
    public Class getObjectType() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support the getObjectType() method because it " + "must return multiple types.  Please use \"Class [] " + "getObjectTypes()\" instead.");
    }

    public Class[] getObjectTypes() {
        return this._types;
    }
}

