/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LayoutElementUtil {
    private static int _highId = 0;
    private static Map<String, Integer> startMap = new ConcurrentHashMap<String, Integer>();
    public static final String DEFAULT_ID_BASE = "id";

    public static boolean isNestedLayoutComponent(LayoutElement elt) {
        return LayoutElementUtil.getParentLayoutComponent(elt) != null;
    }

    public static LayoutComponent getParentLayoutComponent(LayoutElement elt) {
        for (elt = elt.getParent(); elt != null; elt = elt.getParent()) {
            if (!(elt instanceof LayoutComponent)) continue;
            return (LayoutComponent)elt;
        }
        return null;
    }

    public static boolean isLayoutComponentChild(LayoutElement elt) {
        for (elt = elt.getParent(); elt != null; elt = elt.getParent()) {
            if (elt instanceof LayoutComponent) {
                if (elt.getClass().getName().equals(LayoutComponent.CLASS_NAME)) {
                    return true;
                }
                return LayoutElementUtil.isNestedLayoutComponent(elt);
            }
            if (!(elt instanceof LayoutFacet)) continue;
            return false;
        }
        return false;
    }

    public static String getGeneratedId(String base) {
        return LayoutElementUtil.getGeneratedId(base, LayoutElementUtil.incHighestId(_highId));
    }

    public static String getGeneratedId(String base, int num) {
        if (base == null) {
            base = DEFAULT_ID_BASE;
        } else if ((base = base.trim()).equals("")) {
            base = DEFAULT_ID_BASE;
        } else {
            StringBuffer buf = new StringBuffer();
            for (char ch : base.toCharArray()) {
                int lowch = ch | 0x20;
                if (lowch >= 97 && lowch <= 122) {
                    buf.append(ch);
                    continue;
                }
                buf.append('_');
            }
            base = buf.toString();
        }
        return base + num;
    }

    public static synchronized int getStartingIdNumber(String key) {
        Integer start = startMap.get(key);
        if (start == null) {
            start = LayoutElementUtil.incHighestId(_highId);
            startMap.put(key, start);
        }
        return start;
    }

    public static synchronized int incHighestId(int num) {
        if (num >= _highId) {
            _highId = num + 1;
        }
        return _highId;
    }

    public static void checkForFacetChild(LayoutElement parent, LayoutComponent component) {
        if (!LayoutElementUtil.isLayoutComponentChild(component)) {
            String id = component.getUnevaluatedId();
            while (parent != null) {
                if (parent instanceof LayoutFacet) {
                    if (!LayoutElementUtil.isLayoutComponentChild(parent)) break;
                    id = parent.getUnevaluatedId();
                    break;
                }
                parent = parent.getParent();
            }
            component.addOption("_facetName", id);
        }
    }

    public static void dumpTree(LayoutElement elt, StringBuffer buf, String indent) {
        String compInfo = "";
        if (elt instanceof LayoutComponent) {
            LayoutComponent comp = (LayoutComponent)elt;
            compInfo = " nested=" + comp.isNested();
        } else if (elt instanceof LayoutFacet) {
            compInfo = " isRendered=" + ((LayoutFacet)elt).isRendered();
        }
        buf.append(indent + elt.getUnevaluatedId() + " (" + elt.getClass().getName() + ")" + compInfo + "\n");
        Iterator<LayoutElement> it = elt.getChildLayoutElements().iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                LayoutElementUtil.dumpTree(it.next(), buf, indent + "    ");
            }
        }
    }
}

