/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.fileStreamer.BaseContext;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FacesStreamerContext
extends BaseContext {
    public static final String FACES_CONTEXT = "facesContext";
    public static final String DEFAULT_DISPOSITION = "attachment";
    private static boolean initDone = false;

    public FacesStreamerContext(FacesContext ctx) {
        this.setFacesContext(ctx);
        this.init(ctx);
    }

    protected synchronized void init(FacesContext ctx) {
        if (initDone) {
            return;
        }
        String sources = ctx.getExternalContext().getInitParameter("ContentSources");
        if (sources != null && sources.trim().length() != 0) {
            FileStreamer fs = FileStreamer.getFileStreamer();
            StringTokenizer tokens = new StringTokenizer(sources, " \t\n\r\f,;:");
            while (tokens.hasMoreTokens()) {
                fs.registerContentSource(tokens.nextToken());
            }
        }
        initDone = true;
    }

    public ContentSource getContentSource() {
        ContentSource src = (ContentSource)this.getAttribute("_contentSource");
        if (src != null) {
            return src;
        }
        String id = this.getFacesContext().getExternalContext().getRequestParameterMap().get("contentSourceId");
        if (id == null) {
            id = "resourceCS";
        }
        if ((src = FileStreamer.getFileStreamer().getContentSource(id)) == null) {
            throw new RuntimeException("The ContentSource with id '" + id + "' is not registered!");
        }
        this.setAttribute("_contentSource", src);
        return src;
    }

    public void writeHeader(ContentSource source) {
        String contentType;
        ServletResponse resp = (ServletResponse)this.getFacesContext().getExternalContext().getResponse();
        long longTime = source.getLastModified(this);
        if (longTime != -1L) {
            ((HttpServletResponse)resp).setDateHeader("Last-Modified", longTime);
        }
        if ((contentType = (String)this.getAttribute("ContentType")) == null) {
            String ext = (String)this.getAttribute("extension");
            if (ext != null) {
                contentType = FileStreamer.getMimeType(ext);
            }
            if (contentType == null) {
                contentType = FileStreamer.getDefaultMimeType();
            }
        }
        ((HttpServletResponse)resp).setHeader("Content-type", contentType);
        String disposition = (String)this.getAttribute("disposition");
        String filename = (String)this.getAttribute("filename");
        if (disposition == null) {
            if (filename != null) {
                ((HttpServletResponse)resp).setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
            }
        } else {
            if (filename != null) {
                disposition = disposition + ";filename=\"" + filename + "\"";
            }
            ((HttpServletResponse)resp).setHeader("Content-Disposition", disposition);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        ServletResponse resp = (ServletResponse)this.getFacesContext().getExternalContext().getResponse();
        return resp.getOutputStream();
    }

    public FacesContext getFacesContext() {
        return (FacesContext)this.getAttribute(FACES_CONTEXT);
    }

    protected void setFacesContext(FacesContext ctx) {
        this.setAttribute(FACES_CONTEXT, ctx);
    }
}

