/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.EventSource;
import com.sun.webui.jsf.event.EventListener;
import com.sun.webui.jsf.event.MethodExprEventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public abstract class EventSourceImpl
extends UIComponentBase
implements EventSource {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.event", "javax.faces.LogStrings");
    private boolean immediate = false;
    private boolean immediate_set = false;
    private MethodExpression eventExpression = null;
    private MethodExpression eventListenerExpression;
    private PhaseId phaseId = null;

    public boolean isImmediate() {
        if (this.immediate_set) {
            return this.immediate;
        }
        ValueExpression ve = this.getValueExpression("immediate");
        if (ve != null) {
            try {
                return Boolean.TRUE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        if (immediate != this.immediate) {
            this.immediate = immediate;
        }
        this.immediate_set = true;
    }

    public MethodExpression getEventExpression() {
        return this.eventExpression;
    }

    public void setEventExpression(MethodExpression eventExpression) {
        this.eventExpression = eventExpression;
    }

    public void addEventListener(EventListener listener) {
        this.addFacesListener(listener);
    }

    public EventListener[] getEventListeners() {
        EventListener[] listeners = (EventListener[])this.getFacesListeners(EventListener.class);
        return listeners;
    }

    public MethodExpression getEventListenerExpression() {
        return this.eventListenerExpression;
    }

    public void setEventListenerExpression(MethodExpression me) {
        EventListener[] curEventListeners = this.getEventListeners();
        if (null != curEventListeners && this.eventListenerExpression != null) {
            for (int i = 0; i < curEventListeners.length; ++i) {
                MethodExprEventListener curEventListener;
                MethodExpression curMethodExpression;
                if (!(curEventListeners[i] instanceof MethodExprEventListener) || !this.eventListenerExpression.equals(curMethodExpression = (curEventListener = (MethodExprEventListener)curEventListeners[i]).getMethodExpression())) continue;
                this.removeEventListener(curEventListener);
                break;
            }
        }
        if (me == null) {
            this.eventListenerExpression = null;
        } else {
            this.eventListenerExpression = me;
            this.addEventListener(new MethodExprEventListener(this.eventListenerExpression));
        }
    }

    public void removeEventListener(EventListener listener) {
        this.removeFacesListener(listener);
    }

    public void processEventExpression() {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        String outcome = null;
        MethodExpression me = this.getEventExpression();
        ELContext elContext = context.getELContext();
        if (me == null) {
            return;
        }
        try {
            Object invokeResult = me.invoke(elContext, null);
            if (null != invokeResult) {
                outcome = invokeResult.toString();
            }
        }
        catch (EvaluationException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new FacesException(me.getExpressionString() + ": " + e.getMessage(), e);
        }
        NavigationHandler navHandler = application.getNavigationHandler();
        navHandler.handleNavigation(context, me.getExpressionString(), outcome);
        context.renderResponse();
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        this.processEventExpression();
    }

    public void setPhaseId(PhaseId phaseId) {
        this.phaseId = phaseId;
    }

    public PhaseId getPhaseId() {
        if (this.phaseId != null) {
            return this.phaseId;
        }
        ValueExpression ve = this.getValueExpression("phaseId");
        if (ve != null) {
            try {
                return (PhaseId)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return this.isImmediate() ? PhaseId.ANY_PHASE : PhaseId.INVOKE_APPLICATION;
    }

    public void queueEvent(FacesEvent e) {
        if (this.isImmediate()) {
            e.setPhaseId(PhaseId.ANY_PHASE);
        } else {
            e.setPhaseId(this.getPhaseId());
        }
        super.queueEvent(e);
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.immediate = (Boolean)_values[1];
        this.immediate_set = (Boolean)_values[2];
        this.eventExpression = (MethodExpression)EventSourceImpl.restoreAttachedState(_context, _values[3]);
        this.eventListenerExpression = (MethodExpression)EventSourceImpl.restoreAttachedState(_context, _values[4]);
        this.phaseId = (PhaseId)_values[5];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.immediate ? Boolean.TRUE : Boolean.FALSE, this.immediate_set ? Boolean.TRUE : Boolean.FALSE, EventSourceImpl.saveAttachedState(_context, this.eventExpression), EventSourceImpl.saveAttachedState(_context, this.eventListenerExpression), this.phaseId};
        return _values;
    }
}

