/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.login.JaasLoginController;
import com.sun.webui.jsf.model.login.LoginCallback;
import com.sun.webui.jsf.model.login.LoginConstants;
import com.sun.webui.jsf.model.login.LoginController;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class Login
extends WebuiInput
implements NamingContainer {
    private static final String CONTROLLER_MAP_KEY = "com_sun_webui_jsf_login_controller";
    private String htmlTemplate = null;
    private LoginConstants.LOGINSTATE loginState = null;
    private Map authenticationKeys = null;
    private boolean autoStart = true;
    private boolean autoStart_set = false;
    private String loginClass = null;
    private String redirectURL = null;
    private String serviceName = null;
    private String loginController = null;
    private String style = null;
    private String styleClass = null;
    private boolean immediate = false;
    private boolean immediate_set = false;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndex_set = false;
    private LoginCallback callbackObject = null;

    public Login() {
        this.setRendererType("com.sun.webui.jsf.widget.Login");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Login";
    }

    public String getRendererType() {
        if (ComponentUtilities.isAjaxRequest(this.getFacesContext(), this)) {
            return "com.sun.webui.jsf.ajax.Login";
        }
        return super.getRendererType();
    }

    public String getHtmlTemplate() {
        if (this.htmlTemplate != null) {
            return this.htmlTemplate;
        }
        ValueExpression _vb = this.getValueExpression("htmlTemplate");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHtmlTemplate(String htmlTemplate) {
        this.htmlTemplate = htmlTemplate;
    }

    public LoginConstants.LOGINSTATE getLoginState() {
        return this.loginState;
    }

    public void setLoginState(LoginConstants.LOGINSTATE loginState) {
        this.loginState = loginState;
    }

    public void setAuthenticationKeys(Map keys) {
        this.authenticationKeys = keys;
    }

    public Map getAuthenticationKeys() {
        return this.authenticationKeys;
    }

    public boolean isAutoStart() {
        if (this.autoStart_set) {
            return this.autoStart;
        }
        ValueExpression ve = this.getValueExpression("autoStart");
        if (ve != null) {
            Object result = ve.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        this.autoStart_set = true;
    }

    public String getLoginClass() {
        if (this.loginClass != null) {
            return this.loginClass;
        }
        return null;
    }

    public void setLoginClass(String loginClass) {
        this.loginClass = loginClass;
    }

    public String getRedirectURL() {
        if (this.redirectURL != null) {
            return this.redirectURL;
        }
        ValueExpression ve = this.getValueExpression("redirectURL");
        if (ve != null) {
            return (String)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        ValueExpression ve = this.getValueExpression("serviceName");
        if (ve != null) {
            return (String)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getLoginController() {
        if (this.loginController != null) {
            return this.loginController;
        }
        ValueExpression ve = this.getValueExpression("loginController");
        if (ve != null) {
            return (String)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLoginController(String loginController) {
        this.loginController = loginController;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression ve = this.getValueExpression("style");
        if (ve != null) {
            return (String)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression ve = this.getValueExpression("styleClass");
        if (ve != null) {
            return (String)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public boolean isImmediate() {
        if (this.immediate_set) {
            return this.immediate;
        }
        ValueExpression _vb = this.getValueExpression("immediate");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
        this.immediate_set = true;
    }

    public int getTabIndex() {
        if (this.tabIndex_set) {
            return this.tabIndex;
        }
        ValueExpression _vb = this.getValueExpression("tabIndex");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        this.tabIndex_set = true;
    }

    public LoginCallback getCallbackObject() {
        return this.callbackObject;
    }

    public void setCallbackObject(LoginCallback callbackObject) {
        this.callbackObject = callbackObject;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.decode(context);
        if (this.isImmediate()) {
            this.processValidators(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Theme theme = this.getTheme(context);
        try {
            this.validate(context);
        }
        catch (RuntimeException rte) {
            FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, theme.getMessage("login.errorSummary"), rte.getLocalizedMessage());
            context.addMessage(this.getClientId(context), fm);
            context.renderResponse();
        }
        if (!this.isValid()) {
            FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, theme.getMessage("login.errorSummary"), theme.getMessage("login.validationErr"));
            context.addMessage(this.getClientId(context), fm);
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Theme theme = this.getTheme(context);
        ExternalContext ec = context.getExternalContext();
        Object requestObj = ec.getRequest();
        LoginConstants.LOGINSTATE state = this.getLoginState();
        LoginController controllerClass = null;
        if (state.equals((Object)LoginConstants.LOGINSTATE.INIT)) {
            Object loginClass = null;
            String jaasServiceName = this.getServiceName();
            if (jaasServiceName == null) {
                FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, theme.getMessage("login.errorSummary"), theme.getMessage("login.svcNameError"));
                context.addMessage(this.getClientId(context), fm);
                this.setValid(false);
            } else {
                FacesMessage fm;
                String controllerClassName = this.getLoginController();
                if (controllerClassName != null && controllerClassName.length() > 0) {
                    try {
                        controllerClass = (LoginController)Class.forName(controllerClassName).newInstance();
                    }
                    catch (Exception ex) {
                        LogUtil.severe("Could not instantiate controller class", ex);
                        fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, theme.getMessage("login.errorSummary"), theme.getMessage("login.controllerError"));
                        context.addMessage(this.getClientId(context), fm);
                        this.setValid(false);
                    }
                } else {
                    controllerClass = new JaasLoginController();
                }
                try {
                    controllerClass.initialize(requestObj, jaasServiceName);
                    LoginCallback lcb = controllerClass.getCallbackObject();
                    if (lcb != null) {
                        this.setCallbackObject(lcb);
                        this.setLoginState(lcb.getLoginState());
                    }
                }
                catch (Exception e) {
                    LogUtil.severe("Validation exception", e);
                    controllerClass.abort(requestObj);
                    this.setValid(false);
                    fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, theme.getMessage("login.errorSummary"), theme.getMessage("login.genAuthFailure"));
                    context.addMessage(this.getClientId(context), fm);
                }
                ec.getSessionMap().put(CONTROLLER_MAP_KEY, controllerClass);
                context.renderResponse();
            }
        } else if (state.equals((Object)LoginConstants.LOGINSTATE.CONTINUE)) {
            controllerClass = (LoginController)ec.getSessionMap().get(CONTROLLER_MAP_KEY);
            LoginCallback lcb = controllerClass.getCallbackObject();
            Map convertedValue = (Map)this.getConvertedValue(context, this.getSubmittedValue());
            for (String key : convertedValue.keySet()) {
                lcb.setCallbackDataValue(key, (String)convertedValue.get(key));
            }
            try {
                controllerClass.login(requestObj, lcb);
                lcb = controllerClass.getCallbackObject();
                LoginConstants.LOGINSTATE loginState = lcb.getLoginState();
                if (loginState.equals((Object)LoginConstants.LOGINSTATE.SUCCESS)) {
                    this.setValue(controllerClass.getAuthenticatedEntity());
                    this.setValid(true);
                } else if (loginState.equals((Object)LoginConstants.LOGINSTATE.FAILURE)) {
                    this.setValid(false);
                    this.setLoginState(LoginConstants.LOGINSTATE.FAILURE);
                    FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_ERROR, theme.getMessage("login.errorSummary"), theme.getMessage("login.ErrorDetail"));
                    context.addMessage(this.getClientId(context), fm);
                } else {
                    lcb = controllerClass.getCallbackObject();
                    this.setLoginState(LoginConstants.LOGINSTATE.CONTINUE);
                    context.renderResponse();
                }
                this.setCallbackObject(lcb);
            }
            catch (Exception e) {
                LogUtil.severe("Validation exception", e);
                controllerClass.abort(requestObj);
                this.setValid(false);
            }
        } else {
            throw new FacesException("Login component has reached an invalid state: " + (Object)((Object)state));
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return;
        }
        try {
            ve.setValue(context.getELContext(), this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
            return;
        }
        catch (Exception e) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "javax.faces.component.UIInput.CONVERSION", e.getMessage());
            context.addMessage(this.getClientId(context), message);
            if (LogUtil.configEnabled()) {
                LogUtil.config("Unable to update Model!", e);
            }
            this.setValid(false);
            return;
        }
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.loginClass = (String)_values[1];
        this.htmlTemplate = (String)_values[2];
        this.loginState = (LoginConstants.LOGINSTATE)((Object)_values[3]);
        this.redirectURL = (String)_values[4];
        this.serviceName = (String)_values[5];
        this.style = (String)_values[6];
        this.styleClass = (String)_values[7];
        this.callbackObject = (LoginCallback)_values[8];
        this.autoStart = (Boolean)_values[9];
        this.autoStart_set = (Boolean)_values[10];
        this.authenticationKeys = (Map)_values[11];
        this.loginController = (String)_values[12];
        this.immediate = (Boolean)_values[13];
        this.immediate_set = (Boolean)_values[14];
        this.tabIndex = (Integer)_values[15];
        this.tabIndex_set = (Boolean)_values[16];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.loginClass, this.htmlTemplate, this.loginState, this.redirectURL, this.serviceName, this.style, this.styleClass, this.callbackObject, this.autoStart ? Boolean.TRUE : Boolean.FALSE, this.autoStart_set ? Boolean.TRUE : Boolean.FALSE, this.authenticationKeys, this.loginController, this.immediate ? Boolean.TRUE : Boolean.FALSE, this.immediate_set ? Boolean.TRUE : Boolean.FALSE, new Integer(this.tabIndex), this.tabIndex_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }

    private Theme getTheme(FacesContext context) {
        return ThemeUtilities.getTheme(context);
    }
}

