/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.Tab;
import com.sun.webui.jsf.component.TabSet;
import com.sun.webui.jsf.component.WizardBranch;
import com.sun.webui.jsf.component.WizardStep;
import com.sun.webui.jsf.component.util.Util;
import com.sun.webui.jsf.event.WizardActionListener;
import com.sun.webui.jsf.event.WizardEvent;
import com.sun.webui.jsf.event.WizardEventListener;
import com.sun.webui.jsf.model.WizardModel;
import com.sun.webui.jsf.model.WizardModelBase;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class Wizard
extends UIComponentBase
implements NamingContainer {
    private int event = 10;
    private transient UIComponent eventSource;
    private transient String gotoStepId;
    private boolean stepTabActive = true;
    private static final String MODEL = "model";
    private static final Boolean WIZARD_TRUE = Boolean.TRUE;
    private static final Boolean WIZARD_FALSE = Boolean.FALSE;
    private static final String RESULTS_FACET = "results";
    private static final String NEXT_FACET = "next";
    private static final String PREVIOUS_FACET = "previous";
    private static final String FINISH_FACET = "finish";
    private static final String CANCEL_FACET = "cancel";
    private static final String CLOSE_FACET = "close";
    private static final String TABS_FACET = "tabs";
    private static final String TITLE_FACET = "title";
    private static final String INDICATOR_FACET = "stepIndicator";
    private static final String STEPS_PANE_TITLE = "stepsPaneTitle";
    private static final String USCORE = "_";
    private static final String STEP_TEXT = "stptxt";
    private static final String STEP_NUM = "stpnum";
    private static final String STEP_LINK = "stplnk";
    private static final String STEP_HELP = "stphlp";
    private static final String STEP_TITLE = "stpttl";
    private static final String STEP_TITLE_LABEL = "stpttllbl";
    private static final String STEP_DETAIL = "stpdtl";
    private static final String STEP_SUMMARY = "stpsmmy";
    private static final String STEP_PLACEHLDR = "stpplhld";
    private static final String STEP_TAB = "stptb";
    private static final String HELP_TAB = "hlptb";
    private static final String NUM = "num";
    private static final String DISABLED_ATTR = "disabled";
    private static final String IMMEDIATE_ATTR = "immediate";
    private static final String MINI_ATTR = "mini";
    private static final String ESCAPE_ATTR = "escape";
    private static final String ONCLICK_ATTR = "onClick";
    private static final String WIZARD_CANCEL = "Wizard.cancel";
    private static final String WIZARD_CLOSE = "Wizard.close";
    private static final String WIZARD_FINISH = "Wizard.finish";
    private static final String WIZARD_NEXT = "Wizard.next";
    private static final String WIZARD_PREVIOUS = "Wizard.previous";
    private static final String WIZARD_STEP_TITLE_LABEL = "Wizard.stepTitleLabel";
    private static final String WIZARD_STEP_TAB = "Wizard.stepTab";
    private static final String WIZARD_HELP_TAB = "Wizard.helpTab";
    private static final String WIZARD_SKIP_LINK_ALT = "Wizard.skipLinkAlt";
    private static final String WIZARD_CURRENT_STEP_ALT = "Wizard.currentStepAlt";
    private static final String WIZARD_TAB_TOOLTIP = "Wizard.tabToolTip";
    private static final String WIZARD_PLACEHOLDER_TEXT = "Wizard.placeholderText";
    private static final String WIZARD_STEPS_PANE_TITLE = "Wizard.stepsPaneTitle";
    private WizardEventListener eventListener = null;
    private boolean isPopup = false;
    private boolean isPopup_set = false;
    private WizardModel model = null;
    private String onCancel = null;
    private String onClose = null;
    private String onFinish = null;
    private String onHelpTab = null;
    private String onNext = null;
    private String onPopupDismiss = null;
    private String onPrevious = null;
    private String onStepLink = null;
    private String onStepsTab = null;
    private Object steps = null;
    private String style = null;
    private String styleClass = null;
    private String title = null;
    private boolean visible = false;
    private boolean visible_set = false;

    public Wizard() {
        this.setRendererType("com.sun.webui.jsf.Wizard");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Wizard";
    }

    public WizardModel getModel() {
        WizardModel wm = this._getModel();
        if (wm == null) {
            wm = new WizardModelBase();
            this.setModel(wm);
        }
        return wm;
    }

    private WizardModel _getModel() {
        if (this.model != null) {
            return this.model;
        }
        ValueExpression _vb = this.getValueExpression(MODEL);
        if (_vb != null) {
            return (WizardModel)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    private boolean prematureRender() {
        return this.getFacesContext().getRenderResponse();
    }

    public void decode(FacesContext context) {
        super.decode(context);
        WizardEvent wizardEvent = new WizardEvent(this);
        wizardEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
        this.queueEvent(wizardEvent);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.decodeControls(context);
        this.decodeStep(context);
    }

    protected void decodeControls(FacesContext context) {
        Iterator<UIComponent> kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            Object currentStep = null;
            UIComponent kid = kids.next();
            if (kid instanceof WizardStep) continue;
            kid.processDecodes(context);
        }
    }

    protected void decodeStep(FacesContext context) {
        WizardModel wizardModel = this.getModel();
        if (wizardModel.decode(this.event, this.prematureRender())) {
            wizardModel.getCurrentStep().processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.validateControls(context);
        this.validateStep(context);
    }

    protected void validateControls(FacesContext context) {
        Iterator<UIComponent> kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            if (kid instanceof WizardStep) continue;
            kid.processValidators(context);
        }
    }

    protected void validateStep(FacesContext context) {
        WizardModel wizardModel = this.getModel();
        if (wizardModel.validate(this.event, this.prematureRender())) {
            wizardModel.getCurrentStep().processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.updateControls(context);
        this.updateStep(context);
    }

    protected void updateControls(FacesContext context) {
        Iterator<UIComponent> kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            if (kid instanceof WizardStep) continue;
            kid.processUpdates(context);
        }
    }

    protected void updateStep(FacesContext context) {
        WizardModel wizardModel = this.getModel();
        if (wizardModel.update(this.event, this.prematureRender())) {
            wizardModel.getCurrentStep().processUpdates(context);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String rendererType;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.event == 10) {
            this.broadcastStartEvent();
            this.event = 12;
        }
        if ((rendererType = this.getRendererType()) != null) {
            this.getRenderer(context).encodeBegin(context, this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.getModel().initialize(this);
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeChildren(context, this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, this);
        }
        if (this.isComplete()) {
            this.getModel().complete();
            this.broadcastCompleteEvent();
            this.event = 10;
        } else {
            this.event = 12;
        }
    }

    public Iterator getStepListIterator() {
        return this.getModel().getWizardStepList().iterator();
    }

    public boolean isComplete() {
        return this.getModel().isComplete();
    }

    public boolean isCurrentStep(WizardStep step) {
        return this.getModel().isCurrentStep(step);
    }

    public WizardStep getCurrentStep() {
        return this.getModel().getCurrentStep();
    }

    public boolean hasStepHelp() {
        return this.getModel().hasStepHelp();
    }

    public boolean hasClose() {
        WizardModel wm = this.getModel();
        return wm.hasClose(wm.getCurrentStep());
    }

    public boolean hasNext() {
        WizardModel wm = this.getModel();
        return wm.hasNext(wm.getCurrentStep());
    }

    public boolean hasPrevious() {
        WizardModel wm = this.getModel();
        return wm.hasPrevious(wm.getCurrentStep());
    }

    public boolean hasFinish() {
        WizardModel wm = this.getModel();
        return wm.hasFinish(wm.getCurrentStep());
    }

    public boolean hasCancel() {
        WizardModel wm = this.getModel();
        return wm.hasCancel(wm.getCurrentStep());
    }

    public boolean isCloseDisabled() {
        WizardModel wm = this.getModel();
        return wm.isCloseDisabled(wm.getCurrentStep());
    }

    public boolean isNextDisabled() {
        WizardModel wm = this.getModel();
        return wm.isNextDisabled(wm.getCurrentStep());
    }

    public boolean isPreviousDisabled() {
        WizardModel wm = this.getModel();
        return wm.isPreviousDisabled(wm.getCurrentStep());
    }

    public boolean isFinishDisabled() {
        WizardModel wm = this.getModel();
        return wm.isFinishDisabled(wm.getCurrentStep());
    }

    public boolean isCancelDisabled() {
        WizardModel wm = this.getModel();
        return wm.isCancelDisabled(wm.getCurrentStep());
    }

    public boolean isStepsTabActive() {
        return this.stepTabActive || !this.hasStepHelp();
    }

    public String getCurrentStepNumberString() {
        return this.getModel().getWizardStepList().getCurrentStepNumberString();
    }

    public UIComponent getCancelComponent() {
        return this.getButtonComponent(CANCEL_FACET, WIZARD_CANCEL, this.isCancelDisabled(), 0, true, this.getJavaScript(0), false);
    }

    public UIComponent getCloseComponent() {
        return this.getButtonComponent(CLOSE_FACET, WIZARD_CLOSE, this.isCloseDisabled(), 1, true, this.getJavaScript(1), true);
    }

    public UIComponent getFinishComponent() {
        return this.getButtonComponent(FINISH_FACET, WIZARD_FINISH, this.isFinishDisabled(), 2, true, this.getJavaScript(2), true);
    }

    public UIComponent getNextComponent() {
        return this.getButtonComponent(NEXT_FACET, WIZARD_NEXT, this.isNextDisabled(), 6, true, this.getJavaScript(6), true);
    }

    public UIComponent getPreviousComponent() {
        return this.getButtonComponent(PREVIOUS_FACET, WIZARD_PREVIOUS, this.isPreviousDisabled(), 7, true, this.getJavaScript(7), false);
    }

    protected UIComponent getButtonComponent(String facetName, String textKey, boolean disabled, int wizardEvent, boolean immediate, String javascript) {
        return this.getButtonComponent(facetName, textKey, disabled, wizardEvent, immediate, javascript, true);
    }

    protected UIComponent getButtonComponent(String facetName, String textKey, boolean disabled, int wizardEvent, boolean immediate, String javascript, boolean primary) {
        Button button = (Button)ComponentUtilities.getPrivateFacet(this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId(this, facetName));
            button.setImmediate(immediate);
            button.setPrimary(primary);
            button.addActionListener(new WizardActionListener(this.getId(), wizardEvent));
            ComponentUtilities.putPrivateFacet(this, facetName, button);
        }
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        button.setText(theme.getMessage(textKey));
        button.setDisabled(disabled);
        if (javascript != null) {
            button.setOnClick(javascript);
        }
        return button;
    }

    public UIComponent getTabsComponent() {
        return this.getModel().hasStepHelp() ? this.getTabsComponent(TABS_FACET) : null;
    }

    protected UIComponent getTabsComponent(String facetName) {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        TabSet tabSet = (TabSet)ComponentUtilities.getPrivateFacet(this, facetName, true);
        if (tabSet == null) {
            tabSet = new TabSet();
            tabSet.setImmediate(true);
            tabSet.setId(ComponentUtilities.createPrivateFacetId(this, facetName));
            tabSet.setMini(true);
            List<UIComponent> tabs = tabSet.getChildren();
            Tab steptab = this.getTab(theme, STEP_TAB, WIZARD_STEP_TAB, WIZARD_TAB_TOOLTIP, 8, this.stepTabActive, true, this.getJavaScript(8));
            tabs.add(steptab);
            Tab helptab = this.getTab(theme, HELP_TAB, WIZARD_HELP_TAB, WIZARD_TAB_TOOLTIP, 4, !this.stepTabActive, true, this.getJavaScript(4));
            tabs.add(helptab);
            tabSet.setSelected(this.stepTabActive ? steptab.getId() : helptab.getId());
            ComponentUtilities.putPrivateFacet(this, facetName, tabSet);
            return tabSet;
        }
        List<UIComponent> tabs = tabSet.getChildren();
        Iterator<UIComponent> itabs = tabs.iterator();
        String stepsId = ComponentUtilities.createPrivateFacetId(this, STEP_TAB);
        String helpId = ComponentUtilities.createPrivateFacetId(this, HELP_TAB);
        while (itabs.hasNext()) {
            UIComponent tab = itabs.next();
            if (!(tab instanceof Tab)) continue;
            String tabid = tab.getId();
            if (stepsId.equals(tabid)) {
                this.initTab((Tab)tab, theme, WIZARD_STEP_TAB, WIZARD_TAB_TOOLTIP, this.stepTabActive, true, this.getJavaScript(8));
                continue;
            }
            if (!helpId.equals(tabid)) continue;
            this.initTab((Tab)tab, theme, WIZARD_HELP_TAB, WIZARD_TAB_TOOLTIP, !this.stepTabActive, true, this.getJavaScript(4));
        }
        tabSet.setSelected(this.stepTabActive ? stepsId : helpId);
        return tabSet;
    }

    protected Tab getTab(Theme theme, String facetName, String text, String toolTip, int wizardEvent, boolean selected, boolean immediate, String javascript) {
        Tab tab = new Tab();
        tab.setId(ComponentUtilities.createPrivateFacetId(this, facetName));
        tab.addActionListener(new WizardActionListener(this.getId(), wizardEvent));
        this.initTab(tab, theme, text, toolTip, selected, immediate, javascript);
        return tab;
    }

    private void initTab(Tab tab, Theme theme, String text, String toolTip, boolean selected, boolean immediate, String javascript) {
        text = theme.getMessage(text);
        tab.setText(text);
        tab.setToolTip(selected ? theme.getMessage(toolTip, new Object[]{text}) : text);
        tab.setImmediate(immediate);
        if (javascript != null) {
            tab.setOnClick(javascript);
        }
    }

    public UIComponent getStepIndicatorComponent() {
        UIComponent child = this.getFacet(INDICATOR_FACET);
        if (child != null) {
            return child;
        }
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        Icon icon = ThemeUtilities.getIcon(theme, "WIZARD_ARROW");
        String id = ComponentUtilities.createPrivateFacetId(this, INDICATOR_FACET);
        icon.setId(id);
        icon.setParent(this);
        icon.setHspace(4);
        String toolTip = theme.getMessage(WIZARD_CURRENT_STEP_ALT);
        icon.setToolTip(toolTip);
        icon.setAlt(toolTip);
        return icon;
    }

    public UIComponent getSteplinkComponent(String id, String text, int wizardEvent, boolean immediate, String javascript) {
        Hyperlink hlink = (Hyperlink)Util.findChild(this, id, null);
        if (hlink == null) {
            hlink = new Hyperlink();
            hlink.setId(id);
            hlink.addActionListener(new WizardActionListener(this.getId(), wizardEvent));
            hlink.setImmediate(immediate);
            this.getChildren().add(hlink);
        }
        hlink.setText(text);
        if (javascript != null) {
            hlink.setOnClick(javascript);
        }
        return hlink;
    }

    public UIComponent getStepsPaneComponent() {
        return null;
    }

    public UIComponent getStepsBarComponent() {
        return null;
    }

    public UIComponent getStepListComponent() {
        return null;
    }

    public UIComponent getStepHelpComponent() {
        return null;
    }

    public UIComponent getStepTitleComponent() {
        return null;
    }

    public UIComponent getStepDetailComponent() {
        return null;
    }

    public UIComponent getTaskStepComponent() {
        return null;
    }

    public UIComponent getTaskComponent() {
        return null;
    }

    public UIComponent getTaskHeaderComponent() {
        return null;
    }

    public UIComponent getControlBarComponent() {
        return null;
    }

    public UIComponent getLeftControlBarComponent() {
        return null;
    }

    public UIComponent getRightControlBarComponent() {
        return null;
    }

    public UIComponent getStepTitleLabelTextComponent() {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        return this.getStepStaticTextComponent(this.getCurrentStep(), STEP_TITLE_LABEL, theme.getMessage(WIZARD_STEP_TITLE_LABEL, new Object[]{this.getCurrentStepNumberString()}));
    }

    public UIComponent getStepTitleTextComponent() {
        WizardStep step = this.getCurrentStep();
        return this.getStepStaticTextComponent(step, STEP_TITLE, step.getTitle());
    }

    public UIComponent getStepDetailTextComponent() {
        WizardStep step = this.getCurrentStep();
        return this.getStepStaticTextComponent(step, STEP_DETAIL, step.getDetail());
    }

    public UIComponent getStepSummaryComponent(WizardStep step) {
        String stepId = step.getId();
        if (this.getModel().canGotoStep(step)) {
            String id = ComponentUtilities.createPrivateFacetId(this, STEP_LINK);
            id = id.concat(USCORE).concat(stepId);
            return this.getSteplinkComponent(id, step.getSummary(), 3, true, this.getJavaScript(3));
        }
        return this.getStepStaticTextComponent(step, STEP_SUMMARY, step.getSummary());
    }

    public UIComponent getStepPlaceholderTextComponent(WizardStep step) {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        String placeholderText = ((WizardBranch)step).getPlaceholderText();
        return this.getStepStaticTextComponent(step, STEP_PLACEHLDR, theme.getMessage(WIZARD_PLACEHOLDER_TEXT, new Object[]{placeholderText}));
    }

    public UIComponent getStepNumberComponent(WizardStep step, String numberString) {
        String stepId = step.getId();
        if (this.getModel().canGotoStep(step)) {
            String numStpLnk = NUM.concat(USCORE).concat(STEP_LINK);
            String id = ComponentUtilities.createPrivateFacetId(this, numStpLnk);
            id = id.concat(USCORE).concat(stepId);
            return this.getSteplinkComponent(id, numberString, 3, true, this.getJavaScript(3));
        }
        return this.getStepStaticTextComponent(step, STEP_NUM, numberString);
    }

    public UIComponent getStepHelpTextComponent() {
        WizardStep step = this.getCurrentStep();
        UIComponent stepHelp = this.getStepStaticTextComponent(this.getCurrentStep(), STEP_HELP, step.getHelp());
        if (stepHelp != null) {
            stepHelp.getAttributes().put(ESCAPE_ATTR, WIZARD_FALSE);
        }
        return stepHelp;
    }

    public UIComponent getTitleComponent() {
        return this.getStaticTextComponent(TITLE_FACET, this.getTitle());
    }

    public UIComponent getStepsPaneTitleComponent() {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        String title = theme.getMessage(WIZARD_STEPS_PANE_TITLE);
        UIComponent stepsPaneTitle = this.getStaticTextComponent(STEPS_PANE_TITLE, title);
        return stepsPaneTitle;
    }

    protected UIComponent getStaticTextComponent(String facetName, String text) {
        UIComponent child = this.getFacet(facetName);
        if (child != null) {
            return child;
        }
        StaticText txt = new StaticText();
        String id = ComponentUtilities.createPrivateFacetId(this, facetName);
        txt.setId(id);
        txt.setText(text);
        txt.setParent(this);
        return txt;
    }

    protected UIComponent getStepStaticTextComponent(WizardStep step, String facetName, String stepText) {
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId(step, facetName));
        text.setParent(this);
        text.setText(stepText);
        return text;
    }

    protected UIComponent getStaticTextComponent() {
        return new StaticText();
    }

    protected UIComponent getStepStaticTextComponent(String id, String stepText) {
        StaticText text = new StaticText();
        text.setId(id);
        text.setParent(this);
        text.setText(stepText);
        return text;
    }

    public static Wizard getWizard(UIComponent child, String wizardId) {
        return (Wizard)Wizard.findAncestor(child, wizardId);
    }

    private static UIComponent findAncestor(UIComponent descendant, String ancestorId) {
        if (ancestorId == null || descendant == null) {
            return null;
        }
        for (UIComponent parent = descendant.getParent(); parent != null; parent = parent.getParent()) {
            if (!ancestorId.equals(parent.getId())) continue;
            return parent;
        }
        return null;
    }

    public void broadcastEvent(UIComponent source, int event) throws AbortProcessingException {
        this.event = event;
        this.eventSource = source;
        this.gotoStepId = null;
        switch (event) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                String id = source.getId();
                String suffix = STEP_LINK.concat(USCORE);
                this.gotoStepId = id.substring(id.lastIndexOf(suffix) + suffix.length());
                break;
            }
            case 4: {
                this.stepTabActive = false;
                break;
            }
            case 8: {
                this.stepTabActive = true;
            }
        }
        throw new AbortProcessingException();
    }

    protected void broadcastStartEvent() {
        WizardEventListener listener = this.getEventListener();
        if (listener != null) {
            WizardEvent wizardEvent = new WizardEvent(this, null, 10, null, null);
            try {
                listener.handleEvent(wizardEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void broadcastCompleteEvent() {
        WizardEventListener listener = this.getEventListener();
        if (listener != null) {
            WizardEvent wizardEvent = new WizardEvent(this, null, 11, null, null);
            try {
                listener.handleEvent(wizardEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        if (facesEvent instanceof WizardEvent) {
            boolean result = true;
            WizardStep step = this.getCurrentStep();
            WizardEventListener listener = step == null ? null : step.getEventListener();
            WizardEvent wizardEvent = new WizardEvent(this, this.eventSource, this.event, step, this.gotoStepId);
            try {
                if (listener != null) {
                    result = listener.handleEvent(wizardEvent);
                }
                if ((listener = this.getEventListener()) != null) {
                    result = listener.handleEvent(wizardEvent);
                }
            }
            catch (Exception e) {
                result = true;
                this.event = 0;
                wizardEvent.setEvent(this.event);
            }
            if (result) {
                this.getModel().handleEvent(wizardEvent);
            }
        }
    }

    private String getJavaScript(int javaScriptEvent) {
        String js = null;
        WizardStep step = this.getCurrentStep();
        switch (javaScriptEvent) {
            case 6: {
                js = step.getOnNext();
                if (js != null) break;
                js = this.getOnNext();
                break;
            }
            case 7: {
                js = step.getOnPrevious();
                if (js != null) break;
                js = this.getOnPrevious();
                break;
            }
            case 0: {
                js = step.getOnCancel();
                if (js != null) break;
                js = this.getOnCancel();
                break;
            }
            case 1: {
                js = step.getOnClose();
                if (js != null) break;
                js = this.getOnClose();
                break;
            }
            case 2: {
                js = step.getOnFinish();
                if (js != null) break;
                js = this.getOnFinish();
                break;
            }
            case 3: {
                js = step.getOnStepLink();
                if (js != null) break;
                js = this.getOnStepLink();
                break;
            }
            case 4: {
                js = step.getOnHelpTab();
                if (js != null) break;
                js = this.getOnHelpTab();
                break;
            }
            case 8: {
                js = step.getOnStepsTab();
                if (js != null) break;
                js = this.getOnStepsTab();
            }
        }
        return js;
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public WizardEventListener getEventListener() {
        if (this.eventListener != null) {
            return this.eventListener;
        }
        ValueExpression _vb = this.getValueExpression("eventListener");
        if (_vb != null) {
            return (WizardEventListener)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setEventListener(WizardEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public boolean isIsPopup() {
        if (this.isPopup_set) {
            return this.isPopup;
        }
        ValueExpression _vb = this.getValueExpression("isPopup");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setIsPopup(boolean isPopup) {
        this.isPopup = isPopup;
        this.isPopup_set = true;
    }

    public void setModel(WizardModel model) {
        this.model = model;
    }

    public String getOnCancel() {
        if (this.onCancel != null) {
            return this.onCancel;
        }
        ValueExpression _vb = this.getValueExpression("onCancel");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnCancel(String onCancel) {
        this.onCancel = onCancel;
    }

    public String getOnClose() {
        if (this.onClose != null) {
            return this.onClose;
        }
        ValueExpression _vb = this.getValueExpression("onClose");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClose(String onClose) {
        this.onClose = onClose;
    }

    public String getOnFinish() {
        if (this.onFinish != null) {
            return this.onFinish;
        }
        ValueExpression _vb = this.getValueExpression("onFinish");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnFinish(String onFinish) {
        this.onFinish = onFinish;
    }

    public String getOnHelpTab() {
        if (this.onHelpTab != null) {
            return this.onHelpTab;
        }
        ValueExpression _vb = this.getValueExpression("onHelpTab");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnHelpTab(String onHelpTab) {
        this.onHelpTab = onHelpTab;
    }

    public String getOnNext() {
        if (this.onNext != null) {
            return this.onNext;
        }
        ValueExpression _vb = this.getValueExpression("onNext");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnNext(String onNext) {
        this.onNext = onNext;
    }

    public String getOnPopupDismiss() {
        if (this.onPopupDismiss != null) {
            return this.onPopupDismiss;
        }
        ValueExpression _vb = this.getValueExpression("onPopupDismiss");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnPopupDismiss(String onPopupDismiss) {
        this.onPopupDismiss = onPopupDismiss;
    }

    public String getOnPrevious() {
        if (this.onPrevious != null) {
            return this.onPrevious;
        }
        ValueExpression _vb = this.getValueExpression("onPrevious");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnPrevious(String onPrevious) {
        this.onPrevious = onPrevious;
    }

    public String getOnStepLink() {
        if (this.onStepLink != null) {
            return this.onStepLink;
        }
        ValueExpression _vb = this.getValueExpression("onStepLink");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnStepLink(String onStepLink) {
        this.onStepLink = onStepLink;
    }

    public String getOnStepsTab() {
        if (this.onStepsTab != null) {
            return this.onStepsTab;
        }
        ValueExpression _vb = this.getValueExpression("onStepsTab");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnStepsTab(String onStepsTab) {
        this.onStepsTab = onStepsTab;
    }

    public Object getSteps() {
        if (this.steps != null) {
            return this.steps;
        }
        ValueExpression _vb = this.getValueExpression("steps");
        if (_vb != null) {
            return _vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSteps(Object steps) {
        this.steps = steps;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression _vb = this.getValueExpression("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        ValueExpression _vb = this.getValueExpression(TITLE_FACET);
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public void processRestoreState(FacesContext context, Object state) {
        super.processRestoreState(context, state);
        this.getModel().initialize(this);
        this.event = 12;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.eventListener = (WizardEventListener)Wizard.restoreAttachedState(_context, _values[1]);
        this.isPopup = (Boolean)_values[2];
        this.isPopup_set = (Boolean)_values[3];
        this.model = (WizardModel)Wizard.restoreAttachedState(_context, _values[4]);
        this.onCancel = (String)_values[5];
        this.onClose = (String)_values[6];
        this.onFinish = (String)_values[7];
        this.onHelpTab = (String)_values[8];
        this.onNext = (String)_values[9];
        this.onPopupDismiss = (String)_values[10];
        this.onPrevious = (String)_values[11];
        this.onStepLink = (String)_values[12];
        this.onStepsTab = (String)_values[13];
        this.steps = Wizard.restoreAttachedState(_context, _values[14]);
        this.style = (String)_values[15];
        this.styleClass = (String)_values[16];
        this.title = (String)_values[17];
        this.visible = (Boolean)_values[18];
        this.visible_set = (Boolean)_values[19];
        this.stepTabActive = (Boolean)_values[20];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), Wizard.saveAttachedState(_context, this.eventListener), this.isPopup ? Boolean.TRUE : Boolean.FALSE, this.isPopup_set ? Boolean.TRUE : Boolean.FALSE, Wizard.saveAttachedState(_context, this.model), this.onCancel, this.onClose, this.onFinish, this.onHelpTab, this.onNext, this.onPopupDismiss, this.onPrevious, this.onStepLink, this.onStepsTab, Wizard.saveAttachedState(_context, this.steps), this.style, this.styleClass, this.title, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE, this.stepTabActive ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

