/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.util.LogUtil;
import java.util.HashMap;
import javax.faces.FactoryFinder;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class TableSelectPhaseListener
implements PhaseListener {
    private Object unselected = null;
    private HashMap selected = new HashMap();
    private boolean keepSelected = false;

    public TableSelectPhaseListener() {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener(this);
    }

    public TableSelectPhaseListener(boolean keepSelected) {
        this();
        this.keepSelected(keepSelected);
    }

    public TableSelectPhaseListener(Object unselected) {
        this();
        this.unselected = unselected;
    }

    public void afterPhase(PhaseEvent event) {
        if (!this.keepSelected) {
            this.selected.clear();
        } else {
            this.log("afterPhase", "Selected values not cleared, keepSelected is false");
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void clear() {
        this.selected.clear();
    }

    public Object getSelected(RowKey rowKey) {
        Object object = rowKey != null ? (Object)this.selected.get(rowKey.getRowId()) : null;
        return object != null ? object : this.unselected;
    }

    public boolean isKeepSelected() {
        return this.keepSelected;
    }

    public boolean isSelected(RowKey rowKey) {
        Object object = this.getSelected(rowKey);
        return object != null && object != this.unselected;
    }

    public void keepSelected(boolean keepSelected) {
        this.keepSelected = keepSelected;
    }

    public void setSelected(RowKey rowKey, Object object) {
        if (rowKey != null) {
            this.selected.put(rowKey.getRowId(), object);
        }
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

