/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeImage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indicator
implements Comparable<Indicator>,
StateHolder {
    private String type = null;
    private int sortValue = 0;
    private String imageKey = null;
    private UIComponent imageComponent = null;
    private boolean transientValue = false;

    public Indicator(String imageKey, String type, int sortValue) {
        if (imageKey == null || imageKey.length() == 0 || type == null || type.length() == 0) {
            throw new IllegalArgumentException("Neither imageKey nor type can be null or empty string.");
        }
        this.imageKey = imageKey;
        this.type = type;
        this.sortValue = sortValue;
    }

    public Indicator(UIComponent imageComponent, String type, int sortValue) {
        if (imageComponent == null || type == null || type.length() == 0) {
            throw new IllegalArgumentException("Neither imageComponent nor type can be null or empty string.");
        }
        this.imageComponent = imageComponent;
        this.type = type;
        this.sortValue = sortValue;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public UIComponent getImageComponent(Theme theme) {
        ThemeImage themeImage;
        if (this.imageComponent != null) {
            return this.imageComponent;
        }
        if (this.imageKey != null && (themeImage = theme.getImage(this.imageKey)) != null) {
            return ThemeUtilities.getIcon(theme, this.imageKey);
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public int getSortValue() {
        return this.sortValue;
    }

    @Override
    public int compareTo(Indicator indicator) {
        if (indicator == null) {
            return 1;
        }
        if (this.sortValue < indicator.getSortValue()) {
            return 1;
        }
        if (this.sortValue > indicator.getSortValue()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        try {
            return this.type.equals(((Indicator)obj).getType());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.imageKey, new Integer(this.sortValue), this.imageComponent.saveState(context)};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.imageKey = (String)values[0];
        this.sortValue = (Integer)values[1];
        this.imageComponent = (UIComponent)values[2];
        this.imageComponent.restoreState(context, values[2]);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void setTransient(boolean transientValue) {
    }
}

