/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.component.WizardStep;
import com.sun.webui.jsf.model.WizardModel;
import com.sun.webui.jsf.model.WizardStepList;
import com.sun.webui.jsf.model.WizardStepListItemBase;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WizardStepListBase
implements WizardStepList {
    private WizardModel wModel;
    private int currentStep;
    private String currentStepNumberString;
    private static final String DOT = ".";
    private static final String SWBRACKET_OPEN = "[";
    private static final String SWBRACKET_CLOSE = "[";

    public WizardStepListBase(WizardModel wModel) {
        this.wModel = wModel;
        this.iterate();
    }

    public String getCurrentStepNumberString() {
        return this.currentStepNumberString;
    }

    protected String formatStepNumber(int stepNumber) {
        return String.valueOf(stepNumber);
    }

    protected String formatSubstepNumber(int stepNumber, int substep) {
        return String.valueOf(stepNumber).concat(DOT).concat(String.valueOf(substep));
    }

    protected String formatBranch(String placeholderText) {
        return "[".concat(placeholderText).concat("[");
    }

    private void iterate() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            private int stepNumber = 0;
            private int substep = 0;
            private String stepNumberString;
            private String placeholderText;
            private boolean isBranch;
            private Iterator wizardStepIterator = WizardStepListBase.access$000(WizardStepListBase.this).getWizardStepIterator();

            public boolean hasNext() {
                return this.wizardStepIterator.hasNext();
            }

            public Object next() throws NoSuchElementException {
                if (this.isBranch) {
                    throw new NoSuchElementException("No more steps after branch");
                }
                boolean isCurrentStep = false;
                try {
                    WizardStep step = (WizardStep)this.wizardStepIterator.next();
                    boolean isSubstep = WizardStepListBase.this.wModel.isSubstep(step);
                    this.isBranch = WizardStepListBase.this.wModel.isBranch(step);
                    this.placeholderText = null;
                    if (isSubstep) {
                        ++this.substep;
                        this.stepNumberString = WizardStepListBase.this.formatSubstepNumber(this.stepNumber, this.substep);
                    } else if (this.isBranch) {
                        ++this.stepNumber;
                        this.substep = 0;
                        this.stepNumberString = null;
                    } else {
                        ++this.stepNumber;
                        this.substep = 0;
                        this.stepNumberString = WizardStepListBase.this.formatStepNumber(this.stepNumber);
                    }
                    isCurrentStep = WizardStepListBase.this.wModel.isCurrentStep(step);
                    if (isCurrentStep) {
                        WizardStepListBase.this.currentStep = this.stepNumber;
                        WizardStepListBase.this.currentStepNumberString = this.stepNumberString;
                    }
                    return new WizardStepListItemBase(step, this.stepNumberString, isCurrentStep, isSubstep, this.isBranch, this.placeholderText, WizardStepListBase.this.wModel.canGotoStep(step));
                }
                catch (Exception e) {
                    NoSuchElementException nse = new NoSuchElementException();
                    nse.initCause(e);
                    throw nse;
                }
            }

            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }
}

