/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model.login;

import com.sun.webui.jsf.model.login.LoginCallback;
import com.sun.webui.jsf.model.login.LoginConstants;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LoginCallbackHandler
implements CallbackHandler {
    private HttpServletRequest request = null;
    private HttpSession session = null;
    private Locale locale = null;
    private String thisVB = null;
    private String curVB = null;
    private static final long WAIT_TIMEOUT = 3600000L;

    public LoginCallbackHandler(HttpServletRequest req) {
        this.request = req;
        this.session = req.getSession();
        this.locale = req.getLocale();
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            throw new IOException("Empty or null callback array");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            try {
                LoginCallback lcb = (LoginCallback)callbacks[i];
                if (lcb == null) continue;
                lcb.setLocale(this.locale);
                lcb = this.waitUserData(lcb);
                continue;
            }
            catch (Exception e) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginCallback waitUserData(LoginCallback lcb) {
        Thread currentThread = Thread.currentThread();
        String callbackStatus = null;
        Thread thread = currentThread;
        synchronized (thread) {
            try {
                callbackStatus = (String)this.session.getAttribute("clientconv");
                if (callbackStatus != null) {
                    lcb = (LoginCallback)this.session.getAttribute("dataParms");
                    this.session.removeAttribute("clientconv");
                    return lcb;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        thread = currentThread;
        synchronized (thread) {
            lcb.setLoginState(LoginConstants.LOGINSTATE.CONTINUE);
            this.session.setAttribute("serverconv", lcb);
            currentThread.notifyAll();
        }
        thread = currentThread;
        synchronized (thread) {
            try {
                callbackStatus = (String)this.session.getAttribute("clientconv");
                long now = System.currentTimeMillis();
                while (callbackStatus == null) {
                    currentThread.wait(3600000L);
                    callbackStatus = (String)this.session.getAttribute("clientconv");
                    lcb = (LoginCallback)this.session.getAttribute("dataParms");
                    if (3600000L >= System.currentTimeMillis() - now) continue;
                }
                this.session.removeAttribute("clientconv");
                this.session.removeAttribute("dataParms");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return lcb;
    }
}

